/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.client.actor;

import com.trs.idm.client.actor.ActorException;
import com.trs.idm.client.actor.FormValues;
import com.trs.idm.client.actor.IServletAppActor;
import com.trs.idm.client.actor.SSOGroup;
import com.trs.idm.client.actor.SSOUser;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public abstract class StdHttpSessionBasedActor
implements IServletAppActor {
    private static final Logger LOG = Logger.getLogger(StdHttpSessionBasedActor.class);

    @Override
    public void start(ServletContext application) {
        LOG.info((Object)("actor start, application" + application));
    }

    @Override
    public void stop() {
        LOG.info((Object)"actor stop ");
    }

    public abstract boolean checkLocalLogin(HttpSession var1) throws ActorException;

    public abstract void logout(HttpSession var1) throws ActorException;

    public abstract void loadLoginUser(HttpServletRequest var1, SSOUser var2) throws ActorException;

    @Override
    public FormValues extractExtraInput(HttpServletRequest request) throws ActorException {
        String sourceName = request.getParameter("sourceName");
        FormValues values = new FormValues();
        values.put("sourceName", sourceName);
        LOG.info((Object)("extract extra login info, request = " + values.toString()));
        return values;
    }

    @Override
    public void loadAnonymous(HttpServletRequest request) throws ActorException {
    }

    @Override
    public boolean unremoveUser(SSOUser user, HttpServletRequest request) throws ActorException {
        throw new ActorException("not implement unremoveUser()!");
    }

    @Override
    public final boolean checkLocalLogin(HttpServletRequest request) throws ActorException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        return this.checkLocalLogin(session);
    }

    @Override
    public final void logout(HttpServletRequest request, HttpServletResponse response) throws ActorException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        this.logout(session);
    }

    @Override
    public final void loadLoginUser(HttpServletRequest request, HttpServletResponse response, SSOUser user) throws ActorException {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return;
        }
        this.loadLoginUser(request, user);
    }

    @Override
    public final boolean useStandardHttpSession() {
        return true;
    }

    @Override
    public final String getSessionId(HttpServletRequest request, HttpServletResponse response, boolean create) throws ActorException {
        HttpSession session = request.getSession(create);
        if (session == null) {
            LOG.debug((Object)"can not get HttpSession, so reuturn null.");
            return null;
        }
        return session.getId();
    }

    @Override
    public boolean addGroup(SSOGroup group, HttpServletRequest req) {
        LOG.info((Object)("add group, group:" + group));
        return true;
    }

    @Override
    public boolean delGroup(SSOGroup group, HttpServletRequest req) {
        LOG.info((Object)("delete group:" + group));
        return true;
    }

    @Override
    public boolean updateGroup(SSOGroup group, HttpServletRequest req) {
        LOG.info((Object)("update group, group:" + group));
        return true;
    }

    @Override
    public boolean moveToGroup(SSOUser user, SSOGroup group) throws ActorException {
        LOG.info((Object)("move user:" + user + " to  group:" + group.getGroupProperty()));
        return true;
    }

    @Override
    public boolean removeFromGroup(SSOUser user, SSOGroup group) throws ActorException {
        LOG.info((Object)("move user:" + user + " from group:" + group.getGroupProperty()));
        return true;
    }
}

