/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import com.trs.dev4.jdk16.utils.Substring;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtil {
    private static final Pattern patternQuote = Pattern.compile("\"[^\"]+\"");

    public static boolean hasCharOfStr2(String str1, String str2) {
        if (str1 == null || str2 == null || str1.trim().length() == 0 || str2.trim().length() == 0) {
            return false;
        }
        int i = 0;
        while (i < str2.length()) {
            if (str1.contains(String.valueOf(str2.charAt(i)))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isIPStyle(String ipTobeChecked) {
        String test = "([1-9]|[1-9]\\d|1\\d{2}|2[0-1]\\d|22[0-3])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        Pattern pattern = Pattern.compile(test);
        Matcher matcher = pattern.matcher(ipTobeChecked);
        return matcher.matches();
    }

    public static boolean isTimeStyle(String time) {
        String test = "([1-9]\\d{3})-(([0][1-9])|([1][0-2]))-(([0][1-9])|([1-2]\\d)|([3][0-1]))\\s+([0][1-9]|[1]\\d|[2][0-3]):([0-5]\\d):([0-5]\\d)";
        Pattern pattern = Pattern.compile(test);
        Matcher matcher = pattern.matcher(time);
        return matcher.matches();
    }

    public static List<Substring> getSubstringsByQuote(String str) {
        Matcher matcher = patternQuote.matcher(str);
        ArrayList<Substring> lst = new ArrayList<Substring>();
        while (matcher.find()) {
            lst.add(new Substring(str, matcher.start(), matcher.end()));
        }
        return lst;
    }
}

