/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

public class CipherUtil {
    public String startCode = "^`";
    private static final char[] ENCODE_ARRAY = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '-', '_'};
    private static final byte[] DECODE_ARRAY = new byte[256];

    static {
        int i = 0;
        while (i < 255) {
            CipherUtil.DECODE_ARRAY[i] = -1;
            ++i;
        }
        i = 0;
        while (i < ENCODE_ARRAY.length) {
            CipherUtil.DECODE_ARRAY[CipherUtil.ENCODE_ARRAY[i]] = (byte)i;
            ++i;
        }
    }

    private static String encode(byte[] inbuf) {
        if (inbuf.length == 0) {
            return "";
        }
        byte[] outbuf = new byte[(inbuf.length + 2) / 3 * 4];
        int inpos = 0;
        int outpos = 0;
        int size = inbuf.length;
        while (size > 0) {
            byte c;
            byte b;
            byte a;
            if (size == 1) {
                a = inbuf[inpos++];
                b = 0;
                outbuf[outpos++] = (byte)ENCODE_ARRAY[a >>> 2 & 0x3F];
                outbuf[outpos++] = (byte)ENCODE_ARRAY[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
                outbuf[outpos++] = 46;
                outbuf[outpos++] = 46;
            } else if (size == 2) {
                a = inbuf[inpos++];
                b = inbuf[inpos++];
                c = 0;
                outbuf[outpos++] = (byte)ENCODE_ARRAY[a >>> 2 & 0x3F];
                outbuf[outpos++] = (byte)ENCODE_ARRAY[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
                outbuf[outpos++] = (byte)ENCODE_ARRAY[(b << 2 & 0x3C) + (c >>> 6 & 3)];
                outbuf[outpos++] = 46;
            } else {
                a = inbuf[inpos++];
                b = inbuf[inpos++];
                c = inbuf[inpos++];
                outbuf[outpos++] = (byte)ENCODE_ARRAY[a >>> 2 & 0x3F];
                outbuf[outpos++] = (byte)ENCODE_ARRAY[(a << 4 & 0x30) + (b >>> 4 & 0xF)];
                outbuf[outpos++] = (byte)ENCODE_ARRAY[(b << 2 & 0x3C) + (c >>> 6 & 3)];
                outbuf[outpos++] = (byte)ENCODE_ARRAY[c & 0x3F];
            }
            size -= 3;
        }
        return new String(outbuf);
    }

    private static byte[] decode(byte[] inbuf) {
        int size = inbuf.length / 4 * 3;
        if (size == 0) {
            return inbuf;
        }
        if (inbuf[inbuf.length - 1] == 46) {
            --size;
            if (inbuf[inbuf.length - 2] == 46) {
                --size;
            }
        }
        byte[] outbuf = new byte[size];
        int inpos = 0;
        int outpos = 0;
        size = inbuf.length;
        while (size > 0) {
            byte a = DECODE_ARRAY[inbuf[inpos++] & 0xFF];
            byte b = DECODE_ARRAY[inbuf[inpos++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 2 & 0xFC | b >>> 4 & 3);
            if (inbuf[inpos] == 46) {
                return outbuf;
            }
            a = b;
            b = DECODE_ARRAY[inbuf[inpos++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 4 & 0xF0 | b >>> 2 & 0xF);
            if (inbuf[inpos] == 46) {
                return outbuf;
            }
            a = b;
            b = DECODE_ARRAY[inbuf[inpos++] & 0xFF];
            outbuf[outpos++] = (byte)(a << 6 & 0xC0 | b & 0x3F);
            size -= 4;
        }
        return outbuf;
    }

    public String doEnCode(String sUnCoded) {
        return String.valueOf(this.startCode) + CipherUtil.encode(this.strToByteArr(sUnCoded));
    }

    public String doDeCode(String sEnCoded) {
        if (sEnCoded == null) {
            return null;
        }
        return this.byteArrToStr(CipherUtil.decode(this.strToByteArr(sEnCoded.substring(2))));
    }

    public boolean isEnCoded(String filed) {
        return filed.startsWith(this.startCode);
    }

    public byte[] strToByteArr(String str) {
        return str.getBytes();
    }

    public String byteArrToStr(byte[] byteArr) {
        return new String(byteArr);
    }
}

