/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.session.impl;

import com.trs.dev4.jdk16.servlet24.MappedContextTL;
import com.trs.dev4.jdk16.servlet24.RequestUtil;
import com.trs.dev4.jdk16.session.ISessionHandler;
import com.trs.dev4.jdk16.session.ISessionUser;
import javax.servlet.http.HttpServletRequest;

public class ContextHelper {
    private static MappedContextTL sysContextTL = new MappedContextTL();
    private static MappedContextTL userContextTL = new MappedContextTL();
    private static final String USERNAME_SYSTEM = "system";
    private static final String LOGIN_USER = "loginUser";
    private static final String USER_ANNOYMOUS = "annoymous";
    private static final String LOGIN_USER_IP = "loginUserIp";
    private static ISessionUser systemUser = null;

    public static void sysHold(String key, Object object) {
        sysContextTL.setArg(key, object);
    }

    public static Object getSysHold(String key) {
        return sysContextTL.getArg(key);
    }

    public static Object removeSysHold(String key) {
        return sysContextTL.removeArg(key);
    }

    public static void userHold(String key, Object object) {
        userContextTL.setArg(key, object);
    }

    public static Object getUserHold(String key) {
        return userContextTL.getArg(key);
    }

    public static Object removeUserHold(String key) {
        return userContextTL.removeArg(key);
    }

    public static void clear() {
        sysContextTL.clear();
        userContextTL.clear();
    }

    public static void setLoginUser(ISessionUser user) {
        ContextHelper.sysHold(LOGIN_USER, user);
    }

    public static ISessionUser getLoginUser() {
        return (ISessionUser)ContextHelper.getSysHold(LOGIN_USER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ISessionUser getSystemUser() {
        if (systemUser != null) return systemUser;
        Class<ContextHelper> clazz = ContextHelper.class;
        synchronized (ContextHelper.class) {
            if (systemUser != null) return systemUser;
            systemUser = new ISessionUser(){

                @Override
                public boolean canLoginConsole() {
                    return false;
                }

                @Override
                public int getId() {
                    return 0;
                }

                @Override
                public String getLoginedIP() {
                    return null;
                }

                @Override
                public long getLoginedTime() {
                    return 0L;
                }

                @Override
                public String getNickName() {
                    return ContextHelper.USERNAME_SYSTEM;
                }

                @Override
                public String getUserName() {
                    return ContextHelper.USERNAME_SYSTEM;
                }

                @Override
                public boolean isAnonymous() {
                    return false;
                }
            };
            // ** MonitorExit[var0] (shouldn't be in output)
            return systemUser;
        }
    }

    public static void initContext(ISessionHandler<ISessionUser> sessionHandler, HttpServletRequest request) {
        ISessionUser user = sessionHandler.getUser(request);
        if (user == null) {
            user = ContextHelper.getAnonymousUser(request);
        }
        ContextHelper.setLoginUser(user);
        if (user != null) {
            ContextHelper.sysHold(LOGIN_USER_IP, user.getLoginedIP());
        }
    }

    private static ISessionUser getAnonymousUser(HttpServletRequest request) {
        ISessionUser annoyUser = (ISessionUser)request.getSession().getAttribute(USER_ANNOYMOUS);
        if (annoyUser == null) {
            annoyUser = new AnonymousUser(RequestUtil.getClientIP(request));
            request.getSession().setAttribute(USER_ANNOYMOUS, (Object)annoyUser);
        }
        return annoyUser;
    }

    static class AnonymousUser
    implements ISessionUser {
        private String clientIP;
        private String nickName;

        public AnonymousUser(String clientIP) {
            this(clientIP, clientIP);
        }

        public AnonymousUser(String nickName, String clientIP) {
            this.clientIP = clientIP;
            this.nickName = nickName;
        }

        @Override
        public boolean canLoginConsole() {
            return false;
        }

        @Override
        public int getId() {
            return 0;
        }

        @Override
        public String getLoginedIP() {
            return this.clientIP;
        }

        @Override
        public long getLoginedTime() {
            return System.currentTimeMillis();
        }

        @Override
        public String getNickName() {
            return this.nickName;
        }

        @Override
        public String getUserName() {
            return this.nickName;
        }

        @Override
        public boolean isAnonymous() {
            return true;
        }
    }
}

