/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.servlet24;

import com.trs.dev4.jdk16.servlet24.UserAgent;
import com.trs.dev4.jdk16.utils.ReflectUtil;
import com.trs.dev4.jdk16.utils.StringHelper;
import com.trs.dev4.jdk16.xss.SafeHtmlUtil;
import java.io.File;
import java.io.PrintStream;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class RequestUtil {
    private static final Logger LOG = Logger.getLogger(RequestUtil.class);
    private static final String PARAM_ID_ARRAY = "ids";
    public static final String HEADER_USER_AGENT = "user-agent";
    public static final String HEADER_REFER = "referer";
    public static final String NEWLINE = System.getProperty("line.separator");

    public static int getParameterAsInt(HttpServletRequest request, String param) {
        return RequestUtil.getParameterAsInt(request, param, 0);
    }

    public static double getParameterAsDouble(HttpServletRequest request, String param) {
        return RequestUtil.getParameterAsDouble(request, param, 0.0);
    }

    public static int getParameterAsInt(HttpServletRequest request, String param, int defValue) {
        String result = request.getParameter(param);
        if (result == null) {
            return defValue;
        }
        if ((result = result.trim()).length() == 0) {
            return defValue;
        }
        try {
            return Integer.parseInt(result);
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public static int[] getParameterAsIntArray(HttpServletRequest request, String param) {
        String[] valuesStr = request.getParameterValues(param);
        if (valuesStr == null) {
            return new int[0];
        }
        int[] valuesInt = new int[valuesStr.length];
        int i = 0;
        while (i < valuesStr.length) {
            valuesInt[i] = Integer.parseInt(valuesStr[i]);
            ++i;
        }
        return valuesInt;
    }

    public static double getParameterAsDouble(HttpServletRequest request, String param, double defValue) {
        String result = request.getParameter(param);
        if (result == null) {
            return defValue;
        }
        if ((result = result.trim()).length() == 0) {
            return defValue;
        }
        try {
            return Double.valueOf(result);
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public static boolean getParameterAsBool(HttpServletRequest request, String param) {
        return RequestUtil.getParameterAsBool(request, param, false);
    }

    public static boolean getParameterAsBool(HttpServletRequest request, String param, boolean defaultValue) {
        boolean result = defaultValue;
        String paramValue = request.getParameter(param);
        if (paramValue != null) {
            result = "true".equalsIgnoreCase(paramValue);
        }
        return result;
    }

    public static String getParameter(HttpServletRequest request, String param, String defaultValue) {
        return RequestUtil.getParameterAndTrim(request, param, defaultValue, -1);
    }

    public static String getParameterAvoidNull(HttpServletRequest request, String param) {
        return RequestUtil.getParameter(request, param, "");
    }

    public static String getParameterAndTrim(HttpServletRequest req, String param) {
        return RequestUtil.getParameterAndTrim(req, param, "", -1);
    }

    public static String getParameterAndTrim(HttpServletRequest req, String param, String defaultValue, int maxLength) {
        String result = req.getParameter(param);
        String string = result = result == null ? defaultValue : result.trim();
        if (maxLength != -1 && result.length() >= maxLength) {
            throw new IllegalArgumentException("Param[" + param + "]'s value greater than maxLength(" + maxLength + ")");
        }
        return SafeHtmlUtil.getSafeHtml(result);
    }

    public static String getParameterAsTrimed(HttpServletRequest request, String param, String defValue) {
        String result = request.getParameter(param);
        if (result == null) {
            return defValue;
        }
        if ((result = result.trim()).length() == 0) {
            return defValue;
        }
        return result;
    }

    public static <T extends Enum<T>> T getParameterAsEnum(HttpServletRequest request, String param, Class<T> clazz) {
        String result = request.getParameter(param);
        if (result == null) {
            return null;
        }
        return ReflectUtil.getEnumFromString(clazz, result);
    }

    public static String getAttributeAsTrimStr(HttpServletRequest req, String attrName) {
        return RequestUtil.getAttributeAsTrimStr(req, attrName, "");
    }

    public static String getAttributeAsTrimStr(HttpServletRequest req, String attrName, String defValue) {
        Object obj = req.getAttribute(attrName);
        return obj instanceof String ? ((String)obj).trim() : defValue;
    }

    @Deprecated
    public static String getFullGetStr(HttpServletRequest req) {
        String qryStr = req.getQueryString();
        if (qryStr == null) {
            return req.getRequestURL().toString();
        }
        return req.getRequestURL().append('?').append(qryStr).toString();
    }

    public static String getFullUrlWithGetStr(HttpServletRequest request) {
        String contextUrl = RequestUtil.getContextRootWithSlash(request);
        return String.valueOf(contextUrl) + RequestUtil.getClientRequestURL(request);
    }

    public static String getCurrentPage(HttpServletRequest req) {
        String requestURI = req.getRequestURI();
        return requestURI.substring(requestURI.lastIndexOf(47) + 1);
    }

    public static String getRequestInfo(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder(320);
        sb.append("[Req]");
        sb.append(req.getClass().getName());
        sb.append(": (").append(req.getScheme()).append(')').append(req.getServerName()).append(':').append(req.getServerPort());
        sb.append(", ").append(req.getMethod()).append(' ').append(req.getProtocol());
        sb.append(", uri=").append(req.getRequestURI());
        sb.append(", ctx=").append(req.getContextPath());
        sb.append(", servlet=").append(req.getServletPath());
        sb.append(", qryStr=").append(req.getQueryString());
        sb.append(", refer=").append(req.getHeader(HEADER_REFER));
        sb.append(", useragt=").append(req.getHeader(HEADER_USER_AGENT));
        sb.append(", ip=").append(req.getRemoteAddr());
        sb.append(", encoding=").append(req.getCharacterEncoding());
        return sb.toString();
    }

    public static String getAllHeadersStr(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(256);
        String header = null;
        Enumeration headers = req.getHeaderNames();
        while (headers.hasMoreElements()) {
            header = (String)headers.nextElement();
            sb.append(header);
            sb.append("=");
            sb.append(req.getHeader(header));
            sb.append("\r\n");
        }
        return sb.toString();
    }

    public static Map<String, Object> getAllAttributes(HttpServletRequest request) {
        HashMap<String, Object> attrsMap = new HashMap<String, Object>();
        Enumeration enu = request.getAttributeNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            attrsMap.put(key, request.getAttribute(key));
        }
        return attrsMap;
    }

    public static String getAllParameters(HttpServletRequest request) {
        Enumeration parameterNames = request.getParameterNames();
        StringBuffer buffer = new StringBuffer();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            buffer.append(parameterName).append("=").append(RequestUtil.getParameterAndTrim(request, parameterName)).append(";");
        }
        return buffer.toString();
    }

    public static void dumpAllAttrsToStdout(HttpServletRequest request) {
        RequestUtil.dumpAttrs(request, System.out);
    }

    public static String dumpParameters(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append("parameters in request ").append(request.getRequestURI()).append(":\n");
        int total = 0;
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            sb.append(name).append(" = ").append(request.getParameter(name));
            sb.append("\n");
            ++total;
        }
        sb.append("; total ").append(total).append("parameters.\n");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)sb.toString());
        }
        return sb.toString();
    }

    private static void dumpAttrs(HttpServletRequest request, PrintStream out) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(new Timestamp(System.currentTimeMillis())).append('\t');
        sb.append(request.getRequestURI());
        out.println(sb);
        Map<String, Object> attrs = RequestUtil.getAllAttributes(request);
        out.println(String.valueOf(attrs.size()) + " Attributes: ");
        for (String key : attrs.keySet()) {
            out.println(String.valueOf(key) + "=" + attrs.get(key));
        }
        out.println();
    }

    public static boolean isRobotRequest(HttpServletRequest request) {
        String userAgent = RequestUtil.getUserAgent(request);
        if (userAgent == null) {
            return false;
        }
        if ((userAgent = userAgent.toLowerCase()).contains("spider")) {
            return true;
        }
        if (userAgent.contains("bot")) {
            return true;
        }
        if (userAgent.contains("nutch")) {
            return true;
        }
        if (userAgent.contains("yahoo")) {
            return true;
        }
        if (userAgent.contains("gougou")) {
            return true;
        }
        if (userAgent.contains("scooter")) {
            return true;
        }
        return userAgent.contains("lilina");
    }

    public static String getUserAgent(HttpServletRequest request) {
        return request.getHeader(HEADER_USER_AGENT);
    }

    public static String getClientAndHeaders(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer(256);
        sb.append("request clientIP=").append(request.getRemoteAddr());
        sb.append(", encoding=").append(request.getCharacterEncoding());
        sb.append(". request headers:").append(NEWLINE);
        String header = null;
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            header = (String)headers.nextElement();
            sb.append(header);
            sb.append('=');
            sb.append(request.getHeader(header));
            sb.append(NEWLINE);
        }
        return sb.toString();
    }

    public static String getUserAgentAndCookies(HttpServletRequest req) {
        StringBuffer sb = new StringBuffer(256);
        sb.append(HEADER_USER_AGENT).append('=').append(req.getHeader(HEADER_USER_AGENT)).append(';');
        sb.append("cookies: ");
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                sb.append(cookies[i].getName()).append('=').append(cookies[i].getValue());
                sb.append(';');
                ++i;
            }
        }
        return sb.toString();
    }

    public static String getReferUrl(HttpServletRequest req) {
        String referUrl = req.getHeader(HEADER_REFER);
        return referUrl == null ? "" : referUrl;
    }

    public static int getPageUriPosInRequest(HttpServletRequest req, String someUri) {
        if (someUri == null || someUri.trim().length() == 0) {
            return -2;
        }
        return RequestUtil.getRelativePath(req).indexOf(someUri);
    }

    public static String getRelativePath(HttpServletRequest req) {
        return req.getRequestURI().substring(req.getContextPath().length());
    }

    public static String getServletContainerInfo(ServletContext application) {
        StringBuffer sb = new StringBuffer(64);
        sb.append(application.getServerInfo());
        sb.append(" (Servlet ").append(application.getMajorVersion()).append('.').append(application.getMinorVersion()).append(')');
        return sb.toString();
    }

    public static String getClientRequestURL(HttpServletRequest request) {
        Object obj = request.getAttribute("javax.servlet.forward.request_uri");
        String uri = obj instanceof String ? (String)obj : request.getRequestURI();
        String qryStr = request.getQueryString();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("uri:" + uri + ",queryString:" + request.getQueryString() + ",qryStr:" + qryStr));
        }
        if (qryStr == null || qryStr.isEmpty()) {
            return uri;
        }
        return String.valueOf(uri) + "?" + qryStr;
    }

    public static boolean isForward(HttpServletRequest request) {
        return request.getAttribute("javax.servlet.forward.request_uri") instanceof String;
    }

    public static String[] getCheckBoxValues(HttpServletRequest request, String param) {
        String[] values = request.getParameterValues(param);
        if (values == null) {
            values = new String[]{};
        }
        return values;
    }

    @Deprecated
    public static int[] getCheckBoxValuesAsInt(HttpServletRequest request, String param) {
        return RequestUtil.getParameterAsIntArray(request, param);
    }

    @Deprecated
    public static int[] getParameterValuesAsInt(HttpServletRequest request, String param) {
        return RequestUtil.getParameterAsIntArray(request, param);
    }

    public static final String getContextPathWithSlash(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        return StringHelper.smartAppendSlashToEnd(contextPath);
    }

    public static final String getContextPath(HttpServletRequest request) {
        return request.getContextPath();
    }

    @Deprecated
    public static final String getContextRootWithSlash(HttpServletRequest request) {
        return RequestUtil.getContextUrlWithSlash(request);
    }

    public static final String getContextUrlWithSlash(HttpServletRequest request) {
        String contextRoot = RequestUtil.getContextUrl(request);
        return StringHelper.smartAppendSlashToEnd(contextRoot);
    }

    @Deprecated
    public static String getContextRoot(HttpServletRequest request) {
        return RequestUtil.getContextUrl(request);
    }

    public static String getContextUrl(HttpServletRequest request) {
        String xForwardedHost = request.getHeader("X-Forwarded-Host");
        String scheme = request.getScheme();
        String host = StringHelper.isEmpty(xForwardedHost) ? request.getHeader("Host") : xForwardedHost;
        return String.valueOf(scheme) + "://" + host + RequestUtil.getContextPathWithSlash(request);
    }

    public static final String getClientIP(HttpServletRequest request) {
        String xForwardedFor = request.getHeader("X-Forwarded-For");
        String remoteAddr = request.getRemoteAddr();
        if (xForwardedFor != null && xForwardedFor.length() > 4) {
            int index = xForwardedFor.indexOf(",");
            remoteAddr = index != -1 ? xForwardedFor.substring(0, index) : xForwardedFor;
        }
        return remoteAddr;
    }

    public static final boolean isMultipartRequest(HttpServletRequest request) {
        String type = null;
        String type1 = request.getHeader("Content-Type");
        String type2 = request.getContentType();
        if (type1 == null && type2 != null) {
            type = type2;
        } else if (type2 == null && type1 != null) {
            type = type1;
        } else if (type1 != null && type2 != null) {
            String string = type = type1.length() > type2.length() ? type1 : type2;
        }
        return type != null && type.toLowerCase().startsWith("multipart/form-data");
    }

    public static final int getId(HttpServletRequest request) {
        return RequestUtil.getParameterAsInt(request, "id", 0);
    }

    public static final int getPageSize(HttpServletRequest request) {
        return RequestUtil.getParameterAsInt(request, "ps", 20);
    }

    public static final int getPageNo(HttpServletRequest request) {
        return RequestUtil.getParameterAsInt(request, "pn", 1);
    }

    public static final int[] getIds(HttpServletRequest request) {
        String ids = RequestUtil.getParameterAndTrim(request, PARAM_ID_ARRAY);
        return StringHelper.split2IntArray(ids);
    }

    public static final void dump(HttpServletRequest request) {
        if (LOG.isDebugEnabled()) {
            RequestUtil.dumpHeaders(request);
            RequestUtil.dumpParameters(request);
            RequestUtil.dumpCookies(request);
        }
    }

    private static void dumpCookies(HttpServletRequest request) {
        StringBuffer cookieBuffer = new StringBuffer("Request(" + request.getRequestURI() + ") 's cookies:");
        Cookie[] cookies = request.getCookies();
        int i = 0;
        while (i < cookies.length) {
            cookieBuffer.append(cookies[i].getName()).append("=").append(cookies[i].getValue());
            cookieBuffer.append(",path=").append(cookies[i].getPath()).append(",domain=").append(cookies[i].getDomain()).append(";");
            ++i;
        }
        cookieBuffer.append("total ").append(cookies.length).append(" cookies.");
        LOG.info((Object)cookieBuffer.toString());
    }

    private static void dumpHeaders(HttpServletRequest request) {
        StringBuffer headerBuffer = new StringBuffer("Request(" + request.getRequestURI() + ") 's headers:");
        Enumeration e = request.getHeaderNames();
        int countHeader = 0;
        while (e.hasMoreElements()) {
            String headerName = (String)e.nextElement();
            headerBuffer.append(headerName).append("=").append(request.getHeader(headerName)).append(";");
            ++countHeader;
        }
        headerBuffer.append("total ").append(countHeader).append(" headers.");
        LOG.info((Object)headerBuffer.toString());
    }

    @Deprecated
    public static String getRemoteAddr(HttpServletRequest request) {
        return request.getRemoteAddr();
    }

    public static String getQueryString(HttpServletRequest request) {
        return request.getQueryString();
    }

    public static boolean isAjaxRequest(HttpServletRequest request) {
        return "XMLHttpRequest".equals(request.getHeader("x-requested-with"));
    }

    public static File getRealFile(ServletContext application, HttpServletRequest request) {
        String relativeURI = request.getServletPath();
        return RequestUtil.getRealFile(application, relativeURI);
    }

    public static File getRealFile(ServletContext application, String relativeURI) {
        String realPath = application.getRealPath(relativeURI);
        return realPath == null ? null : new File(realPath);
    }

    public static boolean fromIOS(HttpServletRequest request) {
        String userAgent = request.getHeader(HEADER_USER_AGENT);
        return new UserAgent(userAgent).getOperationSystem() == UserAgent.OS.iOS;
    }
}

