/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.servlet24;

import com.oreilly.servlet.MultipartRequest;
import com.oreilly.servlet.multipart.FileRenamePolicy;
import com.trs.dev4.jdk16.servlet24.MultipartFile;
import com.trs.dev4.jdk16.utils.FileUtil;
import com.trs.dev4.jdk16.utils.NumberUtil;
import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;

public class MultipartHelper {
    private MultipartRequest mpReq;

    public MultipartHelper(HttpServletRequest request, String saveDirectory, int maxPostSize) throws IOException {
        this(request, saveDirectory, maxPostSize, "UTF-8", null);
    }

    public MultipartHelper(HttpServletRequest request, String saveDirectory, int maxPostSize, FileRenamePolicy policy) throws IOException {
        this(request, saveDirectory, maxPostSize, "UTF-8", policy);
    }

    public MultipartHelper(HttpServletRequest request, String saveDirectory, int maxPostSize, String encoding, FileRenamePolicy policy) throws IOException {
        this.mpReq = new MultipartRequest(request, saveDirectory, maxPostSize, encoding, policy);
    }

    public MultipartFile getMultipartFile(String name) {
        File file = this.mpReq.getFile(name);
        if (file == null) {
            return null;
        }
        FileUtil.assertFileExists(file);
        String originalFileName = this.mpReq.getOriginalFileName(name);
        return new MultipartFile(file, originalFileName, name);
    }

    public String getParameter(String paramName) {
        return this.mpReq.getParameter(paramName);
    }

    public int getParameterAsInt(String paramName) {
        return NumberUtil.parseInt(this.mpReq.getParameter(paramName));
    }
}

