/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.servlet24;

import com.trs.dev4.jdk16.utils.StringHelper;
import com.trs.dev4.jdk16.utils.UrlUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieHelper {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Map<String, Cookie> cookiesMap;
    private String cookiesHeader;
    private String domain;

    public CookieHelper(HttpServletRequest request, HttpServletResponse response) {
        this.initCookieHelper(request, response);
    }

    public CookieHelper(HttpServletRequest request, HttpServletResponse response, int domainLevel) {
        this.initCookieHelper(request, response);
        this.domain = UrlUtil.getDomainByLevel(request.getServerName(), domainLevel);
    }

    public CookieHelper(HttpServletRequest request, HttpServletResponse response, String domain) {
        this.initCookieHelper(request, response);
        this.domain = domain;
    }

    private void initCookieHelper(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.cookiesHeader = request.getHeader("Cookie");
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            this.cookiesMap = Collections.emptyMap();
        } else {
            this.cookiesMap = new HashMap<String, Cookie>(cookies.length);
            int i = 0;
            while (i < cookies.length) {
                this.cookiesMap.put(cookies[i].getName(), cookies[i]);
                ++i;
            }
        }
    }

    public Cookie getCookie(String name) {
        return this.cookiesMap.get(name);
    }

    public String getValue(String name) {
        Cookie cookie = this.getCookie(name);
        if (cookie == null) {
            return null;
        }
        return cookie.getValue();
    }

    public void removeCookie(String name) {
        Cookie cookie = new Cookie(name, null);
        cookie.setMaxAge(0);
        cookie.setPath(this.getContextPath(this.request));
        this.response.addCookie(cookie);
    }

    public void removeCookie(String name, String domain) {
        Cookie cookie = new Cookie(name, null);
        cookie.setMaxAge(0);
        cookie.setPath(this.getContextPath(this.request));
        if (!StringHelper.isEmpty(domain)) {
            cookie.setDomain(domain);
        }
        this.response.addCookie(cookie);
    }

    public void removeCookie(String name, String path, String domain) {
        Cookie cookie = new Cookie(name, null);
        cookie.setMaxAge(0);
        cookie.setPath(path);
        if (!StringHelper.isEmpty(domain)) {
            cookie.setDomain(domain);
        }
        this.response.addCookie(cookie);
    }

    public void addCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(this.getContextPath(this.request));
        if (!StringHelper.isEmpty(this.domain)) {
            cookie.setDomain(this.domain);
        }
        this.response.addCookie(cookie);
    }

    public void addCookie(String name, String value, int cookieAge) {
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(this.getContextPath(this.request));
        cookie.setMaxAge(cookieAge);
        if (!StringHelper.isEmpty(this.domain)) {
            cookie.setDomain(this.domain);
        }
        this.response.addCookie(cookie);
    }

    public String getCookieStrings() {
        StringBuffer sb = new StringBuffer(64 * this.cookiesMap.size());
        for (String name : this.cookiesMap.keySet()) {
            sb.append(name).append('=').append(this.cookiesMap.get(name)).append("; ");
        }
        return sb.toString();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public String getCookiesHeader() {
        return this.cookiesHeader;
    }

    private String getContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.length() == 0) {
            contextPath = "/";
        }
        return contextPath;
    }
}

