/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.model;

import com.trs.dev4.jdk16.dao.HQLBuilder;
import com.trs.dev4.jdk16.dao.IAccessor;
import com.trs.dev4.jdk16.dao.PagedList;
import com.trs.dev4.jdk16.dao.SearchFilter;
import com.trs.dev4.jdk16.exception.DAOException;
import com.trs.dev4.jdk16.exception.ValidateAssertionException;
import com.trs.dev4.jdk16.model.BaseEntity;
import com.trs.dev4.jdk16.model.Configuration;
import com.trs.dev4.jdk16.model.IBaseManager;
import com.trs.dev4.jdk16.model.IConfigurable;
import com.trs.dev4.jdk16.model.IEntity;
import com.trs.dev4.jdk16.model.ObjectCounter;
import com.trs.dev4.jdk16.model.ValidationErrors;
import com.trs.dev4.jdk16.utils.ArrayUtil;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class BaseManager<T extends IEntity>
implements IBaseManager<T>,
IConfigurable {
    private static final Logger LOG = Logger.getLogger(BaseManager.class);
    private IAccessor<T> accessor;
    protected ObjectCounter objectCounter = new ObjectCounter(this.getClass().getSimpleName());

    protected BaseManager() {
    }

    @Override
    public int addNew(T masObj) {
        Serializable oSerializable;
        this.assertValid(masObj);
        this.onValidationPass(masObj, Mode.INSERT);
        if (masObj instanceof BaseEntity) {
            BaseEntity bo = (BaseEntity)masObj;
            bo.setCreatedTime(System.currentTimeMillis());
            bo.setLastModifiedTime(System.currentTimeMillis());
        }
        if ((oSerializable = this.accessor.insert(masObj)) instanceof Number) {
            return ((Number)oSerializable).intValue();
        }
        this.objectCounter.countSave();
        return 0;
    }

    private void assertValid(T masObj) {
        ValidationErrors validationErrors = this.validate(masObj);
        if (validationErrors.hasErrors()) {
            throw new ValidateAssertionException("\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u4e0d\u80fd\u4fdd\u5b58\u5bf9\u8c61[" + masObj + "]: " + validationErrors);
        }
    }

    protected void onValidationPass(T masObj, Mode mode) {
    }

    @Override
    public void update(T masObj) {
        this.assertValid(masObj);
        this.onValidationPass(masObj, Mode.UPDATE);
        if (masObj instanceof BaseEntity) {
            BaseEntity bo = (BaseEntity)masObj;
            bo.setLastModifiedTime(System.currentTimeMillis());
        }
        this.accessor.update(masObj);
        this.objectCounter.countSave();
    }

    @Override
    public ValidationErrors validate(T masObj) {
        return new ValidationErrors();
    }

    @Override
    public void delete(T object) {
        this.accessor.delete(object);
        this.objectCounter.countDelete();
    }

    @Override
    public int delete(SearchFilter sf) {
        int count = this.accessor.delete(sf);
        this.objectCounter.countDelete(count);
        return count;
    }

    @Override
    public int batchUpdate(HQLBuilder builder) {
        int count = this.accessor.batchUpdate(builder);
        this.objectCounter.countSave(count);
        return count;
    }

    @Override
    public int bulkUpdate(String field, Object oldValue, Object newValue) {
        HQLBuilder hqlBuilder = HQLBuilder.UPDATE(this.accessor.getClassType());
        hqlBuilder.setNewValue(field, newValue).addEqCondition(field, oldValue);
        return this.batchUpdate(hqlBuilder);
    }

    @Override
    public T find(int objectId) {
        IEntity object = this.doAfterObjectGot((IEntity)this.accessor.getObject(objectId));
        this.objectCounter.countGet();
        return (T)object;
    }

    @Override
    public T get(int objectId) {
        IEntity object = this.doAfterObjectGot((IEntity)this.accessor.getObject(objectId));
        this.objectCounter.countGet();
        return (T)object;
    }

    @Override
    public List<T> listAllObjects() {
        List<T> objects = this.doAfterObjectGot((T)this.accessor.listObjects());
        this.objectCounter.countSearch(objects.size(), 0);
        return objects;
    }

    @Override
    public List<T> listAllObjects(SearchFilter sf) {
        List<T> objects = this.doAfterObjectGot((T)this.accessor.listObjects(sf));
        this.objectCounter.countSearch(objects.size(), 0);
        return objects;
    }

    @Override
    public PagedList<T> pagedObjects(SearchFilter sf) {
        PagedList<T> pagedObjects = this.doAfterObjectGot((T)this.accessor.pagedObjects(sf));
        this.objectCounter.countSearch(pagedObjects.size(), 0);
        return pagedObjects;
    }

    @Override
    public PagedList<T> pagedAll() {
        PagedList<T> pagedObjects = this.doAfterObjectGot((T)this.accessor.pagedAll());
        this.objectCounter.countSearch(pagedObjects.size(), 0);
        return pagedObjects;
    }

    protected IAccessor<T> getAccessor() {
        return this.accessor;
    }

    public void setAccessor(IAccessor<T> accessor) {
        this.accessor = accessor;
    }

    @Override
    public T findUnique(String field, Object value) {
        SearchFilter sf = SearchFilter.getDefault();
        sf.addEqCondition(field, value);
        List<T> objects = this.accessor.listObjects(sf);
        if (objects.size() > 1) {
            throw new DAOException("not unique " + this.accessor.getClassType().getName() + ": " + field + "=" + "[" + value + "]");
        }
        T object = this.doAfterObjectGot(objects.size() == 0 ? null : (IEntity)objects.get(0));
        this.objectCounter.countGet();
        return object;
    }

    @Override
    public T findFirst(String field, Object value) {
        IEntity object = this.doAfterObjectGot((IEntity)this.accessor.findFirst(field, value));
        this.objectCounter.countGet();
        return (T)object;
    }

    @Override
    @Deprecated
    public boolean exists(Object value, int excludedId) {
        return this.accessor.exists(this.getUniqueFieldName(), value, excludedId);
    }

    @Deprecated
    protected String getUniqueFieldName() {
        return "name";
    }

    @Override
    public int batchAddNew(T[] objects) {
        int count = this.accessor.batchInsert(objects);
        this.objectCounter.countSave(count);
        return count;
    }

    @Override
    public void batchSaveOrUpdate(T[] objects) {
        this.accessor.batchUpdate(objects);
        this.objectCounter.countSave(objects.length);
    }

    @Override
    public void batchDelete(T[] objects) {
        this.accessor.batchDelete(objects);
        this.objectCounter.countDelete(objects.length);
    }

    @Override
    public List<T> listObjects(int[] idArray) {
        if (idArray == null || idArray.length == 0) {
            return Collections.emptyList();
        }
        SearchFilter searchFilter = SearchFilter.getNoPagedFilter();
        searchFilter.addInCondition("id", idArray);
        List<T> objects = this.doAfterObjectGot((T)this.accessor.listObjects(searchFilter));
        this.objectCounter.countSearch(objects.size(), 0);
        return objects;
    }

    @Override
    public void batchDelete(HQLBuilder builder) {
        int count = this.accessor.batchDelete(builder);
        this.objectCounter.countDelete(count);
    }

    @Override
    public int total() {
        return this.accessor.total();
    }

    @Override
    public int total(SearchFilter sf) {
        return this.accessor.total(sf);
    }

    @Override
    public List<T> listLatest(int amount) {
        SearchFilter sf = SearchFilter.getDefault();
        sf.setMaxResults(amount);
        sf.setOrderBy("id desc");
        return this.doAfterObjectGot((T)this.accessor.listObjects(sf));
    }

    @Override
    @Deprecated
    public T findByUniqueField(String name) {
        SearchFilter sf = SearchFilter.getDefault();
        sf.addEqCondition(this.getUniqueFieldName(), name);
        List<T> list = this.accessor.listObjects(sf);
        if (list.size() != 1) {
            return null;
        }
        return (T)this.doAfterObjectGot((IEntity)list.get(0));
    }

    @Override
    public void start() {
    }

    @Override
    public void restart() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void refreshConfigs() {
    }

    @Override
    public String getPrefix() {
        return this.getClass().getSimpleName();
    }

    @Override
    public ValidationErrors validateConfigs(Map<String, Configuration> configs) {
        return new ValidationErrors();
    }

    @Override
    public void batchDelete(int[] objectIds) {
        Object[] objIds = ArrayUtil.toIntegerArray(objectIds);
        HQLBuilder hqlBuilder = HQLBuilder.DELETE(this.accessor.getClassType());
        hqlBuilder.addInCondition("id", objIds);
        int count = this.accessor.batchDelete(hqlBuilder);
        this.objectCounter.countDelete(count);
    }

    @Override
    public T getOrNew(int entityId) {
        if (entityId <= 0) {
            try {
                return (T)((IEntity)this.accessor.getClassType().newInstance());
            }
            catch (InstantiationException e) {
                LOG.error((Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                LOG.error((Object)e.getMessage());
            }
        }
        IEntity object = this.doAfterObjectGot((IEntity)this.accessor.getObject(entityId));
        this.objectCounter.countGet();
        return (T)object;
    }

    @Override
    public void saveOrUpdate(T entity) {
        ValidationErrors errors = this.validate(entity);
        if (errors.hasErrors()) {
            ValidateAssertionException ex = new ValidateAssertionException("Object(" + entity + ") validation failed : " + errors.toString());
            ex.setValiationErrors(errors);
            throw ex;
        }
        if (entity.getId() == 0) {
            if (entity instanceof BaseEntity) {
                BaseEntity bo = (BaseEntity)entity;
                bo.setCreatedTime(System.currentTimeMillis());
                bo.setLastModifiedTime(System.currentTimeMillis());
            }
            this.accessor.insert(entity);
        } else {
            this.accessor.update(entity);
        }
        this.objectCounter.countSave();
    }

    @Override
    public T findFirst(SearchFilter sf) {
        PagedList<T> entities;
        if (sf == null) {
            sf = SearchFilter.getDefault();
        }
        T object = this.doAfterObjectGot((entities = this.pagedObjects(sf)).getPageItems().size() > 0 ? (IEntity)entities.get(0) : null);
        this.objectCounter.countGet();
        return object;
    }

    @Override
    public T findUnique(SearchFilter sf) {
        PagedList<T> entities;
        if (sf == null) {
            sf = SearchFilter.getDefault();
        }
        if ((entities = this.pagedObjects(sf)).getPageItems().size() > 1) {
            throw new DAOException("not unique " + this.accessor.getClassType().getName() + ",sf: " + sf);
        }
        T object = this.doAfterObjectGot(entities.getPageItems().size() > 0 ? (IEntity)entities.get(0) : null);
        this.objectCounter.countGet();
        return object;
    }

    protected final List<T> doAfterObjectGot(List<T> entities) {
        if (entities == null) {
            return entities;
        }
        for (IEntity entity : entities) {
            this.doAfterObjectGot(entity);
        }
        return entities;
    }

    protected final PagedList<T> doAfterObjectGot(PagedList<T> entities) {
        if (entities == null) {
            return entities;
        }
        for (IEntity entity : entities.getPageItems()) {
            this.doAfterObjectGot(entity);
        }
        return entities;
    }

    protected final T doAfterObjectGot(T entity) {
        if (entity != null) {
            this.afterObjectGot(entity);
        }
        return entity;
    }

    @Override
    public void truncate() {
        this.accessor.truncate();
    }

    @Override
    public boolean exists(String fieldName, Object value, int excludedId) {
        return this.accessor.exists(fieldName, value, excludedId);
    }

    @Override
    public String getModuleName() {
        return this.getClass().getSimpleName();
    }

    protected void afterObjectGot(T object) {
    }

    public PagedList<Integer> pagedObjectIds(SearchFilter searchFilter) {
        return this.accessor.pagedObjectIds(searchFilter);
    }

    @Override
    public ObjectCounter getObjectCounter() {
        return this.objectCounter;
    }

    public static enum Mode {
        INSERT("insert"),
        UPDATE("update");

        String modeName;

        private Mode(String name) {
            this.modeName = name;
        }
    }
}

