/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.mina.impl;

import com.trs.dev4.jdk16.mina.IMessage;
import com.trs.dev4.jdk16.mina.IMessageHandler;
import java.util.Map;
import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageClientSessionHandler
extends IoHandlerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(MessageClientSessionHandler.class);
    private Map<String, IMessageHandler> messageHandlers;

    public void messageReceived(IoSession session, Object message) {
        IMessage rm = (IMessage)message;
        Map<String, IMessageHandler> messageHandlers = this.messageHandlers;
        IMessageHandler messageHandler = messageHandlers.get(rm.getClass().getName());
        messageHandler.messageReceived(rm);
    }

    public void exceptionCaught(IoSession session, Throwable cause) {
        logger.error("ClientSessionHandler exception:" + cause.getMessage(), cause);
        session.close(true);
    }

    public Map<String, IMessageHandler> getMessageHandlers() {
        return this.messageHandlers;
    }

    public void setMessageHandlers(Map<String, IMessageHandler> messageHandlers) {
        this.messageHandlers = messageHandlers;
    }
}

