/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.job.impl;

import com.trs.dev4.jdk16.job.EJobDetailStatus;
import com.trs.dev4.jdk16.job.IJobExecutor;
import com.trs.dev4.jdk16.job.JobDetail;
import com.trs.dev4.jdk16.job.impl.QuartzJobService;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class QuartzJob
implements Job {
    private Logger logger = Logger.getLogger(QuartzJob.class);

    public void execute(JobExecutionContext jobContext) throws JobExecutionException {
        JobDataMap jobDataMap = new JobDataMap();
        try {
            jobDataMap = jobContext.getJobDetail().getJobDataMap();
        }
        catch (Exception e) {
            this.logger.error((Object)("error while getting jobDataMap from jobContext. jobContext : " + jobContext), (Throwable)e);
        }
        IJobExecutor jobExecutor = (IJobExecutor)jobDataMap.get((Object)QuartzJobService.JOB_EXECUTOR);
        JobDetail jobDetail = (JobDetail)jobDataMap.get((Object)QuartzJobService.JOB_KEY);
        if (jobExecutor == null) {
            this.logger.error((Object)"jobExecutor is null, return directly.");
            return;
        }
        if (jobDetail == null) {
            this.logger.error((Object)"jobDetail is null, return directly. ");
            return;
        }
        if (jobDetail.getStatus() == EJobDetailStatus.PAUSE.ordinal()) {
            this.logger.debug((Object)(String.valueOf(jobExecutor.getName()) + "(" + jobExecutor.toString() + ")" + jobDetail.getJobName() + "(" + jobDetail.toString() + ")" + ") is paused. So return directly!"));
            return;
        }
        if (jobDetail.getStatus() == EJobDetailStatus.RUN.ordinal()) {
            this.logger.debug((Object)(String.valueOf(jobExecutor.getName()) + "(" + jobExecutor.toString() + ")" + jobDetail.getJobName() + "(" + jobDetail.toString() + ")" + ") is executing..."));
            jobExecutor.execute(jobDetail);
            this.logger.debug((Object)(String.valueOf(jobExecutor.getName()) + "(" + jobExecutor.toString() + ")" + jobDetail.getJobName() + "(" + jobDetail.toString() + ")" + ") already executed."));
            return;
        }
    }
}

