/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.file;

import com.trs.dev4.jdk16.exception.WrappedException;
import com.trs.dev4.jdk16.utils.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileCompressUtil {
    public static File zip(File folder) {
        List<File> lstFiles = FileUtil.listFilesInDir(folder, true);
        byte[] buf = new byte[1024];
        try {
            File zipFile = new File(folder.getParent(), String.valueOf(folder.getName()) + ".zip");
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zipFile));
            int i = 0;
            while (i < lstFiles.size()) {
                int len;
                File file = lstFiles.get(i);
                FileInputStream in = new FileInputStream(file);
                out.putNextEntry(new ZipEntry(file.getName()));
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                out.closeEntry();
                in.close();
                ++i;
            }
            out.close();
            return zipFile;
        }
        catch (IOException e) {
            throw new WrappedException(e);
        }
    }
}

