/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.exec;

import com.trs.dev4.jdk16.utils.StringHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ArgumentsBuilder {
    private String template;
    private Map<String, String> tokenVars = new HashMap<String, String>();

    public ArgumentsBuilder(String template) {
        this.template = template;
    }

    public ArgumentsBuilder replaceAll(String token, String value) {
        this.tokenVars.put(token, value);
        return this;
    }

    public ArgumentsBuilder replaceAll(String token, long value) {
        this.tokenVars.put(token, String.valueOf(value));
        return this;
    }

    public ArgumentsBuilder replaceAll(String token, int value) {
        this.tokenVars.put(token, String.valueOf(value));
        return this;
    }

    public ArgumentsBuilder replaceAll(String token, double value) {
        this.tokenVars.put(token, String.valueOf(value));
        return this;
    }

    public ArgumentsBuilder replaceAll(String token, float value) {
        this.tokenVars.put(token, String.valueOf(value));
        return this;
    }

    public ArgumentsBuilder replaceAll(String token, boolean value) {
        this.tokenVars.put(token, String.valueOf(value));
        return this;
    }

    public String toArgument() {
        Set<String> tokens = this.tokenVars.keySet();
        String result = this.template;
        for (String token : tokens) {
            String replacement = StringHelper.addQuote(this.tokenVars.get(token));
            result = StringHelper.replaceAll(result, token, replacement);
        }
        return result.charAt(0) == ' ' ? result : " " + result;
    }

    public String toArgumentWithoutAddQuote() {
        Set<String> tokens = this.tokenVars.keySet();
        String result = this.template;
        for (String token : tokens) {
            String replacement = this.tokenVars.get(token);
            result = StringHelper.replaceAll(result, token, replacement);
        }
        return result.charAt(0) == ' ' ? result : " " + result;
    }
}

