/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.dao.hb3;

import com.trs.dev4.jdk16.dao.DBSummary;
import com.trs.dev4.jdk16.dao.PagedList;
import com.trs.dev4.jdk16.dao.SearchFilter;
import com.trs.dev4.jdk16.dao.hb3.GenericBaseDAO;
import com.trs.dev4.jdk16.exception.DAOException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.hibernate.SessionFactory;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class AnnotationGenericBaseDAO<T>
extends GenericBaseDAO<T> {
    private GenericBaseDAO<T> slaveGenericBaseDAO = null;
    @Resource(name="slaveSessionFactory")
    private SessionFactory slaveSessionFactory;

    @Autowired
    public void setFactory(@Qualifier(value="mainSessionFactory") SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    public void setSlaveSessionFactory(SessionFactory slaveSessionFactory) {
        this.slaveSessionFactory = slaveSessionFactory;
        this.buildSlaveSessionFactory(this.getClassType());
    }

    public AnnotationGenericBaseDAO(Class<T> classType) {
        super(classType);
        this.buildSlaveSessionFactory(classType);
    }

    private void buildSlaveSessionFactory(Class<T> classType) {
        if (this.slaveSessionFactory != null) {
            this.slaveGenericBaseDAO = new GenericBaseDAO<T>(classType);
            this.slaveGenericBaseDAO.setSessionFactory(this.slaveSessionFactory);
        }
    }

    @Override
    public T getObject(int objectId) throws DAOException {
        if (this.slaveAvailable()) {
            return this.slaveGenericBaseDAO.getObject(objectId);
        }
        return super.getObject(objectId);
    }

    boolean slaveAvailable() {
        return this.slaveGenericBaseDAO != null;
    }

    @Override
    public List<T> listObjects() throws DAOException {
        if (this.slaveAvailable()) {
            return this.slaveGenericBaseDAO.listObjects();
        }
        return super.listObjects();
    }

    @Override
    public List<T> listObjects(SearchFilter sf) throws DAOException {
        if (this.slaveAvailable()) {
            return this.slaveGenericBaseDAO.listObjects(sf);
        }
        return super.listObjects(sf);
    }

    @Override
    public List<T> listObjects(String fieldName, Object value) throws DAOException {
        if (this.slaveAvailable()) {
            this.slaveGenericBaseDAO.listObjects(fieldName, value);
        }
        return super.listObjects(fieldName, value);
    }

    @Override
    public PagedList<T> pagedAll() throws DAOException {
        if (this.slaveAvailable()) {
            this.slaveGenericBaseDAO.pagedAll();
        }
        return super.pagedAll();
    }

    @Override
    public PagedList<T> pagedObjects(SearchFilter sf) throws DAOException {
        if (this.slaveAvailable()) {
            this.slaveGenericBaseDAO.pagedObjects(sf);
        }
        return super.pagedObjects(sf);
    }

    @Override
    public T findFirst(String field, Object value) throws DAOException {
        if (this.slaveAvailable()) {
            this.slaveGenericBaseDAO.findFirst(field, value);
        }
        return super.findFirst(field, value);
    }

    @Override
    public int total() throws DAOException {
        if (this.slaveAvailable()) {
            this.slaveGenericBaseDAO.total();
        }
        return super.total();
    }

    @Override
    public int total(SearchFilter sf) {
        if (this.slaveAvailable()) {
            this.slaveGenericBaseDAO.total(sf);
        }
        return super.total(sf);
    }

    @Override
    public DBSummary retriveDBSummary() {
        if (this.slaveAvailable()) {
            this.slaveGenericBaseDAO.retriveDBSummary();
        }
        return super.retriveDBSummary();
    }

    @Override
    public Map<String, ClassMetadata> getAllEntityClassMetadata() {
        if (this.slaveAvailable()) {
            this.slaveGenericBaseDAO.getAllEntityClassMetadata();
        }
        return super.getAllEntityClassMetadata();
    }

    @Override
    ClassMetadata getHibernateClassMetadata() {
        if (this.slaveAvailable()) {
            this.slaveGenericBaseDAO.getHibernateClassMetadata();
        }
        return super.getHibernateClassMetadata();
    }

    @Override
    EntityMetamodel getHibernateEntityMetamodel() {
        return super.getHibernateEntityMetamodel();
    }
}

