/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.dao;

import com.trs.dev4.jdk16.dao.DBSummary;
import com.trs.dev4.jdk16.dao.RDBProduct;
import com.trs.dev4.jdk16.exception.DAOException;
import com.trs.dev4.jdk16.exception.DBConnectException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class DBSummaryUtil
extends DBSummary {
    public static DBSummary retriveSummary(String driver, String url, String user, String pwd) {
        Connection conn;
        try {
            conn = DBSummaryUtil.tryConnect(driver, url, user, pwd);
        }
        catch (Exception e) {
            throw new DBConnectException(e);
        }
        try {
            DBSummary dBSummary = DBSummaryUtil.retriveSummary(conn, driver, url, user, pwd);
            return dBSummary;
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private static DBSummary retriveSummary(Connection conn, String driver, String url, String user, String pwd) {
        DBSummary info = new DBSummary();
        info.setJdbcDriverClassName(driver);
        info.setJdbcUrl(url);
        info.setJdbcUser(user);
        info.setJdbcPassword(pwd);
        try {
            DatabaseMetaData dbMeta = conn.getMetaData();
            info.setDbProductName(dbMeta.getDatabaseProductName());
            info.setDbProductVersion(dbMeta.getDatabaseProductVersion());
            info.setDbProductName(dbMeta.getDatabaseProductName());
            info.setJdbcDriverName(dbMeta.getDriverName());
            info.setJdbcDriverVersion(String.valueOf(dbMeta.getDriverMajorVersion()) + "." + dbMeta.getDriverMinorVersion());
            try {
                info.setJdbcDriverVersionDetail(dbMeta.getDriverVersion());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                info.setJdbcVersion(String.valueOf(dbMeta.getJDBCMajorVersion()) + "." + dbMeta.getJDBCMinorVersion());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            info.setUrlFromDBMeta(dbMeta.getURL());
            info.setUserFromDBMeta(dbMeta.getUserName());
            info.setSqlKeywords(DBSummaryUtil.getSQLKeywords(dbMeta));
        }
        catch (Exception e) {
            throw new DAOException(e);
        }
        return info;
    }

    public static DBSummary retriveSummary(Connection conn) {
        return DBSummaryUtil.retriveSummary(conn, null, null, null, null);
    }

    public static DBSummary connectAndGetSummary(RDBProduct dbProduct, String dbHost, int dbPort, String dbName, String dbUser, String dbPasswd) {
        StringBuilder sb = new StringBuilder();
        String dbDriver = null;
        if (dbProduct == RDBProduct.MySQL) {
            sb.append("jdbc:");
            sb.append("mysql://");
            sb.append(dbHost == null ? "localhost" : dbHost);
            sb.append(':');
            sb.append(dbPort == 0 ? 3306 : dbPort);
            sb.append('/').append(dbName);
            dbDriver = "com.mysql.jdbc.Driver";
        } else if (dbProduct == RDBProduct.Oracle) {
            sb.append("jdbc:");
            sb.append("oracle:thin:@");
            sb.append(dbHost == null ? "localhost" : dbHost);
            sb.append(':');
            sb.append(dbPort == 0 ? 1521 : dbPort);
            sb.append(':').append(dbName);
            dbDriver = "oracle.jdbc.driver.OracleDriver";
        } else if (dbProduct == RDBProduct.SQLServer) {
            sb.append("jdbc:");
            sb.append("jtds:sqlserver://");
            sb.append(dbHost == null ? "localhost" : dbHost);
            sb.append(':');
            sb.append(dbPort == 0 ? 1433 : dbPort);
            sb.append('/').append(dbName);
            dbDriver = "net.sourceforge.jtds.jdbc.Driver";
        } else if (dbProduct == RDBProduct.H2) {
            sb.append("jdbc:");
            sb.append("h2:tcp://");
            sb.append(dbHost == null ? "localhost" : dbHost);
            sb.append("/~/h2datas/").append(dbName);
            dbDriver = "org.h2.Driver";
        } else {
            throw new UnsupportedOperationException("dbProduct: " + (Object)((Object)dbProduct));
        }
        String jdbcUrl = sb.toString();
        return DBSummaryUtil.retriveSummary(dbDriver, jdbcUrl, dbUser, dbPasswd);
    }

    public static Properties connectAndToHibernateProperties(RDBProduct dbProduct, String dbHost, int dbPort, String dbName, String dbUser, String dbPasswd) {
        DBSummary dbSummary = DBSummaryUtil.connectAndGetSummary(dbProduct, dbHost, dbPort, dbName, dbUser, dbPasswd);
        Properties props = new Properties();
        props.setProperty("hibernate.connection.url", dbSummary.getJdbcUrl());
        props.setProperty("hibernate.connection.driver_class", dbSummary.getJdbcDriverClassName());
        props.setProperty("hibernate.dialect", DBSummaryUtil.getHibernateDialect(dbProduct));
        props.setProperty("hibernate.connection.username", dbUser);
        props.setProperty("hibernate.connection.password", dbSummary.getJdbcPassword());
        return props;
    }

    static String getHibernateDialect(RDBProduct dbProduct) {
        if (dbProduct == null) {
            return null;
        }
        switch (dbProduct) {
            case MySQL: {
                return "org.hibernate.dialect.MySQL5InnoDBDialect";
            }
            case Oracle: {
                return "org.hibernate.dialect.Oracle10gDialect";
            }
            case SQLServer: {
                return "org.hibernate.dialect.SQLServerDialect";
            }
            case H2: {
                return "com.trs.idm.util.hb.H2Dialect";
            }
        }
        throw new UnsupportedOperationException("dbProduct: " + (Object)((Object)dbProduct));
    }

    public static Connection tryConnect(String driver, String url, String user, String pwd) throws ClassNotFoundException, SQLException {
        if (driver == null || driver.trim().length() == 0) {
            throw new IllegalArgumentException("the jdbc driver class is empty!");
        }
        if (url == null || url.trim().length() == 0) {
            throw new IllegalArgumentException("the jdbc url is empty!");
        }
        Class.forName(driver);
        try {
            Connection conn = DriverManager.getConnection(url, user, pwd);
            return conn;
        }
        catch (SQLException e) {
            throw new SQLException("connect db fail! (url, user, driver)=(" + url + ", " + user + ", " + driver + "), err: " + e);
        }
    }

    private static String getSQLKeywords(DatabaseMetaData dbMeta) {
        try {
            return dbMeta.getSQLKeywords();
        }
        catch (SQLException e) {
            return "unable getSQLKeywords! err: " + e;
        }
    }
}

