/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.dao;

public class Condition {
    private String op;
    private String field;
    private String bindName;
    private Object value;
    private Object value2;
    static final String OP_LIKE = "like";
    static final String OP_ISNULL = "is null";
    static final String OP_ISNOTNULL = "is not null";
    static final String OP_GT = ">";
    static final String OP_GTE = ">=";
    static final String OP_LT = "<";
    static final String OP_LTE = "<=";
    static final String OP_EQUAL = "=";
    static final String OP_NOTEQUAL = "!=";
    static final String OP_IN = "in";
    static final String BETWEEN = "between";
    private static final String[] VALID_OPS = new String[]{"=", "like", ">=", "<=", ">", "<", "in", "!=", "is null"};

    private Condition(String op, String prop, Object value) {
        this.op = op;
        this.field = prop;
        this.value = value;
    }

    private Condition(String op, String prop, Object value1, Object value2) {
        this.op = op;
        this.field = prop;
        this.value = value1;
        this.value2 = value2;
    }

    public boolean noNeedToBindParam() {
        return this.value == null && this.value2 == null;
    }

    public boolean needBindOneParam() {
        return this.value != null && this.value2 == null;
    }

    public boolean needBindTwoParams() {
        return this.value != null && this.value2 != null;
    }

    public boolean needBindCollectionParam() {
        return OP_IN.equals(this.op);
    }

    public boolean isBetweenCondition() {
        return BETWEEN.equals(this.op);
    }

    public boolean isLikeCondition() {
        return OP_LIKE.equals(this.op);
    }

    public String getOp() {
        return this.op;
    }

    public String getField() {
        return this.field;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getValue2() {
        return this.value2;
    }

    public String getBindName() {
        return this.bindName;
    }

    void setBindName(String bindName) {
        this.bindName = bindName;
    }

    static boolean isValidOp(String op) {
        int i = 0;
        while (i < VALID_OPS.length) {
            if (VALID_OPS[i].equals(op)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static Condition buildCondition(String op, String field, Object value) {
        if (!Condition.isValidOp(op)) {
            return null;
        }
        if (OP_ISNULL.equals(op) || OP_ISNOTNULL.equals(op)) {
            return new Condition(op, field, value);
        }
        if (value == null) {
            return null;
        }
        return new Condition(op, field, value);
    }

    public static Condition buildBetweenCondition(String field, Object value, Object value2) {
        if (value == null || value2 == null) {
            return null;
        }
        return new Condition(BETWEEN, field, value, value2);
    }
}

