/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.cms.impl;

import com.trs.dev4.jdk16.cms.CMSException;
import com.trs.dev4.jdk16.cms.impl.TemplateParameter;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

public class TagItem {
    private String m_sName;
    private HashMap<String, String> m_hAttributes = null;
    private Hashtable<String, String> m_hExtraAttributes = null;
    private HashMap<String, TemplateParameter> m_hVariableParameters = null;
    private List<TagItem> m_children = null;
    private int m_iBeginLineNo;
    private int m_iBeginColumn;
    private int m_iCloseLineNo;
    private int m_iCloseColumn;
    private TagItem m_parentItem;
    private boolean m_zIsVariableDeclare;
    private TemplateParameter m_oVariableParameter;
    private String content;

    public static final boolean isVariableParameter(String _sValue) {
        if (_sValue == null || _sValue.length() <= 3) {
            return false;
        }
        return _sValue.charAt(0) == '$' && _sValue.charAt(1) == '{' && _sValue.charAt(_sValue.length() - 1) == '}';
    }

    public TagItem() {
    }

    public TagItem(String _tagText) {
        this.content = _tagText;
    }

    public void clear() {
        if (this.m_hAttributes != null && !this.m_hAttributes.isEmpty()) {
            this.m_hAttributes.clear();
        }
        if (this.m_hExtraAttributes != null && !this.m_hExtraAttributes.isEmpty()) {
            this.m_hExtraAttributes.clear();
        }
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String name) {
        if (name != null) {
            name = name.toUpperCase();
        }
        if (this.m_sName == null) {
            this.m_sName = name;
        } else {
            this.m_sName = name;
            this.m_zIsVariableDeclare = false;
        }
    }

    public HashMap<String, String> getAttributes() {
        return this.m_hAttributes;
    }

    public String getAttribute(String _sName) {
        if (this.m_hAttributes == null || _sName == null) {
            return null;
        }
        return this.m_hAttributes.get(_sName.toUpperCase());
    }

    public String getAttributeTrim(String _sName) {
        String sValue = this.getAttribute(_sName);
        return sValue == null ? null : sValue.trim();
    }

    public String getRequiredAttribute(String _sName) {
        String sValue = this.getAttribute(_sName);
        if (sValue == null || sValue.length() == 0) {
            throw new CMSException("Attribute [" + _sName + "] required!");
        }
        return sValue;
    }

    public String getRequiredAttributeTrim(String _sName) {
        String sValue = this.getAttributeTrim(_sName);
        if (sValue == null || sValue.length() == 0) {
            throw new CMSException("Property [" + _sName + "] required!");
        }
        return sValue;
    }

    public int getIntAttribute(String _sName, int _nDefault) {
        String sValue = this.getAttributeTrim(_sName);
        if (sValue == null || sValue.length() == 0) {
            return _nDefault;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (Exception ex) {
            throw new CMSException("Value [" + sValue + "] of attribute [" + _nDefault + "] is not integer!", ex);
        }
    }

    public boolean getBooleanAttribute(String _sName, boolean _bDefault) {
        String sValue = this.getAttribute(_sName);
        if (sValue == null || (sValue = sValue.trim()).length() == 0) {
            return _bDefault;
        }
        return sValue.equalsIgnoreCase("true");
    }

    public void setAttributes(HashMap<String, String> _attributes) {
        this.m_hAttributes = _attributes;
    }

    public void setAttribute(String _sName, String _sValue) {
        if (_sName == null || (_sName = _sName.trim()).length() == 0) {
            throw new CMSException("Property name required!");
        }
        _sName = _sName.toUpperCase();
        if (_sValue == null) {
            if (this.m_zIsVariableDeclare) {
                this.parseVariableDeclare(_sName, _sValue);
            } else if (this.m_hVariableParameters != null) {
                this.m_hVariableParameters.remove(_sName);
            }
            if (this.m_hAttributes != null) {
                this.m_hAttributes.remove(_sName);
            }
        } else {
            if (this.m_zIsVariableDeclare) {
                this.parseVariableDeclare(_sName, _sValue);
            } else if (TagItem.isVariableParameter(_sValue)) {
                this.setVariableParameter(_sName, _sValue);
            }
            if (this.m_hAttributes == null) {
                this.m_hAttributes = new HashMap();
            }
            this.m_hAttributes.put(_sName.toUpperCase(), _sValue);
        }
    }

    public void setAttribute(String _sName, int _nValue) {
        this.setAttribute(_sName, String.valueOf(_nValue));
    }

    public void setAttribute(String _sName, boolean _bValue) {
        this.setAttribute(_sName, _bValue ? "true" : "false");
    }

    public String removeAttribute(String _sName) {
        if (_sName == null) {
            return null;
        }
        _sName = _sName.toUpperCase();
        if (this.m_hVariableParameters != null) {
            this.m_hVariableParameters.remove(_sName);
        }
        if (this.m_hAttributes != null) {
            return this.m_hAttributes.remove(_sName);
        }
        return null;
    }

    public List<TagItem> getChildren() {
        return this.m_children;
    }

    public boolean hasChildren() {
        return this.m_children != null && this.m_children.size() > 0;
    }

    public boolean containsChild(String _sName) {
        if (this.m_children == null) {
            return false;
        }
        int i = 0;
        int nSize = this.m_children.size();
        while (i < nSize) {
            TagItem child = this.m_children.get(i);
            if (child != null && child instanceof TagItem && child.getName().equalsIgnoreCase(_sName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getText() {
        TagItem firstChild;
        if (this.m_children != null && !this.m_children.isEmpty() && (firstChild = this.m_children.get(0)) != null && firstChild instanceof String) {
            return (String)((Object)firstChild);
        }
        return null;
    }

    public String setText(String sNewValue) {
        String sOldValue = this.getText();
        if (sNewValue == null) {
            return sOldValue;
        }
        if (this.m_children == null) {
            this.m_children = new ArrayList<TagItem>();
        }
        if (this.m_children.isEmpty()) {
            this.m_children.add(new TagItem(sNewValue));
        } else {
            TagItem firstChild = this.m_children.get(0);
            if (firstChild != null && firstChild instanceof String) {
                this.m_children.set(0, new TagItem(sNewValue));
            } else {
                this.m_children.add(0, new TagItem(sNewValue));
            }
        }
        return sOldValue;
    }

    public void setChildren(List<TagItem> _children) {
        this.m_children = _children;
    }

    public void addChild(TagItem _child) {
        if (_child == null) {
            return;
        }
        if (this.m_children == null) {
            this.m_children = new ArrayList<TagItem>();
        }
        this.m_children.add(_child);
    }

    public void addChild(String _child) {
        if (_child == null) {
            return;
        }
        if (this.m_children == null) {
            this.m_children = new ArrayList<TagItem>();
        }
        this.m_children.add(new TagItem(_child));
    }

    public String toString() {
        if (StringHelper.isEmpty(this.getName())) {
            return this.content;
        }
        StringBuffer buff = new StringBuffer();
        buff.append("<").append(this.getName());
        if (this.m_hAttributes != null) {
            for (String key : this.m_hAttributes.keySet()) {
                buff.append(' ').append(key).append("=\"");
                buff.append(StringHelper.replaceAll(this.m_hAttributes.get(key), "\"", "\\\""));
                buff.append("\"");
            }
        }
        buff.append(">");
        if (this.m_children != null) {
            int i = 0;
            while (i < this.m_children.size()) {
                TagItem aChild = this.m_children.get(i);
                if (aChild instanceof TagItem) {
                    buff.append(aChild.toString());
                } else {
                    buff.append(((Object)aChild).toString());
                }
                ++i;
            }
        }
        buff.append("</").append(this.getName()).append(">");
        return buff.toString();
    }

    public int getBeginColumn() {
        return this.m_iBeginColumn;
    }

    public void setBeginColumn(int beginColumn) {
        this.m_iBeginColumn = beginColumn;
    }

    public int getBeginLineNo() {
        return this.m_iBeginLineNo;
    }

    public void setBeginLineNo(int beginLineNo) {
        this.m_iBeginLineNo = beginLineNo;
    }

    public int getCloseColumn() {
        return this.m_iCloseColumn;
    }

    public void setCloseColumn(int closeColumn) {
        this.m_iCloseColumn = closeColumn;
    }

    public int getCloseLineNo() {
        return this.m_iCloseLineNo;
    }

    public void setCloseLineNo(int closeLineNo) {
        this.m_iCloseLineNo = closeLineNo;
    }

    public String getDescWithPos() {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(this.getName());
        sb.append("[\u884c:").append(this.m_iBeginLineNo).append(',');
        sb.append("\u5217:").append(this.m_iBeginColumn).append(']');
        sb.append(">");
        return sb.toString();
    }

    public void setExtraAttribute(String _sAttrName, String _sValue) {
        if (this.m_hExtraAttributes == null) {
            Hashtable<String, String> hTemp = new Hashtable<String, String>(1);
            hTemp.put(_sAttrName.toUpperCase(), _sValue);
            this.m_hExtraAttributes = hTemp;
        } else {
            this.m_hExtraAttributes.put(_sAttrName.toUpperCase(), _sValue);
        }
    }

    public String getExtraAttributeValue(String _sAttrName) {
        if (this.m_hExtraAttributes == null) {
            return null;
        }
        String value = this.m_hExtraAttributes.get(_sAttrName.toUpperCase());
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public HashMap<String, TemplateParameter> getVariableParameters() {
        return this.m_hVariableParameters;
    }

    public TemplateParameter getVariableParameter(String _sName) {
        if (_sName == null || this.m_hVariableParameters == null) {
            return null;
        }
        return this.m_hVariableParameters.get(_sName.toUpperCase());
    }

    private void setVariableParameter(String _sName, String _sValue) {
        if (this.m_hVariableParameters == null) {
            this.m_hVariableParameters = new HashMap();
        }
        TemplateParameter aParameter = new TemplateParameter();
        this.m_hVariableParameters.put(_sName, aParameter);
        String sValue = _sValue.substring(2, _sValue.length() - 1);
        int iNameSplit = sValue.indexOf(126);
        if (iNameSplit <= 0) {
            aParameter.setParameterName(sValue);
            return;
        }
        aParameter.setParameterName(sValue.substring(0, iNameSplit++));
        int iTypeSplit = sValue.indexOf(126, iNameSplit);
        if (iTypeSplit <= 0) {
            aParameter.setParameterType(TemplateParameter.Type.STRING);
            aParameter.setParameterDefault(sValue.substring(iNameSplit));
            return;
        }
        aParameter.setParameterType(sValue.substring(iNameSplit, iTypeSplit++));
        int iDefaultSplit = sValue.indexOf(126, iTypeSplit);
        if (iDefaultSplit <= 0) {
            aParameter.setParameterDefault(sValue.substring(iTypeSplit));
            return;
        }
        aParameter.setParameterDefault(sValue.substring(iTypeSplit, iDefaultSplit++));
        int iSplitThis = 0;
        int iSplitLast = iDefaultSplit;
        while ((iSplitThis = sValue.indexOf(126, iSplitLast)) > 0) {
            aParameter.addEnumValue(sValue.substring(iSplitLast, iSplitThis));
            iSplitLast = iSplitThis + 1;
        }
        if (iSplitLast < sValue.length()) {
            aParameter.addEnumValue(sValue.substring(iSplitLast));
        } else {
            aParameter.setCanCustom(true);
        }
    }

    private void parseVariableDeclare(String _sName, String _sValue) {
        if (this.m_oVariableParameter == null) {
            throw new IllegalStateException("'m_oVariableParameter' is null");
        }
        if ("NAME".equals(_sName)) {
            if (_sValue == null) {
                throw new IllegalArgumentException("'Variable name' is null");
            }
            this.m_oVariableParameter.setParameterName(_sValue);
            return;
        }
        if ("TYPE".equals(_sName)) {
            this.m_oVariableParameter.setParameterType(_sValue);
            return;
        }
        if ("DEFAULT".equals(_sName)) {
            this.m_oVariableParameter.setParameterDefault(_sValue);
            return;
        }
        if ("SPLIT".equals(_sName)) {
            if (_sValue != null && (_sValue = _sValue.trim()).length() == 1) {
                this.m_oVariableParameter.setEnumSplit(_sValue.charAt(0));
            }
            return;
        }
        if ("ENUMERATE".equals(_sName)) {
            this.m_oVariableParameter.addEnumValue(_sValue);
            return;
        }
        if ("CANCUSTOM".equals(_sName)) {
            this.m_oVariableParameter.setCanCustom("true".equalsIgnoreCase(_sValue));
            return;
        }
    }

    public void setParent(TagItem _parentItem) {
        this.m_parentItem = _parentItem;
    }

    public TagItem getParent() {
        return this.m_parentItem;
    }

    public List<TagItem> findParentItems() {
        TagItem parent = this.m_parentItem;
        ArrayList<TagItem> parents = new ArrayList<TagItem>(3);
        while (parent != null) {
            parents.add(parent);
            parent = parent.getParent();
        }
        return parents;
    }

    public String getContent() {
        return this.content;
    }
}

