/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.cacheserver.memcached;

import com.trs.dev4.jdk16.cacheserver.memcached.IMemcachedClient;
import com.trs.dev4.jdk16.model.IModuleLifecycle;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import javax.annotation.Resource;
import net.rubyeye.xmemcached.KeyIterator;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.MemcachedClientStateListener;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.exception.MemcachedException;
import net.rubyeye.xmemcached.impl.KetamaMemcachedSessionLocator;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.apache.log4j.Logger;

public class MemcachedClientXImpl
implements IMemcachedClient,
IModuleLifecycle {
    private static final Logger logger = Logger.getLogger(MemcachedClientXImpl.class);
    MemcachedClient memcachedClient = null;
    @Resource(name="memcachedClientStateListeners")
    private List<MemcachedClientStateListener> memcachedClientStateListeners = new ArrayList<MemcachedClientStateListener>();
    private String servers;

    public MemcachedClientXImpl(String servers) {
        this.servers = servers;
    }

    @Override
    public void set(String key, int expr, Object value) {
        try {
            if (this.memcachedClient != null) {
                boolean success = this.memcachedClient.set(key, expr, value);
                logger.debug((Object)("set key-value(" + key + "-" + value + ")[" + expr + "] is (" + success + ")"));
            } else {
                logger.error((Object)"memcachedClient == null.");
            }
        }
        catch (TimeoutException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (MemcachedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void add(String key, int expr, Object value) {
        try {
            if (this.memcachedClient != null) {
                this.memcachedClient.add(key, expr, value);
            } else {
                logger.error((Object)"memcachedClient == null.");
            }
        }
        catch (TimeoutException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (MemcachedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void replace(String key, int expr, Object value) {
        try {
            if (this.memcachedClient != null) {
                this.memcachedClient.replace(key, expr, value);
            } else {
                logger.error((Object)"memcachedClient == null.");
            }
        }
        catch (TimeoutException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (MemcachedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void delete(String key) {
        try {
            if (this.memcachedClient != null) {
                this.memcachedClient.deleteWithNoReply(key);
            } else {
                logger.error((Object)"memcachedClient == null.");
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (MemcachedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Object get(String key) {
        try {
            if (this.memcachedClient != null) {
                return this.memcachedClient.get(key);
            }
            logger.error((Object)"memcachedClient == null.");
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (MemcachedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (TimeoutException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public Map<String, String> getStats(String server) {
        try {
            Map result = this.memcachedClient.getStats();
            for (InetSocketAddress inetSocketAddress : result.keySet()) {
                if (!inetSocketAddress.equals(AddrUtil.getAddresses((String)server))) continue;
                return (Map)result.get(inetSocketAddress);
            }
        }
        catch (MemcachedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (TimeoutException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return new HashMap<String, String>();
    }

    @Override
    public Collection<InetSocketAddress> getAvaliableServers() {
        return this.memcachedClient.getAvaliableServers();
    }

    @Override
    public List<String> getServersDescription() {
        return this.memcachedClient.getServersDescription();
    }

    @Override
    public Map<String, String> getStats(String server, String itemName) {
        try {
            Map result = this.memcachedClient.getStatsByItem(itemName);
            for (InetSocketAddress inetSocketAddress : result.keySet()) {
                if (!inetSocketAddress.equals(AddrUtil.getAddresses((String)server))) continue;
                return (Map)result.get(inetSocketAddress);
            }
        }
        catch (MemcachedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (TimeoutException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return new HashMap<String, String>();
    }

    @Override
    public Object asynGet(String key) {
        return this.get(key);
    }

    public List<MemcachedClientStateListener> getMemcachedClientStateListeners() {
        return this.memcachedClientStateListeners;
    }

    @Override
    public List<String> listAllKeys(String server) {
        KeyIterator keyIterator = null;
        try {
            keyIterator = this.memcachedClient.getKeyIterator(AddrUtil.getOneAddress((String)server));
        }
        catch (MemcachedException e) {
            logger.error((Object)("server(" + server + ") listAllKeys:" + e.getMessage()), (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error((Object)("server(" + server + ") listAllKeys:" + e.getMessage()), (Throwable)e);
        }
        catch (TimeoutException e) {
            logger.error((Object)("server(" + server + ") listAllKeys:" + e.getMessage()), (Throwable)e);
        }
        LinkedList<String> keys = new LinkedList<String>();
        if (keyIterator != null) {
            while (keyIterator.hasNext()) {
                try {
                    keys.add(keyIterator.next());
                }
                catch (MemcachedException e) {
                    logger.error((Object)("server(" + server + ") key next:" + e.getMessage()), (Throwable)e);
                }
                catch (TimeoutException e) {
                    logger.error((Object)("server(" + server + ") key next:" + e.getMessage()), (Throwable)e);
                }
                catch (InterruptedException e) {
                    logger.error((Object)("server(" + server + ") key next:" + e.getMessage()), (Throwable)e);
                }
            }
        }
        return keys;
    }

    public void setMemcachedClientStateListeners(List<MemcachedClientStateListener> memcachedClientStateListeners) {
        this.memcachedClientStateListeners = memcachedClientStateListeners;
    }

    @Override
    public String getModuleName() {
        return "MemcachedClientXImpl";
    }

    @Override
    public void start() {
        try {
            XMemcachedClientBuilder builder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)this.servers));
            builder.setSessionLocator((MemcachedSessionLocator)new KetamaMemcachedSessionLocator());
            for (MemcachedClientStateListener memcachedClientStateListener : this.memcachedClientStateListeners) {
                builder.addStateListener(memcachedClientStateListener);
            }
            builder.setConnectionPoolSize(5);
            this.memcachedClient = builder.build();
            this.memcachedClient.setOpTimeout(5000L);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            this.memcachedClient = null;
        }
    }

    @Override
    public void stop() {
        if (this.memcachedClient != null) {
            try {
                this.memcachedClient.shutdown();
            }
            catch (IOException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void restart() {
    }
}

