/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.cacheserver.impl;

import com.trs.dev4.jdk16.cacheserver.ICacheServer;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;

public class CacheServer
implements ICacheServer {
    protected static Logger logger = Logger.getLogger(CacheServer.class);
    private Map<String, CacheObject> memoryCache = new ConcurrentHashMap<String, CacheObject>();
    int maxExpire = 1200;
    String appKey = "trs:";
    private Thread autoCleaner = new Thread(){

        @Override
        public void run() {
            while (true) {
                Set keys = CacheServer.this.memoryCache.keySet();
                for (String key : keys) {
                    try {
                        CacheServer.this.get(key);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(600000L);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    };

    public void setMaxExpire(int maxExpire) {
        this.maxExpire = maxExpire;
    }

    public int getExpire(int expire) {
        return expire <= 0 || expire > this.maxExpire ? this.maxExpire : expire;
    }

    public void setAppKey(String appKey) {
        this.appKey = String.valueOf(appKey) + ":";
    }

    @Override
    public String getAppKey() {
        return this.appKey;
    }

    public CacheServer() {
        this.autoCleaner.start();
    }

    @Override
    public void add(String key, int expr, Object value) {
        if (this.memoryCache.containsKey(key)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("add cache:" + StringHelper.join(new Object[]{key, expr, value})));
        }
        this.memoryCache.put(key, new CacheObject(value, this.getExpire(expr)));
    }

    @Override
    public void delete(String key) {
        this.memoryCache.remove(key);
    }

    @Override
    public Object get(String key) {
        CacheObject cacheObject = this.memoryCache.get(key);
        if (cacheObject == null) {
            return null;
        }
        if (cacheObject.isExpired()) {
            this.memoryCache.remove(key);
            return null;
        }
        return cacheObject.getValue();
    }

    @Override
    public void replace(String key, int expr, Object value) {
        if (!this.memoryCache.containsKey(key)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("replace cache:" + StringHelper.join(new Object[]{key, expr, value})));
        }
        this.memoryCache.put(key, new CacheObject(value, this.getExpire(expr)));
    }

    @Override
    public void set(String key, int expr, Object value) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("set cache:" + StringHelper.join(new Object[]{key, expr, value})));
        }
        this.memoryCache.put(key, new CacheObject(value, this.getExpire(expr)));
    }

    static class CacheObject {
        long expr = 0L;
        Object value = null;

        public CacheObject(Object value, long expr) {
            this.expr = System.currentTimeMillis() + expr * 1000L;
            this.value = value;
        }

        public boolean isExpired() {
            return this.expr <= System.currentTimeMillis();
        }

        public Object getValue() {
            return this.value;
        }
    }
}

