/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.cacheserver;

import com.trs.dev4.jdk16.cacheserver.CacheMe;
import com.trs.dev4.jdk16.cacheserver.ICacheServer;
import com.trs.dev4.jdk16.dao.SearchFilter;
import com.trs.dev4.jdk16.model.IBaseManager;
import com.trs.dev4.jdk16.session.ISessionUser;
import com.trs.dev4.jdk16.session.impl.ContextHelper;
import com.trs.dev4.jdk16.utils.StringHelper;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class CacheServerAspectHandler {
    protected static Logger logger = Logger.getLogger(CacheServerAspectHandler.class);
    @Resource(name="cacheServer")
    private ICacheServer cacheServer;
    private static ConcurrentHashMap<String, String> mapKeys = new ConcurrentHashMap();

    @Pointcut(value="execution(* * ..**Manager*.*(..))")
    public void manager() {
    }

    @Pointcut(value="@annotation(cacheme)", argNames="cacheme")
    public void annoCache(CacheMe cacheme) {
    }

    @Around(value="manager() && annoCache(cacheme)", argNames="cacheme")
    public Object aroundAnnoLog(ProceedingJoinPoint jointPoint, CacheMe cacheMeAnno) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"aroundAnnoLog:==");
            logger.debug((Object)("method:" + jointPoint.getSignature()));
            logger.debug((Object)("is method signature:" + (jointPoint.getSignature() instanceof MethodSignature)));
            logger.debug((Object)("args:" + StringHelper.join(jointPoint.getArgs())));
        }
        if (!this.checkAccess((JoinPoint)jointPoint)) {
            return this.execute(jointPoint);
        }
        MethodSignature methodSignature = (MethodSignature)jointPoint.getSignature();
        Method method = methodSignature.getMethod();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("method:" + method.getName()));
            logger.debug((Object)("logMeAnno.key():" + cacheMeAnno.key()));
            logger.debug((Object)("logMeAnno.expire():" + cacheMeAnno.expire()));
            logger.debug((Object)("logMeAnno.user():" + cacheMeAnno.user()));
        }
        Object result = null;
        String prefix = String.valueOf(this.cacheServer.getAppKey()) + jointPoint.getTarget().getClass().getSimpleName() + "." + method.getName();
        String key = this.adapteKey(this.buildKey(cacheMeAnno, jointPoint.getArgs(), prefix));
        int expr = cacheMeAnno.expire();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("key:" + key));
            logger.debug((Object)("expr:" + expr));
            logger.debug((Object)("prefix:" + prefix));
        }
        try {
            result = this.cacheServer.get(key);
        }
        catch (Throwable ex) {
            logger.error((Object)("Get cache from server error:" + ex.getMessage()), ex);
        }
        if (result != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("cache hitted:" + key));
                logger.debug((Object)("result:" + result));
            }
            return result;
        }
        result = this.execute(jointPoint);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("set cache:" + key));
            logger.debug((Object)("result:" + result));
        }
        try {
            this.cacheServer.set(key, expr, result);
        }
        catch (Throwable ex) {
            logger.error((Object)("Set cache to server error:" + ex.getMessage()), ex);
        }
        return result;
    }

    private String adapteKey(String key) {
        String mapKey = mapKeys.get(key);
        if (mapKey == null) {
            mapKey = key.replaceAll("[ \r\n]", "|");
            if (mapKey.length() >= 250) {
                mapKey = String.valueOf(mapKey.substring(mapKey.length() - 40)) + mapKey.hashCode();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("key auto adapted as:" + mapKey));
            }
            mapKeys.put(key, mapKey);
        }
        return mapKey;
    }

    private String buildKey(CacheMe cacheMeAnno, Object[] args, String prefix) {
        String annoKey;
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(';');
        String userName = ContextHelper.getLoginUser().getUserName();
        if (cacheMeAnno.user()) {
            sb.append("U:").append(userName).append(';');
        }
        if (!StringHelper.isEmpty(annoKey = cacheMeAnno.key())) {
            sb.append(annoKey);
            return sb.toString();
        }
        int i = 0;
        while (i < args.length) {
            if (this.needConvertKey(args[i])) {
                sb.append(this.convertKey(args[i])).append(';');
            } else {
                sb.append(args[i].toString()).append(';');
            }
            ++i;
        }
        return sb.toString();
    }

    private Object convertKey(Object object) {
        if (object == null) {
            return "null";
        }
        if (object.getClass().isArray()) {
            return "[:" + StringHelper.toString((Object[])object);
        }
        if (object instanceof ISessionUser) {
            return "U:" + ((ISessionUser)object).getUserName();
        }
        if (object instanceof SearchFilter) {
            return this.searchFilterKey((SearchFilter)object);
        }
        return "";
    }

    private String searchFilterKey(SearchFilter object) {
        return object.getCacheKey();
    }

    private boolean needConvertKey(Object object) {
        if (object == null) {
            return true;
        }
        if (object.getClass().isArray()) {
            return true;
        }
        if (object instanceof ISessionUser) {
            return true;
        }
        return object instanceof SearchFilter;
    }

    private Object execute(ProceedingJoinPoint jointPoint) throws Throwable {
        return jointPoint.proceed(jointPoint.getArgs());
    }

    private boolean checkAccess(JoinPoint jointPoint) {
        if (this.cacheServer == null) {
            return false;
        }
        if (!(jointPoint.getSignature() instanceof MethodSignature)) {
            return false;
        }
        if (!(jointPoint.getTarget() instanceof IBaseManager)) {
            return false;
        }
        Object[] args = jointPoint.getArgs();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Joinpoint(" + jointPoint + ")args(" + args.length + "):" + args));
        }
        int i = 0;
        while (i < args.length) {
            if (args[i] != null) {
                Class<?> clazz;
                Object temp = args[i];
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("args[" + i + "] : temp = " + temp + ")."));
                }
                if (temp.getClass().isArray()) {
                    Object[] objects = (Object[])temp;
                    if (objects.length == 0) {
                        return false;
                    }
                    temp = objects[0];
                }
                if (!(clazz = temp.getClass()).isPrimitive()) {
                    SearchFilter filter;
                    if (!(args[i] instanceof ISessionUser) && !(args[i] instanceof SearchFilter)) {
                        return false;
                    }
                    if (args[i] instanceof SearchFilter && !(filter = (SearchFilter)args[i]).isCacheable()) {
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }
}

