/*
 * Decompiled with CFR 0.152.
 */
package com.eprobiti.trs;

import com.eprobiti.trs.TRSConnection;
import com.eprobiti.trs.TRSException;
import com.eprobiti.trs.TRSJNIV61;
import com.eprobiti.trs.TRSUtils;

public class TRSObject {
    private int m_iObjectType = 0;
    private String m_sName = null;
    private String m_sOwner = null;
    private String m_sComment = null;
    private String m_sObjectTypeName = null;
    TRSConnection m_oConn = null;
    private static final String[] m_saObjectTypes = new String[]{"\u7528\u6237\u7ec4", "\u7528\u6237", "\u6570\u636e\u5e93", "\u6570\u636e\u5e93\u5b57\u6bb5", "\u89c6\u56fe", "\u89c6\u56fe\u5b57\u6bb5", "\u6570\u636e\u683c\u5f0f"};
    private static final String[] m_saBaseTypes = new String[]{"USERDEF", "SEGMENT", "SEGMENTEX", "STOP", "STOPEX", "SPARSE", "THESAURUS", "SYNONYM", "ANTONYM"};
    private static final String[] m_saColumnTypes = new String[]{"DATE", "NUMBER", "CHAR", "PHRASE", "DOCUMENT", "BIT"};
    private static final String[] m_saUserTypes = new String[]{"DBA", "GDA", "RESOURCE", "CONNECT"};
    private Property[] m_oaProperties = null;

    TRSConnection getConnection() throws TRSException {
        if (this.m_oConn == null) {
            throw TRSException.New(500002, "");
        }
        return this.m_oConn;
    }

    long getHandle() throws TRSException {
        return this.m_oConn.getHandle();
    }

    TRSException newTRSException() throws TRSException {
        return this.m_oConn.newTRSException();
    }

    void setProperties(String strPropertyValues) throws TRSException {
        String[] _saPropertySplits = TRSUtils.split(strPropertyValues, "\u0001");
        if (_saPropertySplits == null) {
            throw TRSException.New(500009, strPropertyValues);
        }
        int i = 0;
        while (i < _saPropertySplits.length) {
            String _strName = "";
            String _strValue = "";
            int _iEnd = _saPropertySplits[i].indexOf("=");
            if (_iEnd != -1) {
                _strName = _saPropertySplits[i].substring(0, _iEnd);
                _strValue = _saPropertySplits[i].substring(_iEnd + 1);
                int j = 0;
                while (j < this.m_oaProperties.length) {
                    if (_strName.equalsIgnoreCase(this.m_oaProperties[j].strName)) {
                        this.m_oaProperties[j].strvalue = _strValue;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.m_sName = this.getProperty("NAME");
        this.m_sComment = this.getProperty("COMMENT");
        switch (this.m_iObjectType) {
            case 17: {
                this.m_sOwner = this.getProperty("GROUP");
                break;
            }
            case 18: 
            case 20: {
                this.m_sOwner = this.getProperty("OWNER");
                break;
            }
            case 22: {
                this.m_sOwner = this.getProperty("CLASS");
            }
        }
    }

    void updateProperties() throws TRSException {
        int i = 0;
        while (i < this.m_oaProperties.length) {
            if (this.m_oaProperties[i].strUpdate != null) {
                this.m_oaProperties[i].strvalue = this.m_oaProperties[i].strUpdate;
            }
            ++i;
        }
    }

    String getUpdateProperties() {
        String _strProperties = "";
        if (this.m_sName != null) {
            _strProperties = "NAME=" + this.m_sName + "\u0001";
        }
        if (this.m_sOwner != null && !this.m_sOwner.equals("") && this.m_iObjectType != 21 && this.m_iObjectType != 19 && this.m_iObjectType != 16) {
            _strProperties = String.valueOf(_strProperties) + "OWNER=" + this.m_sOwner + "\u0001";
        }
        int _iCount = this.m_oaProperties.length;
        int i = 0;
        while (i < _iCount) {
            if (this.m_oaProperties[i].strUpdate != null) {
                _strProperties = String.valueOf(_strProperties) + this.m_oaProperties[i].strName + "=" + this.m_oaProperties[i].strUpdate + "\u0001";
            }
            ++i;
        }
        return _strProperties;
    }

    String getProperties() {
        String _strProperties = "";
        int _iCount = this.m_oaProperties.length;
        int i = 0;
        while (i < _iCount) {
            if (this.m_oaProperties[i].strvalue != null) {
                _strProperties = String.valueOf(_strProperties) + this.m_oaProperties[i].strName + "=" + this.m_oaProperties[i].strvalue + "\u0001";
            }
            ++i;
        }
        return _strProperties;
    }

    TRSObject(TRSConnection conn, int iObjectType, String sObjectName, String[] saPropertyNames) throws TRSException {
        String[] _saOwnerName;
        this.m_oConn = conn;
        this.m_iObjectType = iObjectType;
        if (iObjectType < 16 || iObjectType > 22) {
            throw TRSException.New(500015, String.valueOf(iObjectType));
        }
        if (sObjectName == null || sObjectName.equals("")) {
            throw TRSException.New(500014, "");
        }
        this.m_sObjectTypeName = m_saObjectTypes[this.m_iObjectType - 16];
        this.m_oaProperties = new Property[saPropertyNames.length];
        int i = 0;
        while (i < saPropertyNames.length) {
            this.m_oaProperties[i] = new Property(saPropertyNames[i], "", null);
            ++i;
        }
        this.m_sName = sObjectName;
        if ((iObjectType == 18 || iObjectType == 20 || iObjectType == 17 || iObjectType == 22) && (_saOwnerName = TRSUtils.split(sObjectName, ".")).length == 2) {
            this.m_sOwner = _saOwnerName[0];
            this.m_sName = _saOwnerName[1];
        }
    }

    TRSObject(TRSConnection conn, int iObjectType, String[] saPropertyNames, String strPropertValues) throws TRSException {
        this.m_oConn = conn;
        this.m_iObjectType = iObjectType;
        if (iObjectType < 16 || iObjectType > 22) {
            throw TRSException.New(500015, String.valueOf(iObjectType));
        }
        if (strPropertValues == null || strPropertValues.equals("")) {
            throw TRSException.New(500011, "");
        }
        this.m_sObjectTypeName = m_saObjectTypes[this.m_iObjectType - 16];
        this.m_oaProperties = new Property[saPropertyNames.length];
        int i = 0;
        while (i < saPropertyNames.length) {
            this.m_oaProperties[i] = new Property(saPropertyNames[i], "", null);
            ++i;
        }
        this.setProperties(strPropertValues);
    }

    public void cancelAlter() {
        int _iCount = this.m_oaProperties.length;
        int i = 0;
        while (i < _iCount) {
            this.m_oaProperties[i].strUpdate = null;
            ++i;
        }
    }

    public String delete(String strObjName) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_DeleteObject(this.getHandle(), this.m_iObjectType, this.getFullName());
        if (_ret != 1) {
            throw this.newTRSException();
        }
        return this.getFullName();
    }

    public boolean delete() throws TRSException {
        this.delete("");
        return true;
    }

    public boolean getBoolProperty(String strName) throws TRSException {
        try {
            String _sPropValue = this.getProperty(strName);
            return _sPropValue.equalsIgnoreCase("TRUE") || _sPropValue.equals("1");
        }
        catch (TRSException e) {
            throw e;
        }
        catch (NumberFormatException e) {
            throw TRSException.New(500011, "NOT BOOL, " + strName);
        }
    }

    public String getComment() {
        return this.m_sComment;
    }

    public String getFullName() {
        String _strFullName = this.m_sName;
        if (!(this.m_sOwner == null || this.m_sOwner.equals("") || this.m_iObjectType != 18 && this.m_iObjectType != 20)) {
            _strFullName = String.valueOf(this.m_sOwner) + "." + this.m_sName;
        }
        return _strFullName;
    }

    public int getIntProperty(String strName) throws TRSException {
        try {
            String _sPropValue = this.getProperty(strName);
            return Integer.parseInt(_sPropValue);
        }
        catch (TRSException e) {
            throw e;
        }
        catch (NumberFormatException e) {
            throw TRSException.New(500011, "NOT INT, " + strName);
        }
    }

    public String getName() {
        return this.m_sName;
    }

    public int getObjectType() {
        return this.m_iObjectType;
    }

    public String getObjectTypeName() {
        return this.m_sObjectTypeName;
    }

    public String getOwner() {
        return this.m_sOwner;
    }

    public String getProperty(String strName) throws TRSException {
        if (strName == null || strName.equals("")) {
            throw TRSException.New(500010, "");
        }
        strName = strName.trim();
        int i = 0;
        while (i < this.m_oaProperties.length) {
            if (this.m_oaProperties[i].strName.equalsIgnoreCase(strName)) {
                if (this.m_oaProperties[i].strvalue.equalsIgnoreCase("true")) {
                    return "1";
                }
                if (this.m_oaProperties[i].strvalue.equalsIgnoreCase("false")) {
                    return "0";
                }
                return this.m_oaProperties[i].strvalue;
            }
            ++i;
        }
        throw TRSException.New(500012, strName);
    }

    public int getType() {
        int _iSubType = -1;
        try {
            _iSubType = this.getIntProperty("TYPE");
            return _iSubType;
        }
        catch (TRSException e) {
            return -1;
        }
    }

    public String getTypeName() {
        int _iSubType = this.getType();
        String _strSubTypeName = "";
        switch (this.m_iObjectType) {
            case 17: {
                if (_iSubType < 32 || _iSubType > 35) break;
                _strSubTypeName = m_saUserTypes[_iSubType - 32];
                break;
            }
            case 18: {
                if (_iSubType < 48 || _iSubType > 56) break;
                _strSubTypeName = m_saBaseTypes[_iSubType - 48];
                break;
            }
            case 19: 
            case 21: {
                if (_iSubType < 64 || _iSubType > 69) break;
                _strSubTypeName = m_saColumnTypes[_iSubType - 64];
            }
        }
        return _strSubTypeName;
    }

    public String[] keys() {
        String[] _saKeys = new String[this.m_oaProperties.length];
        int i = 0;
        while (i < _saKeys.length) {
            _saKeys[i] = this.m_oaProperties[i].strName;
            ++i;
        }
        return _saKeys;
    }

    public String[] list() {
        String[] _saList = new String[this.m_oaProperties.length];
        int i = 0;
        while (i < _saList.length) {
            _saList[i] = String.valueOf(this.m_oaProperties[i].strName) + "=" + this.m_oaProperties[i].strvalue;
            ++i;
        }
        return _saList;
    }

    public boolean rename(String strNewName) throws TRSException {
        if (strNewName == null) {
            throw TRSException.New(500016, "");
        }
        int _ret = TRSJNIV61.TRS_Admin_RenameObject(this.getHandle(), this.m_iObjectType, this.m_sName, this.m_sOwner, null, strNewName);
        if (_ret < 0) {
            throw this.newTRSException();
        }
        return true;
    }

    public boolean renameobj(String strNewName) throws TRSException {
        return this.rename(strNewName);
    }

    public boolean setBoolProperty(String strName, boolean bValue) throws TRSException {
        String _sPropValue = bValue ? "1" : "0";
        return this.setProperty(strName, _sPropValue);
    }

    public boolean setIntProperty(String strName, int iValue) throws TRSException {
        return this.setProperty(strName, String.valueOf(iValue));
    }

    public boolean setProperty(String strName, String strValue) throws TRSException {
        if (strName == null || strName.equals("")) {
            return false;
        }
        strName = strName.trim();
        int i = 0;
        while (i < this.m_oaProperties.length) {
            if (strName.equalsIgnoreCase(this.m_oaProperties[i].strName)) {
                this.m_oaProperties[i].strUpdate = strValue;
                return true;
            }
            ++i;
        }
        throw TRSException.New(500012, strName);
    }

    public String toString() {
        return String.valueOf(this.m_sObjectTypeName) + ":" + this.m_sName;
    }

    private static final class Property {
        String strName;
        String strvalue;
        String strUpdate;

        Property(String _name, String _value, String _update) {
            this.strName = _name;
            this.strvalue = _value;
            this.strUpdate = _update;
        }
    }
}

