/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.axisChart.BarChart;
import org.jCharts.chartData.interfaces.IAxisChartDataSet;
import org.jCharts.imageMap.RectMapArea;
import org.jCharts.properties.StackedBarChartProperties;

abstract class StackedBarChart {
    StackedBarChart() {
    }

    static void render(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet) {
        Graphics2D graphics2D = axisChart.getGraphics2D();
        StackedBarChartProperties stackedBarChartProperties = (StackedBarChartProperties)iAxisChartDataSet.getChartTypeProperties();
        float f = axisChart.getYAxis().getZeroLineCoordinate();
        float f2 = axisChart.getXAxis().getScalePixelWidth() * stackedBarChartProperties.getPercentage();
        Rectangle2D.Float float_ = new Rectangle2D.Float(axisChart.getXAxis().getTickStartX() - f2 / 2.0f, f, f2, 0.0f);
        graphics2D.setStroke(stackedBarChartProperties.getOutlineStroke());
        int n = 0;
        while (n < iAxisChartDataSet.getNumberOfDataItems()) {
            int n2 = 0;
            while (n2 < iAxisChartDataSet.getNumberOfDataSets()) {
                if (iAxisChartDataSet.getValue(n2, n) != 0.0) {
                    float_.height = BarChart.computeScaleHeightOfValue(iAxisChartDataSet.getValue(n2, n), axisChart.getYAxis());
                    float_.y -= float_.height;
                    graphics2D.setPaint(iAxisChartDataSet.getPaint(n2));
                    graphics2D.fill(float_);
                    if (stackedBarChartProperties.getShowOutlinesFlag()) {
                        graphics2D.setPaint(stackedBarChartProperties.getOutlinePaint());
                        graphics2D.draw(float_);
                        if (axisChart.getGenerateImageMapFlag()) {
                            axisChart.getImageMap().addImageMapArea(new RectMapArea(float_, iAxisChartDataSet.getValue(n2, n), axisChart.getIDataSeries().getXAxisLabel(n), iAxisChartDataSet.getLegendLabel(n2)));
                        }
                    }
                }
                ++n2;
            }
            float_.x += axisChart.getXAxis().getScalePixelWidth();
            float_.y = f;
            ++n;
        }
    }
}

