/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jCharts.Chart;
import org.jCharts.axisChart.AreaChart;
import org.jCharts.axisChart.BarChart;
import org.jCharts.axisChart.ClusteredBarChart;
import org.jCharts.axisChart.LineChart;
import org.jCharts.axisChart.PointChart;
import org.jCharts.axisChart.StackedAreaChart;
import org.jCharts.axisChart.StackedBarChart;
import org.jCharts.axisChart.StockChart;
import org.jCharts.axisChart.XAxis;
import org.jCharts.axisChart.YAxis;
import org.jCharts.chartData.interfaces.IAxisChartDataSet;
import org.jCharts.chartData.interfaces.IDataSeries;
import org.jCharts.chartData.interfaces.IStockChartDataSet;
import org.jCharts.chartData.processors.AxisChartDataProcessor;
import org.jCharts.imageMap.ImageMap;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.test.HTMLChartTestable;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.HTMLTestable;
import org.jCharts.types.ChartType;

public final class AxisChart
extends Chart
implements HTMLChartTestable {
    private XAxis xAxis;
    private YAxis yAxis;
    private AxisProperties axisProperties;
    private IDataSeries iDataSeries;

    public AxisChart(IDataSeries iDataSeries, ChartProperties chartProperties, AxisProperties axisProperties, LegendProperties legendProperties, int n, int n2) {
        super(legendProperties, chartProperties, n, n2);
        this.iDataSeries = iDataSeries;
        this.axisProperties = axisProperties;
    }

    public IDataSeries getIDataSeries() {
        return this.iDataSeries;
    }

    protected void renderChart() {
        Serializable serializable;
        Graphics2D graphics2D = super.getGraphics2D();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        AxisChartDataProcessor axisChartDataProcessor = new AxisChartDataProcessor();
        axisChartDataProcessor.processData(this, fontRenderContext);
        this.yAxis = new YAxis(this);
        this.xAxis = new XAxis(this);
        float f = super.getChartProperties().getEdgePadding() * 2.0f;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f2 = super.getImageWidth();
        float f3 = super.getImageHeight();
        float f4 = super.renderChartTitle(this.getIDataSeries().getChartTitle(), fontRenderContext);
        f3 -= f4;
        if (super.getLegend() != null) {
            float f5;
            float f6;
            super.getLegend().calculateDrawingValues(this.iDataSeries);
            if (super.getLegend().getLegendProperties().getPlacement() == 1) {
                f2 -= (float)super.getLegend().getLegendProperties().getChartPadding();
                f2 -= super.getLegend().getWidthNeeded();
                f6 = (float)super.getLegend().getHeightNeeded() > (float)super.getImageHeight() - super.getChartProperties().getEdgePadding() * 2.0f ? super.getChartProperties().getEdgePadding() : (float)(super.getImageHeight() / 2 - super.getLegend().getHeightNeeded() / 2);
                f5 = (float)super.getImageWidth() - super.getLegend().getWidthNeeded() - super.getChartProperties().getEdgePadding();
            } else {
                f3 -= (float)this.getLegend().getLegendProperties().getChartPadding();
                f3 -= (float)this.getLegend().getHeightNeeded();
                f5 = super.getLegend().getWidthNeeded() + f > (float)super.getImageWidth() ? super.getChartProperties().getEdgePadding() : (float)(super.getImageWidth() / 2) - super.getLegend().getWidthNeeded() / 2.0f;
                f6 = (float)(super.getImageHeight() - super.getLegend().getHeightNeeded()) - super.getChartProperties().getEdgePadding();
            }
            super.getLegend().render(f5, f6);
        }
        this.yAxis.computeScaleIncrement(axisChartDataProcessor);
        this.yAxis.formatLabelsForDisplay();
        this.yAxis.computeMinimumWidthNeeded(this.iDataSeries.getYAxisTitle());
        this.xAxis.computeMinimumHeightNeeded(this.iDataSeries, axisChartDataProcessor);
        f2 -= f;
        f3 -= f;
        this.xAxis.setPixelLength(f2 -= this.yAxis.getMinimumWidthNeeded());
        this.yAxis.setPixelLength((f3 -= this.xAxis.getMinimumHeightNeeded()) - this.yAxis.getTallestLabel() / 2.0f);
        this.xAxis.setOrigin(this.yAxis.getMinimumWidthNeeded() + super.getChartProperties().getEdgePadding());
        this.yAxis.setOrigin(f3 + super.getChartProperties().getEdgePadding() + f4);
        this.xAxis.computeLabelFilter(this.iDataSeries.getNumberOfXAxisLabels(), axisChartDataProcessor.getAxisLabelProcessor());
        this.xAxis.computeScalePixelWidth(this.iDataSeries.getNumberOfXAxisLabels());
        this.yAxis.computeScalePixelWidth();
        if (this.getAxisProperties().getBackgroundPaint() != null) {
            serializable = new Rectangle2D.Float(this.xAxis.getOrigin() + 1.0f, this.yAxis.getOrigin() - this.yAxis.getPixelLength(), this.xAxis.getPixelLength(), this.yAxis.getPixelLength());
            graphics2D.setPaint(this.axisProperties.getBackgroundPaint());
            graphics2D.fill((Shape)((Object)serializable));
        }
        this.yAxis.render(graphics2D, this.getAxisProperties(), this.iDataSeries.getYAxisTitle());
        this.xAxis.render(graphics2D, this.getAxisProperties(), this.iDataSeries, axisChartDataProcessor.getAxisLabelProcessor());
        if (this.getAxisProperties().hasUserDefinedScale()) {
            serializable = new Rectangle2D.Float(this.getXAxis().getOrigin(), this.getYAxis().getOrigin() - this.getYAxis().getPixelLength() + 1.0f, this.xAxis.getPixelLength(), this.yAxis.getPixelLength() - 2.0f);
            graphics2D.setClip((Shape)((Object)serializable));
        }
        if (super.getGenerateImageMapFlag()) {
            serializable = new ImageMap(this.iDataSeries.getNumberOfXAxisLabels() * this.iDataSeries.getTotalNumberOfDataSets());
            super.setImageMap((ImageMap)serializable);
        }
        if ((serializable = this.iDataSeries.getIAxisPlotDataSet(ChartType.AREA_STACKED)) != null) {
            StackedAreaChart.render(this, (IAxisChartDataSet)serializable);
        }
        if ((serializable = this.iDataSeries.getIAxisPlotDataSet(ChartType.AREA)) != null) {
            AreaChart.render(this, (IAxisChartDataSet)serializable);
        }
        if ((serializable = this.iDataSeries.getIAxisPlotDataSet(ChartType.BAR)) != null) {
            BarChart.render(this, (IAxisChartDataSet)serializable);
        }
        if ((serializable = this.iDataSeries.getIAxisPlotDataSet(ChartType.BAR_STACKED)) != null) {
            StackedBarChart.render(this, (IAxisChartDataSet)serializable);
        }
        if ((serializable = this.iDataSeries.getIAxisPlotDataSet(ChartType.BAR_CLUSTERED)) != null) {
            ClusteredBarChart.render(this, (IAxisChartDataSet)serializable);
        }
        if ((serializable = this.iDataSeries.getIAxisPlotDataSet(ChartType.STOCK)) != null) {
            StockChart.render(this, (IStockChartDataSet)serializable);
        }
        if ((serializable = this.iDataSeries.getIAxisPlotDataSet(ChartType.LINE)) != null) {
            LineChart.render(this, (IAxisChartDataSet)serializable);
        }
        if ((serializable = this.iDataSeries.getIAxisPlotDataSet(ChartType.POINT)) != null) {
            PointChart.render(this, (IAxisChartDataSet)serializable);
        }
    }

    public AxisProperties getAxisProperties() {
        return this.axisProperties;
    }

    XAxis getXAxis() {
        return this.xAxis;
    }

    YAxis getYAxis() {
        return this.yAxis;
    }

    public void toHTML(HTMLGenerator hTMLGenerator, String string) {
        hTMLGenerator.chartTableStart(this.getClass().getName(), string);
        if (this.iDataSeries instanceof HTMLTestable) {
            ((HTMLTestable)((Object)this.iDataSeries)).toHTML(hTMLGenerator);
        }
        hTMLGenerator.chartTableRowStart();
        this.xAxis.toHTML(hTMLGenerator);
        hTMLGenerator.chartTableRowEnd();
        hTMLGenerator.chartTableRowStart();
        this.yAxis.toHTML(hTMLGenerator);
        hTMLGenerator.chartTableRowEnd();
        hTMLGenerator.chartTableRowStart();
        this.axisProperties.toHTML(hTMLGenerator);
        hTMLGenerator.chartTableRowEnd();
        hTMLGenerator.chartTableEnd();
    }
}

