/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ckm.samples;

import com.trs.ckm.soap.BatchCATField;
import com.trs.ckm.soap.BatchCATModel;
import com.trs.ckm.soap.CATModelInfo;
import com.trs.ckm.soap.CATRevDetail;
import com.trs.ckm.soap.RuleCATField;
import com.trs.ckm.soap.TrsCkmSoapClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CatTest {
    private TrsCkmSoapClient soapclient = null;
    private String modelname = null;

    public CatTest(TrsCkmSoapClient _client, String _name) {
        this.soapclient = _client;
        this.modelname = _name;
    }

    public void appendMethodB(String fileName, String content) {
        try {
            FileWriter writer = new FileWriter(fileName, true);
            writer.write(content);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String ParseXML(String filename) {
        String content = null;
        Document doc = null;
        try {
            List ele;
            File r = new File(filename);
            SAXReader reader = new SAXReader();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("CNML", "http://www.cnml.org.cn/2005/CNMLSchema");
            reader.getDocumentFactory().setXPathNamespaceURIs(map);
            doc = reader.read(r);
            if (doc != null && (ele = doc.selectNodes("//CNML:CNML/CNML:Items/CNML:Item/CNML:Contents/CNML:ContentItem/CNML:DataContent")) != null && ele.size() > 0) {
                Element e = (Element)ele.get(0);
                content = e.getTextTrim();
            }
        }
        catch (Exception e) {
            System.out.println("ParseXML Failed:" + e.getMessage());
        }
        return content;
    }

    public String getFileContent(String _sFilePath, String _sEncoding) throws Exception {
        FileInputStream fInputStream = null;
        InputStreamReader fInputStreamReader = null;
        BufferedReader fBufferedReader = null;
        String sContent = "";
        String sLine = null;
        fInputStream = new FileInputStream(new File(_sFilePath));
        fInputStreamReader = new InputStreamReader((InputStream)fInputStream, _sEncoding);
        fBufferedReader = new BufferedReader(fInputStreamReader);
        while ((sLine = fBufferedReader.readLine()) != null) {
            sContent = String.valueOf(sContent) + sLine + "\r\n";
        }
        fBufferedReader.close();
        fInputStreamReader.close();
        fInputStream.close();
        return sContent;
    }

    public int processDir(String path) throws Exception {
        CATRevDetail[] catRev;
        String result1;
        String content;
        int result = 0;
        if (path == null || path.equals("")) {
            return result;
        }
        LinkedList<File> list = new LinkedList<File>();
        File dir = new File(path);
        File[] file = dir.listFiles();
        int i = 0;
        while (i < file.length) {
            if (file[i].isDirectory()) {
                System.out.println("*****************");
                list.add(file[i]);
            } else {
                content = this.ParseXML(file[i].getAbsolutePath());
                result1 = "";
                result1 = file[i].getAbsolutePath();
                if (content != null && !content.equals("") && (catRev = this.soapclient.CATClassifyText(this.modelname, content)) != null) {
                    result1 = String.valueOf(result1) + "\t";
                    int j = 0;
                    while (j < catRev.length) {
                        result1 = String.valueOf(result1) + catRev[j].getCATName() + ";";
                        ++j;
                    }
                }
                result1 = String.valueOf(result1) + "\n";
                this.appendMethodB("G:\\result.txt", result1);
            }
            ++i;
        }
        while (!list.isEmpty()) {
            System.out.println("#########################");
            File tmp = (File)list.removeFirst();
            if (tmp.isDirectory()) {
                file = tmp.listFiles();
                if (file == null) continue;
                int i2 = 0;
                while (i2 < file.length) {
                    if (file[i2].isDirectory()) {
                        list.add(file[i2]);
                    } else {
                        CATRevDetail[] catRev2;
                        String content2 = this.ParseXML(file[i2].getAbsolutePath());
                        String result12 = "";
                        result12 = file[i2].getAbsolutePath();
                        if (content2 != null && (catRev2 = this.soapclient.CATClassifyText(this.modelname, content2)) != null) {
                            result12 = String.valueOf(result12) + "\t";
                            int j = 0;
                            while (j < catRev2.length) {
                                result12 = String.valueOf(result12) + catRev2[j].getCATName() + ";";
                                ++j;
                            }
                        }
                        this.appendMethodB("G:\\result.txt", result12);
                    }
                    ++i2;
                }
                continue;
            }
            content = this.ParseXML(tmp.getAbsolutePath());
            result1 = "";
            result1 = tmp.getAbsolutePath();
            if (content != null && (catRev = this.soapclient.CATClassifyText(this.modelname, content)) != null) {
                result1 = String.valueOf(result1) + "\t";
                int j = 0;
                while (j < catRev.length) {
                    result1 = String.valueOf(result1) + catRev[j].getCATName() + ";";
                    ++j;
                }
            }
            this.appendMethodB("G:\\result.txt", result1);
        }
        return result;
    }

    public void RuleCatTest(String sContent) throws Exception {
        RuleCATField[] _RuleFields;
        String sResult;
        if (sContent == null || sContent.equals("")) {
            return;
        }
        RuleCATField[] field = new RuleCATField[]{new RuleCATField(sContent, "\u6b63\u6587")};
        String result = this.soapclient.RuleCATClassifyText(this.modelname, field);
        if (result != null) {
            System.out.println(result);
        }
        if ((sResult = this.soapclient.RuleCATSenValue("\u6d4b\u8bd5", _RuleFields = new RuleCATField[]{new RuleCATField("nba\u5434\u5bb6\u79cb", "\u6807\u9898"), new RuleCATField("\u4e2d\u56fd\u59da\u660e\u5165\u9009\u7f8e\u56fdNAB\u4e94\u4f73\u7403", "\u6b63\u6587")})) != null) {
            System.out.println(sResult);
        }
    }

    public void AutocatTestCase() throws Exception {
        CATRevDetail[] _CatResult = this.soapclient.CATClassifyText(this.modelname, "\u4f53\u80b2");
        if (_CatResult != null) {
            int i = 0;
            while (i < _CatResult.length) {
                System.out.println("\u7f6e\u4fe1\u5ea6=" + _CatResult[i].getv() + ", \u7c7b\u540d=" + _CatResult[i].getCATName());
                ++i;
            }
        }
    }

    public void ModelCaseTest(String dirPath) throws Exception {
        if (dirPath == null || dirPath.equals("")) {
            return;
        }
        File file = new File(dirPath);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        int i = this.soapclient.RuleCATDownloadModel(this.modelname, 16, String.valueOf(dirPath) + "RuleModel");
        if (i < 0) {
            System.out.println("\u89c4\u5219\u6a21\u677f\u4e0b\u8f7d\u5931\u8d25");
        } else {
            System.out.println("\u89c4\u5219\u5206\u7c7b\u6a21\u677f\u4e0b\u8f7d\u6210\u529f");
        }
        i = this.soapclient.RuleCATUploadModel("test", 0, String.valueOf(dirPath) + "RuleModel");
        if (i == 0) {
            System.out.println("\u89c4\u5219\u5206\u7c7b\u6a21\u677f\u4e0a\u4f20\u6210\u529f");
            i = this.soapclient.RuleCATDropModel("test");
        } else {
            System.out.println("\u89c4\u5219\u5206\u7c7b\u6a21\u677f\u4e0a\u4f20\u5931\u8d25");
        }
        i = this.soapclient.CATDownloadModel(this.modelname, 256, String.valueOf(dirPath) + "AutoCatModel");
        if (i < 0) {
            System.out.println("\u81ea\u52a8\u6a21\u677f\u4e0b\u8f7d\u5931\u8d25");
        } else {
            System.out.println("\u81ea\u52a8\u5206\u7c7b\u6a21\u677f\u4e0b\u8f7d\u6210\u529f");
        }
        i = this.soapclient.CATUploadModel("test", 0, String.valueOf(dirPath) + "AutoCatModel");
        if (i == 0) {
            System.out.println("\u81ea\u52a8\u5206\u7c7b\u6a21\u677f\u4e0a\u4f20\u6210\u529f");
            i = this.soapclient.CATDropModel("test");
        } else {
            System.out.println("\u81ea\u52a8\u5206\u7c7b\u6a21\u677f\u4e0a\u4f20\u5931\u8d25");
        }
        CATModelInfo modinfo = this.soapclient.CATGetModelInfo(this.modelname, 256);
        System.out.println(String.valueOf(modinfo.getcreatedate()) + "\r\n" + modinfo.gettype() + "\r\n" + modinfo.getxmlcatinfo() + "\r\n" + modinfo.getxmlcatinfo().length());
    }

    public void BatchCatTest() throws Exception {
        BatchCATModel[] model = new BatchCATModel[]{new BatchCATModel()};
        model[0].setCATModelName("demo");
        model[0].setnType(65535);
        model[0].setRuleCATModelName("555");
        BatchCATField[] fields = new BatchCATField[]{new BatchCATField()};
        fields[0].setfield("\u6b63\u6587");
        fields[0].setword("\u4f53\u80b2WCM52");
        CATRevDetail[][] detail = this.soapclient.BatchCATClassifyText(fields, model);
        int i = 0;
        while (i < detail.length) {
            int j = 0;
            while (j < detail[i].length) {
                System.out.println(String.valueOf(detail[i][j].getCATName()) + " " + detail[i][j].getv());
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        TrsCkmSoapClient _client = new TrsCkmSoapClient("http://192.9.200.147:8000", "admin", "trsadmin");
        CatTest test = new CatTest(_client, "demo");
        test.RuleCatTest("\u4e2d\u56fd");
    }
}

