/*
 * Decompiled with CFR 0.152.
 */
package com.eprobiti.trs;

import com.eprobiti.trs.$VERSION;
import com.eprobiti.trs.RecordReport;
import com.eprobiti.trs.TRSBackGroupInfo;
import com.eprobiti.trs.TRSColProperty;
import com.eprobiti.trs.TRSDataBase;
import com.eprobiti.trs.TRSDataProperty;
import com.eprobiti.trs.TRSException;
import com.eprobiti.trs.TRSFormat;
import com.eprobiti.trs.TRSGroup;
import com.eprobiti.trs.TRSJNIV61;
import com.eprobiti.trs.TRSMetaData;
import com.eprobiti.trs.TRSResultSet;
import com.eprobiti.trs.TRSSystemInfo;
import com.eprobiti.trs.TRSUser;
import com.eprobiti.trs.TRSUtils;
import com.eprobiti.trs.TRSView;
import java.io.File;
import java.util.Vector;

public class TRSConnection {
    private static final String[] g_saSysConfig = new String[]{"DATAPATHSET", "TEMPPATH", "BACKUPDEVICE", "LANGUAGE", "KNOWASSNUM", "MAXLOGINTIME", "MINLOGINTIME", "IDLESTARTCLOCK", "IDLEOVERCLOCK", "MEMORYSIZE", "MAXHISTSTEPS", "MAXSEARCHTIME", "MAXSORTRECORD", "MAXDOWNLOAD", "INDEXSTEM", "CASESENSITIVE", "IGNOREDIGIT"};
    private static final String[] g_saKnowAsses = new String[]{"LANGUAGE", "SEGMENT", "STOP", "THESAURUS", "SYNONYM", "ANTONYM"};
    private static int m_iDebugLevel = 0;
    private static int m_iEnglish = TRSJNIV61.getDLLEnglsih();
    char m_cDivider = (char)255;
    volatile long m_hConnect = 0L;
    private volatile boolean m_bAbort = false;
    private long m_lMainProgress = 0L;
    private long m_lSubProgress = 0L;
    private long m_hHook = 0L;
    private int m_iLastResultID = 0;
    private RecordReport m_oLoadReport = null;
    private Vector m_vOpenedResultSet = new Vector();
    private String m_sServerHost = "";
    private String m_sServerPort = "";
    private String m_sServerUser = "";
    private Property[] m_oaSysConfig = null;
    private KnowAss[] m_oaKnowAsses = new KnowAss[4];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private synchronized void deleteLoadReport() {
        File _fFile = null;
        boolean _bWell = true;
        if (this.m_oLoadReport != null) {
            String _sFileName = this.m_oLoadReport.RecordIDFile;
            if (_sFileName != null && !_sFileName.equals("") && (_fFile = new File(_sFileName)).exists() && _fFile.isFile()) {
                _bWell = _fFile.delete();
            }
            if ((_sFileName = this.m_oLoadReport.WrongFile) != null && !_sFileName.equals("") && (_fFile = new File(_sFileName)).exists() && _fFile.isFile()) {
                _bWell = _fFile.delete();
            }
            this.m_oLoadReport = null;
            if (_bWell) {
                return;
            }
        }
    }

    long getHandle() throws TRSException {
        this.m_bAbort = false;
        this.m_lMainProgress = 0L;
        this.m_lSubProgress = 0L;
        if (this.m_hConnect == 0L) {
            throw TRSException.New(500002, "");
        }
        return this.m_hConnect;
    }

    TRSException newTRSException() throws TRSException {
        String _strErrMsg = TRSJNIV61.TRS_GetLastError(this.m_hConnect);
        if (_strErrMsg == null) {
            throw TRSException.New(500003, "");
        }
        int _iErrCode = 0;
        int _iIndex = _strErrMsg.indexOf(44);
        if (_iIndex > 0) {
            try {
                _iErrCode = Integer.parseInt(_strErrMsg.substring(0, _iIndex));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new TRSException(_iErrCode, _strErrMsg);
    }

    private synchronized void closeAllResultSets() {
        int i = 0;
        while (i < this.m_vOpenedResultSet.size()) {
            ((TRSResultSet)this.m_vOpenedResultSet.elementAt(i)).close_internal();
            ++i;
        }
        this.m_vOpenedResultSet.clear();
    }

    synchronized void addOpenedResultSet(TRSResultSet rs) {
        if (!this.m_vOpenedResultSet.contains(rs)) {
            this.m_vOpenedResultSet.add(rs);
        }
    }

    synchronized void removeOpenedResultSet(TRSResultSet rs) {
        if (this.m_vOpenedResultSet.contains(rs)) {
            this.m_vOpenedResultSet.remove(rs);
        }
    }

    public TRSConnection() throws TRSException {
        int _iErrCode = TRSJNIV61.getDLLErrorCode();
        switch (_iErrCode) {
            case 0: {
                break;
            }
            case 1: {
                TRSException.New(500004, TRSJNIV61.getDLLErrorString());
                break;
            }
            case 2: {
                TRSException.New(500005, TRSJNIV61.getDLLErrorString());
                break;
            }
            case 3: {
                TRSException.New(500006, "");
                break;
            }
            default: {
                TRSException.New(500007, "");
            }
        }
    }

    public static void main(String[] args) {
        $VERSION.JAR3300.BEAN3300.API4210 ver = new $VERSION.JAR3300.BEAN3300.API4210();
        String vs = ver.getClass().getName();
        vs = vs.substring(vs.indexOf(36));
        System.out.println(vs);
        TRSJNIV61.showHelp();
    }

    protected void finalize() throws Throwable {
        this.clean();
    }

    private synchronized void setCallBack() {
        if (this.m_hHook != 0L) {
            return;
        }
        this.m_hHook = TRSJNIV61.TRS_InstallHook(this.m_hConnect, this);
    }

    private synchronized void closeCallBack() {
        if (this.m_hHook == 0L) {
            return;
        }
        TRSJNIV61.TRS_RemoveHook(this.m_hConnect, this.m_hHook);
        this.m_hHook = 0L;
    }

    public synchronized void abort() {
        if (!this.m_bAbort) {
            this.m_bAbort = true;
        }
    }

    public long getMainProgress() {
        return this.m_lMainProgress;
    }

    public long getSubProgress() {
        return this.m_lSubProgress;
    }

    public boolean clean() {
        if (this.m_hConnect == 0L) {
            return true;
        }
        this.closeCallBack();
        this.closeAllResultSets();
        TRSJNIV61.TRS_Cleanup(this.m_hConnect);
        this.m_hConnect = 0L;
        this.m_bAbort = false;
        this.m_sServerUser = null;
        this.m_iLastResultID = 0;
        this.deleteLoadReport();
        return true;
    }

    public boolean close() {
        if (this.m_hConnect == 0L) {
            return true;
        }
        this.closeCallBack();
        this.closeAllResultSets();
        TRSJNIV61.TRS_Close(this.m_hConnect);
        this.m_hConnect = 0L;
        this.m_bAbort = false;
        this.m_sServerUser = null;
        this.m_iLastResultID = 0;
        this.deleteLoadReport();
        return true;
    }

    public boolean connect(String strServerHost, String strServerPort, String strUserName, String strPassWord) throws TRSException {
        return this.connect(strServerHost, strServerPort, strUserName, strPassWord, null);
    }

    public boolean connect(String strServerHost, String strServerPort, String strUserName, String strPassWord, String strWebRemote) throws TRSException {
        if (this.m_hConnect != 0L) {
            TRSJNIV61.TRS_Cleanup(this.getHandle());
        }
        this.m_hConnect = TRSJNIV61.TRS_Connect(strServerHost, strServerPort, strUserName, strPassWord, strWebRemote);
        if (this.m_hConnect == 0L) {
            throw this.newTRSException();
        }
        this.setCallBack();
        this.m_sServerUser = strUserName;
        this.m_sServerHost = strServerHost;
        this.m_sServerPort = strServerPort;
        return true;
    }

    public boolean reconnect(String strServerHost, String strServerPort, String strLicenceCode) throws TRSException {
        return this.reconnect(strServerHost, strServerPort, null, strLicenceCode);
    }

    public boolean reconnect(String strServerHost, String strServerPort, String strWebRemote, String strLicenceCode) throws TRSException {
        int _iPos;
        if (this.m_hConnect != 0L) {
            TRSJNIV61.TRS_Cleanup(this.getHandle());
        }
        this.m_hConnect = TRSJNIV61.TRS_Reconnect(strServerHost, strServerPort, null, null, strWebRemote, strLicenceCode);
        if (this.m_hConnect == 0L) {
            throw this.newTRSException();
        }
        this.setCallBack();
        if (strLicenceCode != null && (_iPos = strLicenceCode.lastIndexOf(".")) != -1) {
            this.m_iLastResultID = Integer.parseInt(strLicenceCode.substring(_iPos + 1));
        }
        return true;
    }

    public boolean reset(int iResetFlag) {
        return this.m_hConnect != 0L;
    }

    public boolean isClosed() {
        return this.m_hConnect == 0L;
    }

    public static int getCharset(boolean bDefault) {
        return TRSJNIV61.TRS_GetCharset(bDefault);
    }

    public String getCurrUser() {
        return this.m_sServerUser;
    }

    public String getServerHost() throws TRSException {
        return this.m_sServerHost;
    }

    public String getServerPort() throws TRSException {
        return this.m_sServerPort;
    }

    public void getConfig() throws TRSException {
        String _strConfigProperties = TRSJNIV61.TRS_GetConfig(this.getHandle());
        if (_strConfigProperties == null || _strConfigProperties.equals("")) {
            throw this.newTRSException();
        }
        String[] _saKnowAssProperties = TRSJNIV61.TRS_GetKnowAss(this.getHandle());
        if (_saKnowAssProperties == null) {
            throw this.newTRSException();
        }
        this.m_oaSysConfig = new Property[g_saSysConfig.length];
        int i = 0;
        while (i < g_saSysConfig.length) {
            this.m_oaSysConfig[i] = new Property(g_saSysConfig[i], "", null);
            ++i;
        }
        String[] _saPropertySplits = TRSUtils.split(_strConfigProperties, "\u0001");
        if (_saPropertySplits == null) {
            throw TRSException.New(500009, _strConfigProperties);
        }
        int i2 = 0;
        while (i2 < _saPropertySplits.length) {
            String _strName = "";
            String _strValue = "";
            int _iEnd = _saPropertySplits[i2].indexOf("=");
            if (_iEnd != -1) {
                _strName = _saPropertySplits[i2].substring(0, _iEnd);
                _strValue = _saPropertySplits[i2].substring(_iEnd + 1);
                int j = 0;
                while (j < this.m_oaSysConfig.length) {
                    if (_strName.equalsIgnoreCase(this.m_oaSysConfig[j].strName)) {
                        this.m_oaSysConfig[j].strValue = _strValue;
                        break;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < 4) {
            this.m_oaKnowAsses[i2] = new KnowAss();
            this.m_oaKnowAsses[i2].iLanguage = 96 + i2;
            this.m_oaKnowAsses[i2].oaKnowAsses = new Property[g_saKnowAsses.length];
            int j = 0;
            while (j < g_saKnowAsses.length) {
                this.m_oaKnowAsses[i2].oaKnowAsses[j] = new Property(g_saKnowAsses[j], "", null);
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < _saKnowAssProperties.length) {
            _saPropertySplits = TRSUtils.split(_saKnowAssProperties[i2], "\u0001");
            if (_saPropertySplits == null) {
                throw TRSException.New(500009, _saKnowAssProperties[i2]);
            }
            int _iKnowLang = 0;
            int j = 0;
            while (j < _saPropertySplits.length) {
                String[] _strKnowLang = TRSUtils.split(_saPropertySplits[j], "=");
                if (_strKnowLang != null && _strKnowLang.length == 2 && _strKnowLang[0].equalsIgnoreCase("LANGUAGE")) {
                    _iKnowLang = Integer.parseInt(_strKnowLang[1]);
                    break;
                }
                ++j;
            }
            int k = 0;
            while (k < _saPropertySplits.length) {
                String[] _sKnowValues = TRSUtils.split(_saPropertySplits[k], "=");
                if (_sKnowValues == null) {
                    throw TRSException.New(500009, _saPropertySplits[k]);
                }
                if (_iKnowLang < 96 || _iKnowLang > 99) {
                    throw TRSException.New(500008, "");
                }
                int m = 0;
                while (m < this.m_oaKnowAsses[_iKnowLang - 96].oaKnowAsses.length) {
                    if (_sKnowValues[0].equalsIgnoreCase(this.m_oaKnowAsses[_iKnowLang - 96].oaKnowAsses[m].strName) && _sKnowValues.length == 2) {
                        this.m_oaKnowAsses[_iKnowLang - 96].oaKnowAsses[m].strValue = _sKnowValues[1];
                        break;
                    }
                    ++m;
                }
                ++k;
            }
            ++i2;
        }
    }

    public String getStrConfig(String strName) throws TRSException {
        if (strName == null || strName.equals("")) {
            throw TRSException.New(500010, "");
        }
        int i = 0;
        while (i < this.m_oaSysConfig.length) {
            if (strName.equalsIgnoreCase(this.m_oaSysConfig[i].strName)) {
                return this.m_oaSysConfig[i].strValue;
            }
            ++i;
        }
        throw TRSException.New(500012, strName);
    }

    public int getIntConfig(String strName) throws TRSException {
        try {
            String _strResult = this.getStrConfig(strName);
            return Integer.parseInt(_strResult);
        }
        catch (TRSException e) {
            throw e;
        }
        catch (NumberFormatException e) {
            throw TRSException.New(500011, "NOT INT," + strName);
        }
    }

    public boolean getBoolConfig(String strName) throws TRSException {
        try {
            String _strResult = this.getStrConfig(strName);
            return _strResult.equalsIgnoreCase("TRUE") || _strResult.equals("1");
        }
        catch (TRSException e) {
            throw e;
        }
        catch (NumberFormatException e) {
            throw TRSException.New(500011, "NOT BOOLEAN," + strName);
        }
    }

    public String getKnowAss(int iLanguage, String strKnowType) throws TRSException {
        if (iLanguage == 0) {
            iLanguage = this.getIntConfig("LANGUAGE");
        }
        if (iLanguage < 96 || iLanguage > 99) {
            throw TRSException.New(500008, String.valueOf(iLanguage));
        }
        int i = 0;
        while (i < this.m_oaKnowAsses[iLanguage - 96].oaKnowAsses.length) {
            if (strKnowType.equalsIgnoreCase(this.m_oaKnowAsses[iLanguage - 96].oaKnowAsses[i].strName)) {
                return this.m_oaKnowAsses[iLanguage - 96].oaKnowAsses[i].strValue;
            }
            ++i;
        }
        throw TRSException.New(500013, strKnowType);
    }

    public String getLicenceCode() throws TRSException {
        String _strLicenceCode = TRSJNIV61.TRS_GetLicenceCode(this.getHandle());
        if (_strLicenceCode == null) {
            throw this.newTRSException();
        }
        return _strLicenceCode;
    }

    public TRSColProperty getStatCol(String strDBName, int iColumn) throws TRSException {
        String _strCol = "@" + String.valueOf(iColumn);
        return this.getStatCol(strDBName, _strCol);
    }

    public TRSColProperty getStatCol(String strDBName, String strColumnName) throws TRSException {
        String _strStatColProperties = TRSJNIV61.TRS_Admin_StatCol(this.getHandle(), strDBName, strColumnName);
        if (_strStatColProperties == null) {
            throw this.newTRSException();
        }
        String[] _saPropertySplits = TRSUtils.split(_strStatColProperties, "\u0001");
        if (_saPropertySplits == null) {
            throw TRSException.New(500009, _strStatColProperties);
        }
        TRSColProperty _oColStat = new TRSColProperty();
        _oColStat.IndexMinus = TRSUtils.getIntPropertValue(_saPropertySplits, "INDEXMINUS");
        _oColStat.IndexSize = TRSUtils.getIntPropertValue(_saPropertySplits, "INDEXSIZE");
        _oColStat.strIndexPath = TRSUtils.getStrPropertValue(_saPropertySplits, "INDEXPATH");
        _oColStat.strColumn = TRSUtils.getStrPropertValue(_saPropertySplits, "COLUMN");
        return _oColStat;
    }

    public TRSDataProperty getStatDatabase(String strDBName) throws TRSException {
        String _strStatBaseProperties = TRSJNIV61.TRS_Admin_StatDatabase(this.getHandle(), strDBName);
        if (_strStatBaseProperties == null) {
            throw this.newTRSException();
        }
        String[] _saPropertySplits = TRSUtils.split(_strStatBaseProperties, "\u0001");
        if (_saPropertySplits == null) {
            throw TRSException.New(500009, _strStatBaseProperties);
        }
        TRSDataProperty _oBaseStat = new TRSDataProperty();
        _oBaseStat.strDataPath = TRSUtils.getStrPropertValue(_saPropertySplits, "DATAPATH");
        _oBaseStat.TotalSize = TRSUtils.getIntPropertValue(_saPropertySplits, "TOTALSIZE");
        _oBaseStat.DataSize = TRSUtils.getIntPropertValue(_saPropertySplits, "DATASIZE");
        _oBaseStat.IndexSize = TRSUtils.getIntPropertValue(_saPropertySplits, "INDEXSIZE");
        _oBaseStat.TotalMinus = TRSUtils.getIntPropertValue(_saPropertySplits, "TOTALMINUS");
        _oBaseStat.DataMinus = TRSUtils.getIntPropertValue(_saPropertySplits, "DATAMINUS");
        _oBaseStat.IndexMinus = TRSUtils.getIntPropertValue(_saPropertySplits, "INDEXMINUS");
        _oBaseStat.ColumnNum = TRSUtils.getIntPropertValue(_saPropertySplits, "COLUMNNUM");
        return _oBaseStat;
    }

    public String getVersion(String strPart) throws TRSException {
        if (strPart.equalsIgnoreCase("JNIID")) {
            return String.valueOf(TRSJNIV61.TRS_GetJNIVersion());
        }
        if (strPart.equalsIgnoreCase("Bean")) {
            return String.valueOf(TRSJNIV61.getBeanVersion());
        }
        if (strPart.equalsIgnoreCase("Full")) {
            String _strFullVersion = TRSJNIV61.TRS_GetFullVersion(this.getHandle());
            if (_strFullVersion == null) {
                throw this.newTRSException();
            }
            return _strFullVersion;
        }
        return null;
    }

    public void initConfig() {
        int i;
        if (this.m_oaSysConfig == null) {
            this.m_oaSysConfig = new Property[g_saSysConfig.length];
            i = 0;
            while (i < g_saSysConfig.length) {
                this.m_oaSysConfig[i] = new Property(g_saSysConfig[i], "", null);
                ++i;
            }
        }
        i = 0;
        while (i < this.m_oaSysConfig.length) {
            this.m_oaSysConfig[i].strUpdate = null;
            ++i;
        }
        i = 0;
        while (i < 4) {
            int j;
            this.m_oaKnowAsses[i] = new KnowAss();
            if (this.m_oaKnowAsses[i].oaKnowAsses == null) {
                this.m_oaKnowAsses[i].iLanguage = 96 + i;
                this.m_oaKnowAsses[i].oaKnowAsses = new Property[g_saKnowAsses.length];
                j = 0;
                while (j < g_saKnowAsses.length) {
                    this.m_oaKnowAsses[i].oaKnowAsses[j] = new Property(g_saKnowAsses[j], "", null);
                    ++j;
                }
            }
            j = 0;
            while (j < this.m_oaKnowAsses[i].oaKnowAsses.length) {
                this.m_oaKnowAsses[i].oaKnowAsses[j].strUpdate = null;
                ++j;
            }
            ++i;
        }
    }

    public boolean isAccess() {
        return this.m_hConnect != 0L;
    }

    public static boolean isDebug() {
        return m_iDebugLevel > 0;
    }

    public boolean isValid() {
        return TRSJNIV61.TRS_TestLicenceCode(this.m_hConnect);
    }

    public boolean JudgeAccessServer() {
        return this.m_hConnect != 0L;
    }

    public boolean JudgeConnection() {
        return this.m_hConnect != 0L;
    }

    public String[] keys() {
        String[] _saKeys = new String[g_saSysConfig.length];
        int i = 0;
        while (i < _saKeys.length) {
            _saKeys[i] = g_saSysConfig[i];
            ++i;
        }
        return _saKeys;
    }

    public String[] list() {
        if (this.m_oaSysConfig == null) {
            return null;
        }
        String[] _saList = new String[this.m_oaSysConfig.length];
        int i = 0;
        while (i < _saList.length) {
            _saList[i] = String.valueOf(this.m_oaSysConfig[i].strName) + "=" + this.m_oaSysConfig[i].strValue;
            ++i;
        }
        return _saList;
    }

    public void setAutoExtend(String strThesaurus, String strSynonym, String strAntonym, int iOptionMask) throws TRSException {
        int _ret = TRSJNIV61.TRS_SetAutoExtend(this.getHandle(), strThesaurus, strSynonym, strAntonym, iOptionMask);
        if (_ret < 0) {
            throw this.newTRSException();
        }
    }

    public void SetExtendOption(String strOptionName, String strOptionValue) throws TRSException {
        this.setConnectProperty(strOptionName, strOptionValue);
    }

    public int setConnectProperty(String sPropName, String sPropValue) throws TRSException {
        int iResult = TRSJNIV61.TRS_SetConnectOption(this.getHandle(), sPropName, sPropValue);
        if (iResult < 0) {
            throw this.newTRSException();
        }
        return iResult;
    }

    public boolean setBoolConfig(String strName, boolean bValue) throws TRSException {
        String _strValue = bValue ? "1" : "0";
        return this.setStrConfig(strName, _strValue);
    }

    public void setBufferPath(String strTempPath) {
        TRSJNIV61.TRS_SetTempPath(this.m_hConnect, strTempPath);
    }

    public static boolean setCharset(int iCharset, boolean bShareMode) {
        if (m_iEnglish >= 1) {
            iCharset |= 0x20;
            TRSJNIV61.setDLLEnglish(m_iEnglish);
        }
        return TRSJNIV61.TRS_SetCharset(iCharset, false);
    }

    public void setConfig() throws TRSException {
        String _strConfigProperties = "";
        if (this.m_oaSysConfig == null) {
            return;
        }
        int i = 0;
        while (i < this.m_oaSysConfig.length) {
            if (this.m_oaSysConfig[i].strUpdate != null) {
                _strConfigProperties = String.valueOf(_strConfigProperties) + this.m_oaSysConfig[i].strName + "=" + this.m_oaSysConfig[i].strUpdate + "\u0001";
            }
            ++i;
        }
        String[] _saKnowAssProperties = new String[4];
        int i2 = 0;
        while (i2 < 4) {
            _saKnowAssProperties[i2] = "LANGUAGE=" + this.m_oaKnowAsses[i2].iLanguage + "\u0001";
            if (this.m_oaKnowAsses[i2].oaKnowAsses != null) {
                int j = 1;
                while (j < this.m_oaKnowAsses[i2].oaKnowAsses.length) {
                    if (this.m_oaKnowAsses[i2].oaKnowAsses[j].strUpdate != null) {
                        int n = i2;
                        _saKnowAssProperties[n] = String.valueOf(_saKnowAssProperties[n]) + this.m_oaKnowAsses[i2].oaKnowAsses[j].strName + "=" + this.m_oaKnowAsses[i2].oaKnowAsses[j].strUpdate + "\u0001";
                    }
                    ++j;
                }
            }
            ++i2;
        }
        int _ret = TRSJNIV61.TRS_SetConfig(this.getHandle(), _strConfigProperties, _saKnowAssProperties);
        if (_ret < 0) {
            throw this.newTRSException();
        }
    }

    public void setControlFile(String strControlFilePath) {
        TRSJNIV61.TRS_SetControlFile(this.m_hConnect, strControlFilePath);
    }

    public static void setDebug(boolean bIsDebug) {
        m_iDebugLevel = bIsDebug ? 1 : 0;
    }

    public boolean setIntConfig(String strName, int iValue) throws TRSException {
        return this.setStrConfig(strName, String.valueOf(iValue));
    }

    public boolean setKnowAss(int iLanguage, String strKnowType, String strName) throws TRSException {
        if (iLanguage == 0) {
            iLanguage = this.getIntConfig("LANGUAGE");
        }
        if (iLanguage < 96 || iLanguage > 99) {
            throw TRSException.New(500008, String.valueOf(iLanguage));
        }
        int _iIndex = iLanguage - 96;
        if (this.m_oaKnowAsses[_iIndex].oaKnowAsses == null) {
            return false;
        }
        int i = 0;
        while (i < this.m_oaKnowAsses[_iIndex].oaKnowAsses.length) {
            if (strKnowType.equalsIgnoreCase(this.m_oaKnowAsses[_iIndex].oaKnowAsses[i].strName)) {
                this.m_oaKnowAsses[_iIndex].oaKnowAsses[i].strUpdate = strName;
                return true;
            }
            ++i;
        }
        throw TRSException.New(500013, strKnowType);
    }

    public void setMaintOptions(char cColumnSep, String strMultiSep, String strUserGroup, int iSecurityCode, int iOutRecordID) throws TRSException {
        boolean _bOutRecordID = iOutRecordID > 0;
        int _ret = TRSJNIV61.TRS_SetMaintOptions(this.getHandle(), cColumnSep, strMultiSep, strUserGroup, iSecurityCode, _bOutRecordID);
        if (_ret < 0) {
            throw this.newTRSException();
        }
        if (cColumnSep != '\u0000') {
            this.m_cDivider = cColumnSep;
        }
    }

    public boolean setStrConfig(String strName, String strValue) throws TRSException {
        if (this.m_oaSysConfig == null) {
            return false;
        }
        int i = 0;
        while (i < this.m_oaSysConfig.length) {
            if (strName.equalsIgnoreCase(this.m_oaSysConfig[i].strName)) {
                this.m_oaSysConfig[i].strUpdate = strValue;
                return true;
            }
            ++i;
        }
        throw TRSException.New(500012, strName);
    }

    public TRSResultSet executeSelect(String strSources, String strWhere, boolean bContinue) throws TRSException {
        return this.executeSelect(strSources, strWhere, "RELEVANCE", "", null, 0, 115, bContinue);
    }

    public TRSResultSet executeSelect(String strSources, String strWhere, String strSortMethod, boolean bContinue) throws TRSException {
        return this.executeSelect(strSources, strWhere, strSortMethod, "", null, 0, 115, bContinue);
    }

    public TRSResultSet executeSelect(String strSources, String strWhere, String strSortMethod, String strStat, String strDefautCols, int iOption, int iHitPointType, boolean bContinue) throws TRSException {
        String _strCurWhere = strWhere != null ? strWhere.trim() : "";
        String _strLastWhere = "@" + String.valueOf(this.m_iLastResultID);
        if (bContinue && this.m_iLastResultID != 0) {
            _strCurWhere = _strCurWhere.length() == 0 ? _strLastWhere : String.valueOf(_strLastWhere) + " AND (" + _strCurWhere + ")";
        }
        TRSResultSet _oRs = new TRSResultSet(this);
        _oRs.executeSelect(strSources, _strCurWhere, strSortMethod, strStat, strDefautCols, iOption, iHitPointType, false);
        this.m_iLastResultID = _oRs.getResultID();
        return _oRs;
    }

    public TRSResultSet executeSelectQuick(String strSources, String strWhere, String strSortMethod, String strDefautCols, long lEstimateUnit, long lEstimateStops, int iOption, int iHitPointType) throws TRSException {
        this.SetExtendOption("ESTIMATEUNIT", String.valueOf(lEstimateUnit));
        this.SetExtendOption("ESTIMATESTOPS", String.valueOf(lEstimateStops));
        TRSResultSet _oRs = new TRSResultSet(this);
        _oRs.executeSelect(strSources, strWhere, strSortMethod, "", strDefautCols, iOption, iHitPointType, false);
        this.m_iLastResultID = _oRs.getResultID();
        return _oRs;
    }

    public TRSResultSet executeSelectWord(String strName, String strOwner, String strExpr) throws TRSException {
        TRSResultSet _oRs = new TRSResultSet(this);
        _oRs.executeSelectWord(strName, strOwner, strExpr);
        return _oRs;
    }

    public TRSResultSet executeSelectWord(String strName, String strOwner, String strExpr, String strSortMethod, int iPruneLimit) throws TRSException {
        TRSResultSet _oRs = new TRSResultSet(this);
        _oRs.executeSelectWord(strName, strOwner, strExpr, strSortMethod, iPruneLimit);
        return _oRs;
    }

    public RecordReport loadRecords(String strName, String strOwner, String strSrcFileName, String strCtrlFileName, boolean bBatchMode) throws TRSException {
        if (this.m_oLoadReport != null) {
            this.deleteLoadReport();
        }
        this.m_oLoadReport = new RecordReport();
        int _ret = TRSJNIV61.TRS_Admin_LoadRecords(this.getHandle(), strName, strOwner, strSrcFileName, strCtrlFileName, bBatchMode, null, this.m_oLoadReport);
        if (_ret < 0) {
            throw this.newTRSException();
        }
        return this.m_oLoadReport;
    }

    public RecordReport copyRecords(String strDestName, String strDestOwner, String strSrcName, String strSrcOwner, String strColumns, String strWhereExpr, String strSortMethod, boolean bSyncIndex) throws TRSException {
        if (this.m_oLoadReport != null) {
            this.deleteLoadReport();
        }
        this.m_oLoadReport = new RecordReport();
        int _ret = TRSJNIV61.TRS_Admin_CopyRecords(this.getHandle(), strDestName, strDestOwner, strSrcName, strSrcOwner, strColumns, strWhereExpr, strSortMethod, bSyncIndex, null, this.m_oLoadReport);
        if (_ret < 0) {
            throw this.newTRSException();
        }
        return this.m_oLoadReport;
    }

    public int backup(String strObjects, String strDevice) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_BackupDatabase(this.getHandle(), strObjects, strDevice);
        if (_ret < 0) {
            throw this.newTRSException();
        }
        return _ret;
    }

    public int backupDatabases(String strDatabases, String strDevice) throws TRSException {
        return this.backup(strDatabases, strDevice);
    }

    public int executeDelete(String strName, String strOwner, String strWhere, boolean bFastEnable) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_DeleteRecord(this.getHandle(), strName, strOwner, strWhere, bFastEnable);
        if (_ret < 0) {
            throw this.newTRSException();
        }
        return _ret;
    }

    public int executeInsert(String strName, String strOwner, String strValues) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_InsertRecord(this.getHandle(), strName, strOwner, strValues, this.m_cDivider);
        if (_ret <= 0) {
            throw this.newTRSException();
        }
        return _ret;
    }

    public int executeUpdate(String strName, String strOwner, String strValues, String strWhere) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_UpdateRecord(this.getHandle(), strName, strOwner, strValues, strWhere, this.m_cDivider);
        if (_ret < 0) {
            throw this.newTRSException();
        }
        return _ret;
    }

    public String executeExtendFunc(String strCommand, boolean bWaitResult) throws TRSException {
        String _ret = TRSJNIV61.TRS_Admin_ExtendFunc(this.getHandle(), strCommand, bWaitResult);
        if (_ret == null) {
            throw this.newTRSException();
        }
        return _ret;
    }

    public int recover(String strObjects, String strDevice, String strDirectory) throws TRSException {
        int _ret = TRSJNIV61.TRS_Admin_RecoverDatabase(this.getHandle(), strObjects, strDevice, strDirectory, false);
        if (_ret < 0) {
            throw this.newTRSException();
        }
        return _ret;
    }

    public int recoverDatabases(String strDatabases, String strDevice, String strDirectory) throws TRSException {
        return this.recover(strDatabases, strDevice, strDirectory);
    }

    public TRSDataBase[] getDataBases(String strNames) throws TRSException {
        return this.getDataBases(strNames, 1, 0);
    }

    public TRSDataBase[] getDataBases(String strNames, int iRightCode) throws TRSException {
        return this.getDataBases(strNames, 1, iRightCode);
    }

    public TRSDataBase[] getDataBases(String strNames, int iBaseType, int iRightCode) throws TRSException {
        String[] _saBaseProperties;
        if (strNames == null || strNames.equals("")) {
            strNames = "*.*";
        }
        if ((_saBaseProperties = TRSJNIV61.TRS_GetObjectList(this.getHandle(), 18, iBaseType, strNames, null, iRightCode)) == null) {
            throw this.newTRSException();
        }
        int _iBaseCount = _saBaseProperties.length;
        TRSDataBase[] _oaBases = new TRSDataBase[_iBaseCount];
        int i = 0;
        while (i < _iBaseCount) {
            _oaBases[i] = new TRSDataBase(_saBaseProperties[i], this);
            ++i;
        }
        return _oaBases;
    }

    public TRSFormat[] getFormats(String strNames) throws TRSException {
        String[] _saFormatProperties;
        if (strNames == null || strNames.equals("")) {
            strNames = "*";
        }
        if ((_saFormatProperties = TRSJNIV61.TRS_GetObjectList(this.getHandle(), 22, 0, strNames, null, 0)) == null) {
            throw this.newTRSException();
        }
        int _iFormatCount = _saFormatProperties.length;
        TRSFormat[] _oaFormats = new TRSFormat[_iFormatCount];
        int i = 0;
        while (i < _iFormatCount) {
            _oaFormats[i] = new TRSFormat(_saFormatProperties[i], this);
            ++i;
        }
        return _oaFormats;
    }

    public TRSGroup[] getGroups(String strNames) throws TRSException {
        String[] _saGroupProperties;
        if (strNames == null || strNames.equals("")) {
            strNames = "*";
        }
        if ((_saGroupProperties = TRSJNIV61.TRS_GetObjectList(this.getHandle(), 16, 0, strNames, null, 0)) == null) {
            throw this.newTRSException();
        }
        int _iGroupCount = _saGroupProperties.length;
        TRSGroup[] _oaGroups = new TRSGroup[_iGroupCount];
        int i = 0;
        while (i < _iGroupCount) {
            _oaGroups[i] = new TRSGroup(_saGroupProperties[i], this);
            ++i;
        }
        return _oaGroups;
    }

    public TRSView[] getViews(String strNames) throws TRSException {
        return this.getViews(strNames, 0);
    }

    public TRSView[] getViews(String strNames, int iRightCode) throws TRSException {
        String[] _saViewProperties;
        if (strNames == null || strNames.equals("")) {
            strNames = "*.*";
        }
        if ((_saViewProperties = TRSJNIV61.TRS_GetObjectList(this.getHandle(), 20, 0, strNames, null, iRightCode)) == null) {
            throw this.newTRSException();
        }
        int _iViewCount = _saViewProperties.length;
        TRSView[] _oaViews = new TRSView[_iViewCount];
        int i = 0;
        while (i < _iViewCount) {
            _oaViews[i] = new TRSView(_saViewProperties[i], this);
            ++i;
        }
        return _oaViews;
    }

    public TRSView[] getViews(String strNames, int iViewType, int iRightCode) throws TRSException {
        String[] _saViewProperties;
        if (strNames == null || strNames.equals("")) {
            strNames = "*.*";
        }
        if ((_saViewProperties = TRSJNIV61.TRS_GetObjectList(this.getHandle(), 20, iViewType, strNames, null, iRightCode)) == null) {
            throw this.newTRSException();
        }
        int _iViewCount = _saViewProperties.length;
        TRSView[] _oaViews = new TRSView[_iViewCount];
        int i = 0;
        while (i < _iViewCount) {
            _oaViews[i] = new TRSView(_saViewProperties[i], this);
            ++i;
        }
        return _oaViews;
    }

    public TRSUser[] getUsers(String strNames, int iUserType) throws TRSException {
        String[] _saUserProperties;
        if (strNames == null || strNames.equals("")) {
            strNames = "*.*";
        }
        if ((_saUserProperties = TRSJNIV61.TRS_GetObjectList(this.getHandle(), 17, iUserType, strNames, null, 0)) == null) {
            throw this.newTRSException();
        }
        int _iUserCount = _saUserProperties.length;
        TRSUser[] _oaUsers = new TRSUser[_iUserCount];
        int i = 0;
        while (i < _iUserCount) {
            _oaUsers[i] = new TRSUser(_saUserProperties[i], this);
            ++i;
        }
        return _oaUsers;
    }

    public TRSSystemInfo[] getSystemInfos(int iLevelOption) throws TRSException {
        TRSSystemInfo[] _oaSysInfo;
        long l = this.getHandle();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.eprobiti.trs.TRSSystemInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((_oaSysInfo = (TRSSystemInfo[])TRSJNIV61.TRS_GetSystemInfo(l, iLevelOption, clazz)) == null) {
            throw this.newTRSException();
        }
        return _oaSysInfo;
    }

    public TRSBackGroupInfo[] getBackInfos(String sGroupNames, int iGroupID) throws TRSException {
        TRSBackGroupInfo[] _oaGroupInfo;
        long l = this.getHandle();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.eprobiti.trs.TRSBackGroupInfo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((_oaGroupInfo = (TRSBackGroupInfo[])TRSJNIV61.TRS_GetBackInfo(l, sGroupNames, iGroupID, clazz)) == null) {
            throw this.newTRSException();
        }
        return _oaGroupInfo;
    }

    public String[] getSegmentWords(String sText, boolean bBanStopDic, boolean bRedundMode, int iOption) throws TRSException {
        String[] _oaResult = TRSJNIV61.getSegmentWords(this.getHandle(), sText, bBanStopDic, bRedundMode, iOption);
        if (_oaResult == null) {
            throw this.newTRSException();
        }
        return _oaResult;
    }

    public TRSMetaData getMetaData() throws TRSException {
        return new TRSMetaData(this);
    }

    public static void setLang(int lang) {
        int charset = TRSConnection.getCharset(false);
        m_iEnglish = lang > 0 ? 1 : 0;
        TRSConnection.setCharset(charset, false);
    }

    public String getLastError() {
        int _iIndex;
        String _strErrMsg = TRSJNIV61.TRS_GetLastError(this.m_hConnect);
        if (_strErrMsg != null && (_iIndex = _strErrMsg.indexOf(44)) > 0) {
            return _strErrMsg.substring(_iIndex + 1);
        }
        return _strErrMsg;
    }

    public long executePickRecord(String strSources, String strOwner, String strWhere, String strSortMethod, int StartRank, int LimitNum) throws TRSException {
        strWhere = strWhere != null ? strWhere.trim() : "";
        long iResult = TRSJNIV61.TRS_ExecutePickRecord(this.getHandle(), strSources, strOwner, strWhere, strSortMethod, StartRank, LimitNum, this);
        return iResult;
    }

    public TRSResultSet executePick(String strName, String strOwner, String strWhereExpr, String strSortMethod, int StartRank, int LimitNum) throws TRSException {
        strWhereExpr = strWhereExpr != null ? strWhereExpr.trim() : "";
        TRSResultSet rs = new TRSResultSet(this);
        rs.executePick(strName, strOwner, strWhereExpr, strSortMethod, StartRank, LimitNum);
        return rs;
    }

    private static final class KnowAss {
        int iLanguage;
        Property[] oaKnowAsses;

        private KnowAss() {
        }
    }

    private static final class Property {
        String strName;
        String strValue;
        String strUpdate;

        Property(String _name, String _value, String _update) {
            this.strName = _name;
            this.strValue = _value;
            this.strUpdate = _update;
        }
    }
}

