/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.discover.impl;

import com.trs.infra.discover.IType;
import com.trs.infra.discover.impl.IteratorEmpty;
import com.trs.infra.discover.impl.IteratorProxy;
import com.trs.infra.discover.impl.NodeResource;
import com.trs.infra.discover.impl.Utils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import trs.org.objectweb.asm.Opcodes;
import trs.org.objectweb.asm.tree.ClassNode;

public class NodeType
extends NodeResource
implements IType,
Opcodes {
    private int m_iAccessFlags;
    private int m_iTypeVersion;
    private String m_sQFName;
    private String m_sQFSuperName;
    private List m_sQFInterfaces;
    private List m_oSubTypes;
    private List m_oImplementors;
    private List m_oCollisions;

    public NodeType(String name, URL url, ClassNode cn) {
        super(name, url);
        this.init(cn);
    }

    private void init(ClassNode cn) {
        this.m_iAccessFlags = cn.access;
        this.m_iTypeVersion = cn.version;
        this.m_sQFName = cn.name.replace('/', '.');
        this.m_sQFSuperName = cn.superName.replace('/', '.');
        List src = cn.interfaces;
        if (src != null && src.size() > 0) {
            ArrayList<String> dst = new ArrayList<String>(src.size());
            int i = 0;
            while (i < src.size()) {
                dst.add(((String)src.get(i)).replace('/', '.').intern());
                ++i;
            }
            this.m_sQFInterfaces = dst;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(",QFName=").append(this.m_sQFName);
        return sb.toString();
    }

    public void cleanup() {
        super.cleanup();
        this.m_sQFName = null;
        this.m_sQFSuperName = null;
        if (this.m_sQFInterfaces != null) {
            this.m_sQFInterfaces.clear();
            this.m_sQFInterfaces = null;
        }
        if (this.m_oSubTypes != null) {
            this.m_oSubTypes.clear();
            this.m_oSubTypes = null;
        }
        if (this.m_oImplementors != null) {
            this.m_oImplementors.clear();
            this.m_oImplementors = null;
        }
        if (this.m_oCollisions != null) {
            this.m_oCollisions.clear();
            this.m_oCollisions = null;
        }
    }

    protected void trimMemory() {
        super.trimMemory();
        this.m_sQFName = this.m_sQFName.intern();
        if (this.m_sQFSuperName != null) {
            this.m_sQFSuperName = this.m_sQFSuperName.intern();
        }
        Utils.trimArrayList(this.m_sQFInterfaces);
        Utils.trimArrayList(this.m_oSubTypes);
        Utils.trimArrayList(this.m_oImplementors);
        Utils.trimArrayList(this.m_oCollisions);
    }

    public boolean isJavaType() {
        return true;
    }

    public String getQFName() {
        return this.m_sQFName;
    }

    public String getQFSuperName() {
        return this.m_sQFSuperName;
    }

    public Iterator getQFInterfaces() {
        List list = this.m_sQFInterfaces;
        if (list == null || list.size() <= 0) {
            return IteratorEmpty.getEmptyIterator();
        }
        return new IteratorProxy(list.iterator());
    }

    public int getVersion() {
        return this.m_iTypeVersion;
    }

    public boolean isPublic() {
        return (this.m_iAccessFlags & 1) != 0;
    }

    public boolean isEnum() {
        return (this.m_iAccessFlags & 0x4000) != 0;
    }

    public boolean isClass() {
        int notClass = 25088;
        return (this.m_iAccessFlags & 0x6200) == 0;
    }

    public boolean isFinal() {
        return (this.m_iAccessFlags & 0x10) != 0;
    }

    public boolean isAbstract() {
        return (this.m_iAccessFlags & 0x400) != 0;
    }

    public boolean isInterface() {
        return (this.m_iAccessFlags & 0x200) != 0;
    }

    public boolean isAnnotation() {
        return (this.m_iAccessFlags & 0x2000) != 0;
    }

    void addCollision(NodeType type) {
        if (this.m_oCollisions == null) {
            this.m_oCollisions = type.m_oCollisions = new ArrayList();
            this.m_oCollisions.add(this);
        }
        this.m_oCollisions.add(type);
    }

    public boolean hasCollision() {
        return this.m_oCollisions != null && this.m_oCollisions.size() > 0;
    }

    public Iterator getCollision() {
        if (this.m_oCollisions == null) {
            return IteratorEmpty.getEmptyIterator();
        }
        return new IteratorProxy(this.m_oCollisions.iterator());
    }

    void addSubType(NodeType type) {
        if (this.m_oSubTypes == null) {
            this.m_oSubTypes = new ArrayList();
        }
        this.m_oSubTypes.add(type);
    }

    boolean hasSubType() {
        return this.m_oSubTypes != null && this.m_oSubTypes.size() > 0;
    }

    List getSubTypes() {
        return this.m_oSubTypes;
    }

    void addImplementor(NodeType type) {
        if (this.m_oImplementors == null) {
            this.m_oImplementors = new ArrayList();
        }
        this.m_oImplementors.add(type);
    }

    boolean hasImplementor() {
        return this.m_oImplementors != null && this.m_oImplementors.size() > 0;
    }

    List getImplementors() {
        return this.m_oImplementors;
    }
}

