/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.discover.impl;

import com.trs.infra.discover.DiscoveryFactory;
import com.trs.infra.discover.IDiscovery;
import com.trs.infra.discover.impl.Container;
import com.trs.infra.discover.impl.ContainerByDir;
import com.trs.infra.discover.impl.ContainerByZip;
import com.trs.infra.discover.impl.Discovery;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;

public class FactoryByServlet
extends DiscoveryFactory {
    private static final String PATH_OF_WEBINF = "/WEB-INF/";
    private static final String NAME_OF_LIB = "lib";
    private static final String PATH_OF_LIB = "/WEB-INF/lib/";
    private static final String NAME_OF_CLASSES = "classes";
    private static final String PATH_OF_CLASSES = "/WEB-INF/classes/";
    private ServletContext m_oServletContext;
    private Pattern[] m_oIncludeLibrary;
    private Pattern[] m_oExcludeLibrary;
    private Pattern[] m_oIncludeDirectory;
    private Pattern[] m_oExcludeDirectory;

    public FactoryByServlet(ServletContext sc) {
        this.m_oServletContext = sc;
        this.makeIncludeExcludePattern(sc);
    }

    public IDiscovery build() {
        List dirs;
        Discovery discovery = new Discovery();
        List libs = this.listLibrary();
        if (libs != null && libs.size() > 0) {
            Iterator itr = libs.iterator();
            while (itr.hasNext()) {
                String path = (String)itr.next();
                Container container = this.buidLibraryContainer(path);
                if (container == null) continue;
                discovery.addContainer(container);
            }
        }
        if ((dirs = this.listDirectory()) != null && dirs.size() > 0) {
            Iterator itr = dirs.iterator();
            while (itr.hasNext()) {
                String path = (String)itr.next();
                Container container = this.buidDirectoryContainer(path);
                if (container == null) continue;
                discovery.addContainer(container);
            }
        }
        discovery.analyze();
        discovery.trimMemory();
        return discovery;
    }

    private Container buidDirectoryContainer(String path) {
        URL url;
        block3: {
            try {
                url = this.m_oServletContext.getResource(path);
                if (url != null) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        ContainerByDir container = new ContainerByDir(url, path);
        this.recursionDirectory(container, path);
        return container;
    }

    /*
     * Unable to fully structure code
     */
    private void recursionDirectory(ContainerByDir container, String path) throws IOException {
        set = this.m_oServletContext.getResourcePaths(path);
        if (set == null) {
            return;
        }
        itr = set.iterator();
        if (itr != null) ** GOTO lbl14
        return;
lbl-1000:
        // 1 sources

        {
            subpath = (String)itr.next();
            if (this.isDirectory(subpath)) {
                container.trimDirectory(subpath);
                this.recursionDirectory(container, subpath);
                continue;
            }
            url = this.m_oServletContext.getResource(subpath);
            container.trimResourceAny(subpath, url);
lbl14:
            // 3 sources

            ** while (itr.hasNext())
        }
lbl15:
        // 1 sources

    }

    private Container buidLibraryContainer(String path) {
        URL url;
        block3: {
            try {
                url = this.m_oServletContext.getResource(path);
                if (url != null) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        ContainerByZip container = new ContainerByZip(url);
        container.load();
        return container;
    }

    private List listLibrary() {
        Set set = this.m_oServletContext.getResourcePaths(PATH_OF_LIB);
        if (set == null) {
            return null;
        }
        Iterator itr = set.iterator();
        if (itr == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(set.size());
        while (itr.hasNext()) {
            String name;
            String path = (String)itr.next();
            if (this.isDirectory(path) || !this.acceptLibrary(name = path.substring(PATH_OF_LIB.length()))) continue;
            list.add(path);
        }
        return list;
    }

    private boolean isDirectory(String path) {
        return path.endsWith("/");
    }

    private List listDirectory() {
        if (this.m_oIncludeDirectory == null || this.m_oIncludeDirectory.length <= 0) {
            if (this.acceptDirectory(NAME_OF_CLASSES)) {
                ArrayList<String> list = new ArrayList<String>(1);
                list.add(PATH_OF_CLASSES);
                return list;
            }
            return null;
        }
        Set set = this.m_oServletContext.getResourcePaths(PATH_OF_WEBINF);
        if (set == null) {
            return null;
        }
        Iterator itr = set.iterator();
        if (itr == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(set.size());
        while (itr.hasNext()) {
            String path = (String)itr.next();
            if (!this.isDirectory(path)) continue;
            String name = path.substring(PATH_OF_WEBINF.length());
            if (!this.acceptDirectory(name = name.substring(0, name.length() - 1))) continue;
            list.add(path);
        }
        return list;
    }

    private boolean acceptLibrary(String name) {
        return this.accept(this.m_oExcludeLibrary, this.m_oIncludeLibrary, name, true);
    }

    private boolean acceptDirectory(String name) {
        if (NAME_OF_LIB.equals(name)) {
            return false;
        }
        boolean def = NAME_OF_CLASSES.equals(name);
        return this.accept(this.m_oExcludeDirectory, this.m_oIncludeDirectory, name, def);
    }

    private boolean accept(Pattern[] ex, Pattern[] in, String name, boolean def) {
        int i;
        if (ex != null && ex.length > 0) {
            i = 0;
            while (i < ex.length) {
                if (ex[i].matcher(name).matches()) {
                    return false;
                }
                ++i;
            }
        }
        if (in != null && in.length > 0) {
            i = 0;
            while (i < in.length) {
                if (in[i].matcher(name).matches()) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return def;
    }

    private void makeIncludeExcludePattern(ServletContext sc) {
        String s = null;
        s = sc.getInitParameter("DiscoveryIncludeLibrary");
        this.m_oIncludeLibrary = this.makeIncludeExcludePattern(s);
        if (this.m_oIncludeLibrary == null || this.m_oIncludeLibrary.length <= 0) {
            this.m_oIncludeLibrary = this.makeIncludeExcludePattern("*.jar,*.zip");
        }
        s = sc.getInitParameter("DiscoveryExcludeLibrary");
        this.m_oExcludeLibrary = this.makeIncludeExcludePattern(s);
        s = sc.getInitParameter("DiscoveryIncludeDirectory");
        this.m_oIncludeDirectory = this.makeIncludeExcludePattern(s);
        s = sc.getInitParameter("DiscoveryExcludeDirectory");
        this.m_oExcludeDirectory = this.makeIncludeExcludePattern(s);
    }

    private Pattern[] makeIncludeExcludePattern(String regexList) {
        if (regexList == null) {
            return null;
        }
        ArrayList<Pattern> list = new ArrayList<Pattern>();
        StringTokenizer stRegex = new StringTokenizer(regexList, ",");
        while (stRegex.hasMoreTokens()) {
            String regex = stRegex.nextToken().trim();
            if (regex.length() <= 0) continue;
            regex = this.escapeStar2Regex(regex);
            list.add(Pattern.compile(regex, 2));
        }
        if (list.size() <= 0) {
            return null;
        }
        Pattern[] p = new Pattern[list.size()];
        list.toArray(p);
        return p;
    }

    private String escapeStar2Regex(String src) {
        StringBuffer sb = new StringBuffer(src.length() * 2);
        int length = src.length();
        int i = 0;
        while (i < length) {
            char c = src.charAt(i);
            switch (c) {
                case '*': {
                    sb.append(".*");
                    break;
                }
                case '.': {
                    sb.append("\\.");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }
}

