/*
 * Decompiled with CFR 0.152.
 */
package com.trs.client;

import com.trs.client.TRSException;
import com.trs.client.TRSUtils;
import java.util.Calendar;

public class Date {
    private Calendar m_oJavaDate = Calendar.getInstance();
    private static final int[] m_iaDaysOfMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    private Calendar getInstance() {
        return this.m_oJavaDate;
    }

    public Date() {
        this.m_oJavaDate = Calendar.getInstance();
    }

    public Date(String strTRSDate) throws TRSException {
        if (strTRSDate == null || strTRSDate.equals("")) {
            return;
        }
        String[] _saDateTime = TRSUtils.split(strTRSDate, " ");
        _saDateTime[0] = _saDateTime[0].replace('-', '.');
        String[] _saYMD = TRSUtils.split(_saDateTime[0], ".");
        if (_saYMD.length != 3) {
            throw TRSException.New(500001, strTRSDate);
        }
        try {
            this.m_oJavaDate.set(1, Integer.parseInt(_saYMD[0]));
            this.m_oJavaDate.set(2, Integer.parseInt(_saYMD[1]) - 1);
            this.m_oJavaDate.set(5, Integer.parseInt(_saYMD[2]));
        }
        catch (NumberFormatException e) {
            throw TRSException.New(500001, strTRSDate);
        }
        this.m_oJavaDate.set(11, 0);
        this.m_oJavaDate.set(12, 0);
        this.m_oJavaDate.set(13, 0);
        if (_saDateTime.length != 2) {
            return;
        }
        String[] _saHMS = TRSUtils.split(_saDateTime[1], ":");
        if (_saHMS.length > 3) {
            throw TRSException.New(500001, strTRSDate);
        }
        try {
            this.m_oJavaDate.set(11, Integer.parseInt(_saHMS[0]));
            if (_saHMS.length >= 2) {
                this.m_oJavaDate.set(12, Integer.parseInt(_saHMS[1]));
            }
            if (_saHMS.length == 3) {
                this.m_oJavaDate.set(13, Integer.parseInt(_saHMS[2]));
            }
        }
        catch (NumberFormatException e) {
            throw TRSException.New(500001, strTRSDate);
        }
    }

    public Date(Calendar oCurTime) {
        this.m_oJavaDate = oCurTime;
    }

    public void addDay(int iInc) {
        this.m_oJavaDate.add(5, iInc);
    }

    public void addMonth(int iInc) {
        this.m_oJavaDate.add(2, iInc);
    }

    public boolean after(Date when) {
        return this.m_oJavaDate.after(when.getInstance());
    }

    public boolean before(Date when) {
        return this.m_oJavaDate.before(when.getInstance());
    }

    public void decMonth() {
        this.addMonth(-1);
    }

    public int getDate() {
        return this.m_oJavaDate.get(5);
    }

    public String getFullDate() {
        return String.valueOf(this.getYear()) + "\u5e74" + this.getMonth() + "\u6708" + this.getDate() + "\u65e5";
    }

    public String getFullTime() {
        return String.valueOf(String.valueOf(this.m_oJavaDate.get(11))) + "\u65f6" + String.valueOf(this.m_oJavaDate.get(12)) + "\u5206" + String.valueOf(this.m_oJavaDate.get(13)) + "\u79d2";
    }

    public int getHours() {
        return this.m_oJavaDate.get(11);
    }

    public int getMinutes() {
        return this.m_oJavaDate.get(12);
    }

    public int getMonth() {
        return this.m_oJavaDate.get(2) + 1;
    }

    public int getSeconds() {
        return this.m_oJavaDate.get(13);
    }

    public int getThisMonthDays() {
        int _iDays = m_iaDaysOfMonth[this.getMonth() - 1];
        if (this.getMonth() != 2) {
            return _iDays;
        }
        if (this.getYear() % 4 == 0 && this.getYear() % 100 != 0) {
            return 29;
        }
        if (this.getYear() % 4 == 0 && this.getYear() % 100 == 0 && this.getYear() % 400 == 0) {
            return 29;
        }
        return 28;
    }

    public String getTRSFormat() {
        String _sMonth = String.valueOf(this.getMonth());
        String _sDate = String.valueOf(this.getDate());
        String _sHour = String.valueOf(this.getHours());
        String _sMinute = String.valueOf(this.getMinutes());
        String _sSecond = String.valueOf(this.getSeconds());
        return String.valueOf(this.getYear()) + "." + _sMonth + "." + _sDate + " " + _sHour + ":" + _sMinute + ":" + _sSecond;
    }

    public int getYear() {
        return this.m_oJavaDate.get(1);
    }

    public boolean setDate(int iNewDate) {
        this.m_oJavaDate.set(5, iNewDate);
        return true;
    }

    public boolean setYear(int iNewYear) {
        this.m_oJavaDate.set(1, iNewYear);
        return true;
    }

    public boolean setMonth(int iNewMonth) {
        this.m_oJavaDate.set(2, iNewMonth - 1);
        return true;
    }

    public boolean setHour(int iNewHour) {
        this.m_oJavaDate.set(11, iNewHour);
        return true;
    }

    public boolean setMinute(int iNewMinute) {
        this.m_oJavaDate.set(12, iNewMinute);
        return true;
    }

    public boolean setSecond(int iNewSecond) {
        this.m_oJavaDate.set(13, iNewSecond);
        return true;
    }

    public String toString() {
        String _sMonth = String.valueOf(this.getMonth());
        String _sDate = String.valueOf(this.getDate());
        String _sHour = String.valueOf(this.getHours());
        String _sMinute = String.valueOf(this.getMinutes());
        String _sSecond = String.valueOf(this.getSeconds());
        return String.valueOf(this.getYear()) + "\u5e74" + _sMonth + "\u6708" + _sDate + "\u65e5" + _sHour + "\u65f6" + _sMinute + "\u5206" + _sSecond + "\u79d2";
    }
}

