/*
 * Decompiled with CFR 0.152.
 */
package com.trs.net.smtp;

import com.trs.net.proxy.Proxy;
import com.trs.net.util.Base64Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.List;

public class SmtpClientPI {
    private static final char[] CRLF = new char[]{'\r', '\n'};
    private String m_sServerHost;
    private int m_iServerPort;
    private Proxy m_oProxyServer;
    private String m_sEncoding;
    private int m_iBufferSize;
    private StringBuffer m_oBuffer;
    private int m_iReplyCode;
    private int m_iReplyCode1st;
    private int m_iReplyCode2nd;
    private int m_iReplyCode3rd;
    private String m_sReplyLine;
    private boolean m_zReplyPend;
    private List m_oReplyList;
    private Socket m_oSocket;
    private BufferedReader m_oReader;
    private BufferedWriter m_oWriter;
    private int m_iTimeout;

    public String getServerHost() {
        return this.m_sServerHost;
    }

    public void setServerHost(String serverHost) {
        this.m_sServerHost = serverHost;
    }

    public int getM_iServerPort() {
        return this.m_iServerPort;
    }

    public void setM_iServerPort(int serverPort) {
        this.m_iServerPort = serverPort;
    }

    public Proxy getProxyServer() {
        return this.m_oProxyServer;
    }

    public void setProxyServer(Proxy proxyServer) {
        this.m_oProxyServer = proxyServer;
    }

    public String getEncoding() {
        return this.m_sEncoding;
    }

    public void setEncoding(String encoding) {
        this.m_sEncoding = encoding;
    }

    public int getM_iBufferSize() {
        return this.m_iBufferSize;
    }

    public void setM_iBufferSize(int bufferSize) {
        this.m_iBufferSize = bufferSize;
    }

    public StringBuffer getBuffer() {
        return this.m_oBuffer;
    }

    public void setBuffer(StringBuffer buffer) {
        this.m_oBuffer = buffer;
    }

    public int getReplyCode() {
        return this.m_iReplyCode;
    }

    public void setReplyCode(int replyCode) {
        this.m_iReplyCode = replyCode;
    }

    public int getReplyCode1st() {
        return this.m_iReplyCode1st;
    }

    public void setReplyCode1st(int replyCode1st) {
        this.m_iReplyCode1st = replyCode1st;
    }

    public int getReplyCode2nd() {
        return this.m_iReplyCode2nd;
    }

    public void setReplyCode2nd(int replyCode2nd) {
        this.m_iReplyCode2nd = replyCode2nd;
    }

    public int getReplyCode3rd() {
        return this.m_iReplyCode3rd;
    }

    public void setReplyCode3rd(int replyCode3rd) {
        this.m_iReplyCode3rd = replyCode3rd;
    }

    public String getReplyLine() {
        return this.m_sReplyLine;
    }

    public void setReplyLine(String replyLine) {
        this.m_sReplyLine = replyLine;
    }

    public boolean isM_zReplyPend() {
        return this.m_zReplyPend;
    }

    public void setM_zReplyPend(boolean replyPend) {
        this.m_zReplyPend = replyPend;
    }

    public List getReplyList() {
        return this.m_oReplyList;
    }

    public void setReplyList(List replyList) {
        this.m_oReplyList = replyList;
    }

    public int getTimeout() {
        return this.m_iTimeout;
    }

    public void setTimeout(int timeout) {
        this.m_iTimeout = timeout;
    }

    private void destroySocket() {
        if (this.m_oSocket == null) {
            return;
        }
    }

    Socket createSocket(String host, int port, Proxy proxy) throws IOException {
        if (proxy == null) {
            return new Socket(host, port);
        }
        return null;
    }

    public boolean connect(String host, int port, Proxy proxy) throws IOException {
        if (this.isConnected()) {
            return true;
        }
        this.m_sServerHost = host;
        this.m_iServerPort = port;
        this.m_oProxyServer = proxy;
        this.m_oSocket = this.createSocket(host, port, proxy);
        this.m_oSocket.setSoTimeout(this.m_iTimeout);
        InputStream is = this.m_oSocket.getInputStream();
        InputStreamReader insr = new InputStreamReader(is, this.m_sEncoding);
        this.m_oReader = new BufferedReader(insr);
        OutputStream os = this.m_oSocket.getOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter(os, this.m_sEncoding);
        this.m_oWriter = new BufferedWriter(osw);
        this.readReply();
        if (this.m_iReplyCode1st != 2) {
            this.disconnect();
        }
        return this.m_iReplyCode1st == 2;
    }

    public void disconnect() {
        this.destroySocket();
        this.m_oSocket = null;
        this.m_oBuffer.setLength(0);
        this.m_oReplyList.clear();
        this.m_sReplyLine = null;
        this.m_iReplyCode = 0;
        this.m_iReplyCode1st = 0;
        this.m_iReplyCode2nd = 0;
        this.m_iReplyCode3rd = 0;
        this.m_sServerHost = null;
        this.m_iServerPort = 21;
        this.m_oProxyServer = null;
    }

    public boolean open() {
        return this.isConnected();
    }

    public void close() {
        if (this.m_oSocket == null) {
            return;
        }
        try {
            this.m_oSocket.setSoTimeout(1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.quit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.disconnect();
    }

    public int issueCommand(String cmd, String arg) throws IOException {
        while (this.m_zReplyPend) {
            this.readReply();
        }
        this.m_oWriter.write(cmd);
        if (arg != null) {
            this.m_oWriter.write(32);
            this.m_oWriter.write(arg);
        }
        this.m_oWriter.write(CRLF, 0, 2);
        this.m_oWriter.flush();
        return this.readReply();
    }

    private final int readReply() throws IOException {
        this.m_oReplyList.clear();
        String sLine = this.m_oReader.readLine();
        if (sLine == null) {
            throw new EOFException("Unexpected control connection close.");
        }
        if (sLine.length() < 3) {
            throw new EOFException("Unexpected reply (too short):" + sLine);
        }
        this.m_oReplyList.add(sLine);
        this.m_iReplyCode1st = sLine.charAt(0) - 48;
        this.m_iReplyCode2nd = sLine.charAt(1) - 48;
        this.m_iReplyCode3rd = sLine.charAt(2) - 48;
        this.m_iReplyCode = this.m_iReplyCode1st * 100 + this.m_iReplyCode2nd * 10 + this.m_iReplyCode3rd;
        this.m_zReplyPend = this.m_iReplyCode1st == 1;
        this.m_sReplyLine = sLine;
        if (sLine.length() > 3 && sLine.charAt(3) == '-') {
            char c;
            int l;
            do {
                if ((sLine = this.m_oReader.readLine()) == null) {
                    throw new EOFException("Unexpected connection close.");
                }
                this.m_oReplyList.add(sLine);
            } while ((l = sLine.length()) < 3 || (c = sLine.charAt(0)) < '0' || c > '9' || l != 3 && (l <= 3 || sLine.charAt(3) != ' '));
        }
        return this.m_iReplyCode;
    }

    public String getReplyString() {
        int size = this.m_oReplyList.size();
        StringBuffer sb = new StringBuffer(size * 256);
        int i = 0;
        while (i < size) {
            sb.append(this.m_oReplyList.get(i));
            sb.append(CRLF);
            ++i;
        }
        return sb.toString();
    }

    public boolean isConnected() {
        return this.m_oSocket != null;
    }

    public int quit() throws IOException {
        return this.issueCommand("QUIT", null);
    }

    public void ehlo() throws IOException {
        this.issueCommand("ehlo", null);
    }

    public void auth() throws IOException {
        this.issueCommand("auth login", null);
    }

    public void user(String user) throws IOException {
        this.issueCommand(Base64Util.encode(user), null);
    }

    public void pass(String pass) throws IOException {
        this.issueCommand(Base64Util.encode(pass), null);
    }
}

