/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.member;

import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.StreamReader;
import com.trs.infra.cluster.StreamType;
import com.trs.infra.cluster.StreamWriter;
import com.trs.infra.cluster.impl.InnerStreamTypes;
import com.trs.infra.cluster.member.MemberImpl;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.security.PublicKey;
import org.apache.log4j.Logger;

public class MemberMessage
extends ClusterMessage {
    private static final Logger s_logger;
    public static final int MAJOR_MESSAGE_ID = 4;
    public static final int MINOR_HEARTBEAT = 1;
    public static final int MINOR_WELCOME = 2;
    public static final int MINOR_DECLARE = 3;
    public static final int MINOR_ACCEPTED = 4;
    public static final int MINOR_ACCEPT_ACK = 5;
    public static final int MINOR_LEFT = 6;
    public static final int MINOR_ATTRIBUTE = 7;
    public static final int MINOR_ARE_YOU_OK = 8;
    private String toGUID;
    private String fromGUID;
    private PublicKey publicKey;
    private long freeMemory;
    private long totalMemory;
    private long currentTime;
    private InetAddress listenAddress;
    private int listenPort;
    private MemberImpl declareMember;
    private boolean needAcceptACK;
    private String attributeName;
    private Serializable attributeValue;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.member.MemberMessage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public MemberMessage() {
        this.setMajorId(4);
        this.setBroadcast(true);
    }

    public String _guid() {
        return null;
    }

    public StreamType _type() {
        return InnerStreamTypes.MemberMessage;
    }

    public void _load(StreamReader is) throws IOException {
        switch (this.getMinorId()) {
            case 1: {
                this.freeMemory = is.read_long();
                this.totalMemory = is.read_long();
                this.currentTime = is.read_long();
                this.fromGUID = is.read_string();
                break;
            }
            case 2: {
                this.toGUID = is.read_string();
                this.fromGUID = is.read_string();
                this.listenPort = is.read_int();
                try {
                    this.listenAddress = (InetAddress)is.read_object();
                }
                catch (ClassNotFoundException classNotFoundException) {}
                break;
            }
            case 3: {
                this.declareMember = new MemberImpl();
                this.declareMember._load(is);
                break;
            }
            case 4: {
                this.declareMember = new MemberImpl();
                this.needAcceptACK = is.read_boolean();
                this.declareMember._load(is);
                break;
            }
            case 5: {
                this.fromGUID = is.read_string();
                break;
            }
            case 6: {
                this.fromGUID = is.read_string();
                break;
            }
            case 7: {
                this.fromGUID = is.read_string();
                this.attributeName = is.read_string();
                try {
                    this.attributeValue = (Serializable)is.read_object();
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Class not found:" + e.toString());
                }
            }
            case 8: {
                this.fromGUID = is.read_string();
                break;
            }
            default: {
                s_logger.error((Object)"Unknown minor message id ");
            }
        }
    }

    public void _save(StreamWriter os) throws IOException {
        switch (this.getMinorId()) {
            case 1: {
                os.write_long(this.freeMemory);
                os.write_long(this.totalMemory);
                os.write_long(this.currentTime);
                os.write_string(this.fromGUID);
                break;
            }
            case 2: {
                os.write_string(this.toGUID);
                os.write_string(this.fromGUID);
                os.write_int(this.listenPort);
                os.write_object(this.listenAddress);
                break;
            }
            case 3: {
                this.declareMember._save(os);
                break;
            }
            case 4: {
                os.write_boolean(this.needAcceptACK);
                this.declareMember._save(os);
                break;
            }
            case 5: {
                os.write_string(this.fromGUID);
                break;
            }
            case 6: {
                os.write_string(this.fromGUID);
                break;
            }
            case 7: {
                os.write_string(this.fromGUID);
                os.write_string(this.attributeName);
                os.write_object(this.attributeValue);
                break;
            }
            case 8: {
                os.write_string(this.fromGUID);
                break;
            }
            default: {
                s_logger.error((Object)("Unknown minor message id: " + this.getMinorId()));
            }
        }
    }

    public final String getToGUID() {
        return this.toGUID;
    }

    public final void setToGUID(String toGUID) {
        this.toGUID = toGUID;
    }

    public final String getFromGUID() {
        return this.fromGUID;
    }

    public final void setFromGUID(String fromGUID) {
        this.fromGUID = fromGUID;
    }

    public final long getFreeMemory() {
        return this.freeMemory;
    }

    public final PublicKey getPublicKey() {
        return this.publicKey;
    }

    public final void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public final void setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
    }

    public final long getTotalMemory() {
        return this.totalMemory;
    }

    public final void setTotalMemory(long totalMemory) {
        this.totalMemory = totalMemory;
    }

    public final long getCurrentTime() {
        return this.currentTime;
    }

    public final void setCurrentTime(long currentTime) {
        this.currentTime = currentTime;
    }

    public final InetAddress getListenAddress() {
        return this.listenAddress;
    }

    public final void setListenAddress(InetAddress listenAddress) {
        this.listenAddress = listenAddress;
    }

    public final int getListenPort() {
        return this.listenPort;
    }

    public final void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }

    public final MemberImpl getDeclareMember() {
        return this.declareMember;
    }

    public final void setDeclareMember(MemberImpl declareMember) {
        this.declareMember = declareMember;
    }

    public final boolean isNeedAcceptACK() {
        return this.needAcceptACK;
    }

    public final void setNeedAcceptACK(boolean needAcceptACK) {
        this.needAcceptACK = needAcceptACK;
    }

    public final String getAttributeName() {
        return this.attributeName;
    }

    public final void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public final Serializable getAttributeValue() {
        return this.attributeValue;
    }

    public final void setAttributeValue(Serializable attributeValue) {
        this.attributeValue = attributeValue;
    }
}

