/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.io;

import com.trs.infra.cluster.StreamWriter;
import com.trs.infra.cluster.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class FilterStreamWriter
extends FilterOutputStream
implements StreamWriter {
    private long fullSize = 0L;
    private int intCount = 0;
    private ByteArrayOutputStream bypass;
    private final byte[] numberBuffer = new byte[8];

    public FilterStreamWriter(OutputStream out) {
        super(out);
    }

    private final void incCount(int value) {
        int temp = this.intCount + value;
        if (temp > 0) {
            this.intCount = temp;
            return;
        }
        this.intCount = 0;
        this.fullSize = this.fullSize + (long)this.intCount + (long)value;
    }

    public final ByteArrayOutputStream getBypass() {
        return this.bypass;
    }

    public final void setBypass(ByteArrayOutputStream bypass) {
        this.bypass = bypass;
    }

    public final long size() {
        return this.fullSize + (long)this.intCount;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        super.close();
        this.fullSize = 0L;
        this.intCount = 0;
        this.bypass = null;
    }

    public final void write(int b) throws IOException {
        this.out.write(b);
        this.incCount(1);
        ByteArrayOutputStream bypass = this.bypass;
        if (bypass != null) {
            bypass.write(b);
        }
    }

    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public final void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.incCount(len);
        ByteArrayOutputStream bypass = this.bypass;
        if (bypass != null) {
            bypass.write(b, off, len);
        }
    }

    public final void write_boolean(boolean value) throws IOException {
        this.write(value ? 1 : 0);
    }

    public final void write_byte(byte value) throws IOException {
        this.write(value);
    }

    public final void write_char(char value) throws IOException {
        this.write(value >>> 8 & 0xFF);
        this.write(value >>> 0 & 0xFF);
    }

    public final void write_short(short value) throws IOException {
        this.write(value >>> 8 & 0xFF);
        this.write(value >>> 0 & 0xFF);
    }

    public final void write_int(int value) throws IOException {
        this.numberBuffer[0] = (byte)(value >>> 24);
        this.numberBuffer[1] = (byte)(value >>> 16);
        this.numberBuffer[2] = (byte)(value >>> 8);
        this.numberBuffer[3] = (byte)(value >>> 0);
        this.write(this.numberBuffer, 0, 4);
    }

    public final void write_long(long value) throws IOException {
        this.numberBuffer[0] = (byte)(value >>> 56);
        this.numberBuffer[1] = (byte)(value >>> 48);
        this.numberBuffer[2] = (byte)(value >>> 40);
        this.numberBuffer[3] = (byte)(value >>> 32);
        this.numberBuffer[4] = (byte)(value >>> 24);
        this.numberBuffer[5] = (byte)(value >>> 16);
        this.numberBuffer[6] = (byte)(value >>> 8);
        this.numberBuffer[7] = (byte)(value >>> 0);
        this.write(this.numberBuffer, 0, 8);
    }

    public final void write_float(float value) throws IOException {
        this.write_int(Float.floatToIntBits(value));
    }

    public final void write_double(double value) throws IOException {
        this.write_long(Double.doubleToLongBits(value));
    }

    public final void write_string(String value) throws IOException {
        if (value == null) {
            this.write_int(-1);
            return;
        }
        if (value.length() <= 0) {
            this.write_int(0);
            return;
        }
        byte[] stringBuffer = value.getBytes("UTF-8");
        this.write_byte_array(stringBuffer);
    }

    public final void write_object(Serializable value) throws IOException {
        if (value == null) {
            this.write_byte((byte)0);
            return;
        }
        this.write_byte((byte)85);
        ObjectOutputStream oos = new ObjectOutputStream(this);
        oos.writeUnshared(value);
        oos.flush();
        this.write_byte((byte)85);
    }

    public final void write_byte_array(byte[] buf) throws IOException {
        if (buf == null) {
            this.write_int(-1);
            return;
        }
        int length = buf.length;
        if (length == 0) {
            this.write_int(0);
            return;
        }
        this.write_int(length);
        this.write(buf, 0, length);
    }
}

