/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.impl.transport;

import com.trs.infra.cluster.impl.InetListener;
import com.trs.infra.cluster.impl.transport.DatagramPacketPool;
import com.trs.infra.cluster.impl.transport.DatagramPacketQueue;
import com.trs.infra.cluster.io.TransportTracer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import org.apache.log4j.Logger;

public class InetListenerByMulticast
extends InetListener {
    private static final Logger s_logger;
    private String localAddress;
    private MulticastSocket receiveSocket;
    private DatagramPacketPool dataPacketPool;
    private DatagramPacketQueue dataPacketQueue;
    private TransportTracer transportTracer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.impl.transport.InetListenerByMulticast");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public InetListenerByMulticast() {
        super("InetListenerByMulticast");
    }

    protected void startup() {
        try {
            this.dataPacketPool = new DatagramPacketPool(64, this.getConfig().getUDPBufferSize());
            this.dataPacketQueue = new DatagramPacketQueue(4096);
            int port = this.getConfig().getMulticastPort();
            InetAddress bind = this.getConfig().getInetMulticastBind();
            InetAddress group = this.getConfig().getInetMulticastAddress();
            this.localAddress = bind.getHostAddress();
            new RuntimeException("who call me").printStackTrace();
            throw new RuntimeException("who call me");
        }
        catch (IOException e) {
            String info = "InetListenerByMulticast startup failed";
            s_logger.fatal((Object)info, (Throwable)e);
            throw new RuntimeException(info, e);
        }
    }

    protected void doListen() {
        try {
            DatagramPacketPool.CDP cdp = this.dataPacketPool.getCDP();
            DatagramPacket datePacket = cdp.getDatePacket();
            this.receiveSocket.receive(datePacket);
            if (this.localAddress.equals(datePacket.getAddress().getHostAddress())) {
                return;
            }
            TransportTracer tracer = this.transportTracer;
            if (tracer != null) {
                tracer.trace(datePacket);
            }
            this.dataPacketQueue.put(cdp);
        }
        catch (Exception e) {
            s_logger.error((Object)"InetListenerByMulticast doListen failed", (Throwable)e);
        }
    }

    protected void cleanup() {
        try {
            this.receiveSocket.close();
        }
        catch (Exception e) {
            s_logger.error((Object)"InetListenerByMulticast cleanup failed", (Throwable)e);
        }
        s_logger.info((Object)("Because close(), drop message count:" + this.dataPacketQueue.size()));
    }
}

