/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.Envelope;
import org.apache.soap.Fault;
import org.apache.soap.SOAPException;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.encoding.soapenc.SoapEncUtils;
import org.apache.soap.providers.RPCJavaProvider;
import org.apache.soap.rpc.Call;
import org.apache.soap.rpc.RPCMessage;
import org.apache.soap.rpc.Response;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.RPCRouter;
import org.apache.soap.server.ServerUtils;
import org.apache.soap.server.ServiceManager;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.transport.EnvelopeEditor;
import org.apache.soap.transport.EnvelopeEditorFactory;
import org.apache.soap.transport.TransportMessage;
import org.apache.soap.util.Provider;
import org.apache.soap.util.xml.XMLParserUtils;

public class RPCRouterServlet
extends HttpServlet {
    private EnvelopeEditor editor = null;
    private String configFilename = null;

    public void init() throws ServletException {
        String tempStr;
        EnvelopeEditorFactory factory;
        ClassLoader servletClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            servletClassLoader.loadClass(((Object)((Object)this)).getClass().getName());
        }
        catch (ClassNotFoundException e) {
            servletClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        if (servletClassLoader == null) {
            servletClassLoader = ClassLoader.getSystemClassLoader();
        }
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext servletContext = servletConfig.getServletContext();
        String envelopeEditorFactoryClassName = servletConfig.getInitParameter("EnvelopeEditorFactory");
        if (envelopeEditorFactoryClassName == null) {
            envelopeEditorFactoryClassName = servletContext.getInitParameter("EnvelopeEditorFactory");
        }
        if (envelopeEditorFactoryClassName != null && (factory = (EnvelopeEditorFactory)this.createObject(envelopeEditorFactoryClassName, servletClassLoader)) != null) {
            try {
                String name;
                Properties props = new Properties();
                Enumeration enumeration = servletContext.getInitParameterNames();
                while (enumeration.hasMoreElements()) {
                    name = (String)enumeration.nextElement();
                    if ("EnvelopeEditorFactory".equals(name) || "XMLParser".equals(name)) continue;
                    props.put(name, servletContext.getInitParameter(name));
                }
                enumeration = servletConfig.getInitParameterNames();
                while (enumeration.hasMoreElements()) {
                    name = (String)enumeration.nextElement();
                    if ("EnvelopeEditorFactory".equals(name) || "XMLParser".equals(name)) continue;
                    props.put(name, servletConfig.getInitParameter(name));
                }
                String servletContextPath = servletContext.getRealPath("");
                if (servletContextPath != null) {
                    props.put("SOAPServerContextPath", servletContextPath);
                }
                this.editor = factory.create(props);
            }
            catch (SOAPException e) {
                throw new ServletException("Can't create editor", (Throwable)e);
            }
        }
        if ((tempStr = servletConfig.getInitParameter("ConfigFile")) == null) {
            tempStr = servletContext.getInitParameter("ConfigFile");
        }
        if (tempStr != null) {
            this.configFilename = tempStr;
        }
        if ((tempStr = servletConfig.getInitParameter("XMLParser")) == null) {
            tempStr = servletContext.getInitParameter("XMLParser");
        }
        if (tempStr != null) {
            XMLParserUtils.refreshDocumentBuilderFactory(tempStr, true, false);
        }
        ServerHTTPUtils.setServletClassLoaderIntoContext(servletContext, servletClassLoader);
    }

    private Object createObject(String className, ClassLoader classLoader) throws ServletException {
        try {
            return classLoader.loadClass(className).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ServletException("Can't find class named '" + className + "'.");
        }
        catch (InstantiationException e) {
            throw new ServletException("Can't instantiate class '" + className + "'.");
        }
        catch (IllegalAccessException e) {
            throw new ServletException("WARNING: Can't access the constructor of the class '" + className + "'.");
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        out.println("<html><head><title>SOAP RPC Router</title></head>");
        out.println("<body><h1>SOAP RPC Router</h1>");
        out.println("<p>Sorry, I don't speak via HTTP GET- you have to use");
        out.println("HTTP POST to talk to me.</p></body></html>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        ServiceManager serviceManager = ServerHTTPUtils.getServiceManagerFromContext(context, this.configFilename);
        RPCMessage call = null;
        Response resp = null;
        String targetID = null;
        String fullTargetID = null;
        int status = 200;
        DeploymentDescriptor dd = null;
        SOAPContext reqCtx = new SOAPContext();
        SOAPContext resCtx = new SOAPContext();
        Envelope callEnv = null;
        reqCtx.setClassLoader(ServerHTTPUtils.getServletClassLoaderFromContext(context));
        try {
            try {
                try {
                    reqCtx.setProperty(Constants.BAG_HTTPSERVLET, (Object)this);
                    reqCtx.setProperty(Constants.BAG_HTTPSERVLETREQUEST, req);
                    reqCtx.setProperty(Constants.BAG_HTTPSERVLETRESPONSE, res);
                    DocumentBuilder xdb = XMLParserUtils.getXMLDocBuilderFromPool();
                    try {
                        callEnv = ServerHTTPUtils.readEnvelopeFromRequest(xdb, req.getContentType(), req.getContentLength(), (InputStream)req.getInputStream(), this.editor, res, reqCtx, ServerHTTPUtils.getHeaders(req));
                    }
                    finally {
                        XMLParserUtils.returnDocumentBuilderToPool(xdb);
                    }
                    if (callEnv == null) {
                        return;
                    }
                    call = RPCRouter.extractCallFromEnvelope(serviceManager, callEnv, reqCtx);
                    targetID = call.getTargetObjectURI();
                    if (targetID == null) {
                        throw new SOAPException(Constants.FAULT_CODE_SERVER, "No target namespace specified in request.");
                    }
                    fullTargetID = call.getFullTargetObjectURI();
                }
                catch (IllegalArgumentException e) {
                    String msg = e.getMessage();
                    String faultCode = msg != null && msg.equals(Constants.ERR_MSG_VERSION_MISMATCH) ? Constants.FAULT_CODE_VERSION_MISMATCH : Constants.FAULT_CODE_CLIENT;
                    throw new SOAPException(faultCode, msg, e);
                }
                dd = serviceManager.query(targetID);
                reqCtx.setProperty(Constants.BAG_DEPLOYMENTDESCRIPTOR, dd);
                if (!ServerHTTPUtils.isUserAuthorized(dd, req, res)) {
                    return;
                }
                Hashtable props = dd.getProps();
                String sessionRequired = props != null ? (String)props.get("SessionRequired") : null;
                HttpSession session = req.getSession(dd.getScope() == 1 || sessionRequired == null || SoapEncUtils.decodeBooleanValue(sessionRequired));
                if (session != null) {
                    reqCtx.setProperty(Constants.BAG_HTTPSESSION, session);
                }
                Provider provider = dd.getProviderType() == 0 ? new RPCJavaProvider() : (dd.getProviderType() == 3 ? ServerUtils.loadProvider(dd, reqCtx) : new RPCJavaProvider());
                provider.locate(dd, callEnv, (Call)call, call.getMethodName(), fullTargetID, reqCtx);
                ServerUtils.setResponseGzip(dd, reqCtx, resCtx);
                provider.invoke(reqCtx, resCtx);
            }
            catch (Throwable t) {
                SOAPException e = null;
                e = t instanceof SOAPException ? (SOAPException)t : new SOAPException(Constants.FAULT_CODE_SERVER + ".Exception:", "", t);
                Fault fault = new Fault(e);
                fault.setFaultActorURI(req.getRequestURI());
                if (dd != null) {
                    dd.buildFaultRouter(reqCtx).notifyListeners(fault, e);
                }
                status = 500;
                String respEncStyle = null;
                if (call != null) {
                    respEncStyle = call.getEncodingStyleURI();
                }
                if (respEncStyle == null) {
                    respEncStyle = "http://schemas.xmlsoap.org/soap/encoding/";
                }
                resCtx = new SOAPContext();
                resp = new Response(null, null, fault, null, null, respEncStyle, resCtx);
                SOAPMappingRegistry smr = call != null ? ((Call)call).getSOAPMappingRegistry() : ServerHTTPUtils.getSMRFromContext(context);
                Envelope env = resp.buildEnvelope();
                StringWriter sw = new StringWriter(1024);
                env.marshall(sw, smr, resp.getSOAPContext());
                resp.getSOAPContext().setRootPart(sw.toString(), "text/xml;charset=utf-8");
            }
            TransportMessage sres = new TransportMessage(null, resCtx, null);
            sres.editOutgoing(this.editor);
            sres.save();
            res.setStatus(status);
            res.setContentType(sres.getContentType());
            Enumeration headers = sres.getHeaderNames();
            while (headers.hasMoreElements()) {
                String name = (String)headers.nextElement();
                res.setHeader(name, sres.getHeader(name));
            }
            res.setContentLength(sres.getContentLength());
            ServletOutputStream outStream = res.getOutputStream();
            sres.writeTo((OutputStream)outStream);
        }
        catch (Exception e) {
            throw new ServletException("Error building response envelope: " + e, (Throwable)e);
        }
    }
}

