/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dbunit.database.AmbiguousTableNameException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseTableIterator;
import org.dbunit.database.DatabaseTableMetaData;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.IResultSetTableFactory;
import org.dbunit.dataset.AbstractDataSet;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DataSetUtils;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchTableException;

public class DatabaseDataSet
extends AbstractDataSet {
    private final IDatabaseConnection _connection;
    private final Map _tableMap = new HashMap();
    private List _nameList = null;

    DatabaseDataSet(IDatabaseConnection connection) throws SQLException {
        this._connection = connection;
    }

    static String getSelectStatement(String schema, ITableMetaData metaData, String escapePattern) throws DataSetException {
        int i;
        Column[] columns = metaData.getColumns();
        Column[] primaryKeys = metaData.getPrimaryKeys();
        StringBuffer sqlBuffer = new StringBuffer(128);
        sqlBuffer.append("select ");
        for (i = 0; i < columns.length; ++i) {
            if (i > 0) {
                sqlBuffer.append(", ");
            }
            String columnName = DataSetUtils.getQualifiedName(null, columns[i].getColumnName(), escapePattern);
            sqlBuffer.append(columnName);
        }
        sqlBuffer.append(" from ");
        sqlBuffer.append(DataSetUtils.getQualifiedName(schema, metaData.getTableName(), escapePattern));
        for (i = 0; i < primaryKeys.length; ++i) {
            if (i == 0) {
                sqlBuffer.append(" order by ");
            } else {
                sqlBuffer.append(", ");
            }
            sqlBuffer.append(primaryKeys[i].getColumnName());
        }
        return sqlBuffer.toString();
    }

    private String getQualifiedName(String prefix, String name) {
        DatabaseConfig config = this._connection.getConfig();
        boolean feature = config.getFeature("http://www.dbunit.org/features/qualifiedTableNames");
        if (feature) {
            return DataSetUtils.getQualifiedName(prefix, name);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() throws DataSetException {
        if (this._nameList != null) {
            return;
        }
        try {
            Connection jdbcConnection = this._connection.getConnection();
            String schema = this._connection.getSchema();
            String[] tableType = (String[])this._connection.getConfig().getProperty("http://www.dbunit.org/properties/tableType");
            DatabaseMetaData databaseMetaData = jdbcConnection.getMetaData();
            ResultSet resultSet = databaseMetaData.getTables(null, schema, "%", tableType);
            try {
                ArrayList<String> nameList = new ArrayList<String>();
                while (resultSet.next()) {
                    String schemaName = resultSet.getString(2);
                    String tableName = resultSet.getString(3);
                    if (this._tableMap.containsKey((tableName = this.getQualifiedName(schemaName, tableName)).toUpperCase())) {
                        throw new AmbiguousTableNameException(tableName);
                    }
                    nameList.add(tableName);
                    this._tableMap.put(tableName.toUpperCase(), null);
                }
                this._nameList = nameList;
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            throw new DataSetException(e);
        }
    }

    protected ITableIterator createIterator(boolean reversed) throws DataSetException {
        String[] names = this.getTableNames();
        if (reversed) {
            names = DataSetUtils.reverseStringArray(names);
        }
        return new DatabaseTableIterator(names, this);
    }

    public String[] getTableNames() throws DataSetException {
        this.initialize();
        return this._nameList.toArray(new String[0]);
    }

    public ITableMetaData getTableMetaData(String tableName) throws DataSetException {
        this.initialize();
        String upperTableName = tableName.toUpperCase();
        if (!this._tableMap.containsKey(upperTableName)) {
            throw new NoSuchTableException(tableName);
        }
        ITableMetaData metaData = (ITableMetaData)this._tableMap.get(upperTableName);
        if (metaData != null) {
            return metaData;
        }
        Iterator it = this._nameList.iterator();
        while (it.hasNext()) {
            String databaseTableName = (String)it.next();
            if (!databaseTableName.equalsIgnoreCase(tableName)) continue;
            metaData = new DatabaseTableMetaData(databaseTableName, this._connection);
            this._tableMap.put(upperTableName, metaData);
            break;
        }
        return metaData;
    }

    public ITable getTable(String tableName) throws DataSetException {
        this.initialize();
        try {
            ITableMetaData metaData = this.getTableMetaData(tableName);
            DatabaseConfig config = this._connection.getConfig();
            IResultSetTableFactory factory = (IResultSetTableFactory)config.getProperty("http://www.dbunit.org/properties/resultSetTableFactory");
            return factory.createTable(metaData, this._connection);
        }
        catch (SQLException e) {
            throw new DataSetException(e);
        }
    }
}

