/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.stream;

import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.RowOutOfBoundsException;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;

public class DataSetProducerAdapter
implements IDataSetProducer {
    private static final IDataSetConsumer EMPTY_CONSUMER = new DefaultConsumer();
    private final ITableIterator _iterator;
    private IDataSetConsumer _consumer = EMPTY_CONSUMER;

    public DataSetProducerAdapter(ITableIterator iterator) {
        this._iterator = iterator;
    }

    public DataSetProducerAdapter(IDataSet dataSet) throws DataSetException {
        this._iterator = dataSet.iterator();
    }

    public void setConsumer(IDataSetConsumer consumer) throws DataSetException {
        this._consumer = consumer;
    }

    public void produce() throws DataSetException {
        this._consumer.startDataSet();
        while (this._iterator.next()) {
            ITable table = this._iterator.getTable();
            ITableMetaData metaData = table.getTableMetaData();
            this._consumer.startTable(metaData);
            try {
                Column[] columns = metaData.getColumns();
                if (columns.length == 0) {
                    this._consumer.endTable();
                    continue;
                }
                int i = 0;
                while (true) {
                    Object[] values = new Object[columns.length];
                    for (int j = 0; j < columns.length; ++j) {
                        Column column = columns[j];
                        values[j] = table.getValue(i, column.getColumnName());
                    }
                    this._consumer.row(values);
                    ++i;
                }
            }
            catch (RowOutOfBoundsException e) {
                this._consumer.endTable();
            }
        }
        this._consumer.endDataSet();
    }
}

