/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

class LineFormatter {
    String comment = null;
    int maxLength = 65;
    int offset = 0;
    int length = 0;
    String prefix = null;
    private StringBuffer sb = null;

    LineFormatter(String comment) {
        this.comment = comment;
        if (comment != null) {
            this.length = comment.length();
        }
        this.sb = new StringBuffer();
    }

    LineFormatter(String comment, int maxLength) {
        this(comment, maxLength, null);
    }

    LineFormatter(String comment, int maxLength, String prefix) {
        this(comment);
        this.maxLength = maxLength;
        this.prefix = prefix;
    }

    boolean hasMoreLines() {
        if (this.comment == null) {
            return false;
        }
        return this.offset < this.length;
    }

    String nextLine() {
        int index;
        int max;
        if (this.comment == null) {
            return null;
        }
        if (this.offset >= this.length) {
            return null;
        }
        this.sb.setLength(0);
        if (this.prefix != null) {
            this.sb.append(this.prefix);
        }
        if ((max = this.offset + this.maxLength) > this.length) {
            max = this.length;
        }
        int breakable = this.offset;
        for (index = this.offset; index < max; ++index) {
            char ch = this.comment.charAt(index);
            if (this.isNewLine(ch)) {
                this.sb.append(this.comment.substring(this.offset, index));
                this.offset = index + 1;
                return this.sb.toString();
            }
            if (!this.isWhitespace(ch)) continue;
            breakable = index;
        }
        if (index < this.length - 1) {
            if (this.offset == breakable) {
                while (index < this.length && !this.isBreakable(this.comment.charAt(index))) {
                    ++index;
                }
            } else {
                index = breakable;
            }
        }
        this.sb.append(this.comment.substring(this.offset, index));
        this.offset = index + 1;
        return this.sb.toString();
    }

    void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private boolean isBreakable(char ch) {
        return this.isWhitespace(ch) || this.isNewLine(ch);
    }

    private boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t';
    }

    private boolean isNewLine(char ch) {
        return ch == '\n' || ch == '\r';
    }
}

