/*
 * Decompiled with CFR 0.152.
 */
package com.trs.scm.sdk.impl;

import com.trs.infra.util.CMyException;
import com.trs.scm.sdk.impl.AbstractMessageMgr;
import com.trs.scm.sdk.model.MicroMessage;
import com.trs.scm.sdk.model.OAuth;
import com.trs.scm.sdk.model.SinaErrorMessage;
import org.apache.log4j.Logger;
import weibo4j.Account;
import weibo4j.Weibo;
import weibo4j.http.Response;
import weibo4j.model.PostParameter;
import weibo4j.org.json.JSONException;
import weibo4j.org.json.JSONObject;
import weibo4j.util.WeiboConfig;

public class SinaMessageMgr
extends AbstractMessageMgr {
    private static Logger logger = Logger.getLogger(SinaMessageMgr.class);
    private Weibo m_oSinaWeibo = new Weibo();
    private Account oAccount = null;

    public SinaMessageMgr(OAuth auth) {
        super(auth);
        this.m_oSinaWeibo.setToken(this.m_oOAuth.getOAuth_token());
        this.oAccount = new Account();
        this.oAccount.setToken(this.m_oOAuth.getOAuth_token());
    }

    @Override
    public MicroMessage getMessage() throws Exception {
        Account oSinaAccount = this.oAccount;
        int sUID = 0;
        try {
            sUID = oSinaAccount.getUid().getInt("uid");
        }
        catch (JSONException _oJSONException) {
            logger.error((Object)_oJSONException.getStackTrace());
            throw new Exception("JSON\u83b7\u53d6UID\u53c2\u6570\u9519\u8bef", _oJSONException);
        }
        catch (Exception _oWeiboException) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        Response oRes = null;
        try {
            oRes = this.m_oSinaWeibo.client.get(WeiboConfig.getValue((String)"baseURL") + "remind/unread_count.json", new PostParameter[]{new PostParameter("uid", sUID)});
        }
        catch (Exception _oWeiboException) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        JSONObject oJSONObject = null;
        try {
            oJSONObject = oRes.asJSONObject();
        }
        catch (Exception _oWeiboException) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        MicroMessage oMessage = new MicroMessage();
        try {
            oMessage.setUnreadCount(1, oJSONObject.getLong("status"));
            oMessage.setUnreadCount(2, oJSONObject.getLong("cmt"));
            oMessage.setUnreadCount(3, oJSONObject.getLong("mention_status") + oJSONObject.getLong("mention_cmt"));
        }
        catch (JSONException _oJSONException) {
            logger.error((Object)_oJSONException.getStackTrace());
            throw new Exception("JSON\u83b7\u53d6\u672a\u8bfb\u6d88\u606f\u6570\u53c2\u6570\u9519\u8bef", _oJSONException);
        }
        return oMessage;
    }

    @Override
    public boolean setMessageRead(int messageType) throws Exception {
        String type = "";
        switch (messageType) {
            case 1: {
                type = "status";
                return this.getJSON(type);
            }
            case 2: {
                type = "cmt";
                return this.getJSON(type);
            }
            case 3: {
                return this.getJSON("mention_status") && this.getJSON("mention_cmt");
            }
            default: {
                throw new Exception("\u8bbe\u7f6e\u5df2\u8bfb\u7684Message Type\u9519\u8bef\uff011:\u5fae\u535a\u6570\uff1b2\uff1a\u8bc4\u8bba\u6570\uff1b3\uff1a@\u6211");
            }
        }
    }

    private boolean getJSON(String _type) throws Exception {
        Response oRes = null;
        try {
            oRes = this.m_oSinaWeibo.client.get(WeiboConfig.getValue((String)"baseURL") + "remind/unread_count.json", new PostParameter[]{new PostParameter("type", _type)});
            JSONObject oJSONObject = oRes.asJSONObject();
            if (oJSONObject.getBoolean("result")) {
                return true;
            }
        }
        catch (JSONException _oJSONException) {
            logger.error((Object)_oJSONException.getStackTrace());
            throw new Exception("JSON\u83b7\u53d6\u6e05\u96f6\u672a\u8bfb\u6d88\u606f\u7ed3\u679c\u9519\u8bef", _oJSONException);
        }
        catch (Exception _oWeiboException) {
            CMyException oCMyException = SinaErrorMessage.getCMyException(_oWeiboException);
            logger.error((Object)oCMyException.getMyMessage());
            throw oCMyException;
        }
        return false;
    }
}

