/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.util.uftp;

import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.uftp.FtpConfig;
import com.trs.infra.util.uftp.FtpConnection;
import com.trs.infra.util.uftp.PrintListener;
import com.trs.net.ftp.protocol.FtpClientPI;
import com.trs.net.ftp.protocol.ProtocolListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class FtpConnectionImpFtp
extends FtpConnection {
    private static Logger s_logger = Logger.getLogger(FtpConnectionImpFtp.class);
    private FtpClientPI m_oFtpClient;
    private byte[] m_baUpBuffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String verifyConfig() {
        FtpClientPI ftp = null;
        String sMessage = null;
        FtpConfig config = this.getFtpConfig();
        try {
            ftp = new FtpClientPI();
            if (!ftp.connect(config.getHost(), config.getPort(), null)) {
                sMessage = I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label1", "\u53ef\u80fd\u662f\u4e0d\u662f\u517c\u5bb9\u7684FTP\uff0c\u65e0\u6cd5\u8fde\u63a5\u5230\u670d\u52a1\u5668:") + config.getHost() + ":" + config.getPort() + ".";
            }
            ftp.setPassiveMode(config.getPassive());
            if (sMessage == null) {
                ftp.user(config.getUserName());
                if (ftp.getReplyCode1st() != 3) {
                    sMessage = I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label2", "\u65e0\u6548\u7684FTP\u7528\u6237\u540d:");
                }
            }
            if (sMessage == null) {
                ftp.pass(config.getPassWord());
                if (ftp.getReplyCode1st() != 2) {
                    sMessage = I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label3", "\u65e0\u6548\u7684FTP\u7528\u6237\u5bc6\u7801.");
                }
            }
            if (sMessage == null) {
                ftp.cwd(config.getRootPath());
                if (ftp.getReplyCode1st() != 2) {
                    sMessage = I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label4", "\u65e0\u6548\u7684\u7684\u76ee\u6807\u8def\u5f84,\u6ca1\u6709\u6743\u9650\u6216\u8005\u8def\u5f84\u4e0d\u5b58\u5728.");
                }
            }
            if (sMessage == null) {
                String sTempName = this.getTempFileName(null);
                ftp.mkd(sTempName);
                if (ftp.getReplyCode1st() == 2) {
                    ftp.rmd(sTempName);
                } else {
                    sMessage = I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label5", "FTP\u7528\u6237\u53ef\u80fd\u5bf9\u76ee\u6807\u670d\u52a1\u5668\u6216\u76ee\u6807\u8def\u5f84\u6ca1\u6709\u4e0a\u4f20\u7684\u6743\u9650.");
                }
            }
            if (sMessage == null) {
                InputStream is = null;
                try {
                    is = ftp.listFiles(null);
                    if (is != null) {
                        while (is.read() != -1) {
                        }
                    }
                }
                catch (Exception e) {
                    s_logger.info((Object)I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label6", "\u9a8c\u8bc1FTP\u914d\u7f6e\u65f6\u65e0\u6cd5\u5efa\u7acb\u6570\u636e\u901a\u9053"), (Throwable)e);
                }
                finally {
                    if (is != null) {
                        is.close();
                    } else {
                        sMessage = I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label7", "\u65e0\u6cd5\u5efa\u7acb\u4f20\u8f93\u6587\u4ef6\u7684\u6570\u636e\u901a\u9053,\u53ef\u80fd\u662f\u7f51\u7edc\u7684\u539f\u56e0.");
                    }
                }
                ftp.readReplyPending();
            }
            if (sMessage == null && !ftp.setDataType(73)) {
                sMessage = I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label8", "\u76ee\u6807\u670d\u52a1\u5668\u4e0d\u652f\u6301\u4e8c\u8fdb\u5236\u6587\u4ef6\u7684\u4f20\u8f93.");
            }
        }
        catch (Exception e) {
            s_logger.info((Object)I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label9", "\u9a8c\u8bc1FTP\u914d\u7f6e\u65f6,\u53d1\u751f\u9519\u8bef"), (Throwable)e);
            sMessage = e instanceof UnknownHostException ? I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label10", "\u65e0\u6cd5\u8bc6\u522b\u7684\u670d\u52a1\u5668\u5730\u5740:") + config.getHost() + "." : (e instanceof SocketTimeoutException ? I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label11", "\u8fde\u63a5\u5230\u76ee\u6807\u670d\u52a1\u5668\u8d85\u65f6:") + config.getHost() + "." : (e instanceof SocketException ? I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label12", "\u65e0\u6cd5\u8fde\u63a5\u5230\u76ee\u6807\u670d\u52a1\u5668:") + config.getHost() + "." : (e instanceof IOException ? I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label13", "\u8fde\u63a5\u5230\u670d\u52a1\u5668\u65f6,\u53d1\u751f\u8bfb\u5199\u9519\u8bef:") + e.getMessage() + "." : I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label14", "\u8fde\u63a5\u5230\u670d\u52a1\u5668\u65f6,\u53d1\u751f\u672a\u77e5\u9519\u8bef:") + e.getMessage() + ".")));
        }
        finally {
            if (ftp != null) {
                ftp.close();
            }
        }
        return sMessage;
    }

    @Override
    protected void open() throws Exception {
        if (this.m_oFtpClient != null && this.m_oFtpClient.isConnected()) {
            return;
        }
        if (this.m_oFtpClient == null) {
            this.m_oFtpClient = new FtpClientPI();
            if (s_logger.isDebugEnabled()) {
                this.m_oFtpClient.addProtocolListener((ProtocolListener)new PrintListener());
            }
        }
        FtpConfig config = this.getFtpConfig();
        this.m_oFtpClient.setPassiveMode(config.getPassive());
        if (!this.m_oFtpClient.connect(config.getHost(), config.getPort(), null)) {
            throw new WCMException(1000, I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label15", "FTP\u670d\u52a1\u5668\u94fe\u63a5\u5931\u8d25"));
        }
        this.m_oFtpClient.user(config.getUserName());
        if (this.m_oFtpClient.getReplyCode1st() != 3) {
            this.m_oFtpClient.close();
            throw new WCMException(1000, I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label16", "FTP\u670d\u52a1\u5668\u94fe\u63a5\u5931\u8d25:") + this.m_oFtpClient.getReplyString() + ".");
        }
        this.m_oFtpClient.pass(config.getPassWord());
        if (this.m_oFtpClient.getReplyCode1st() != 2) {
            this.m_oFtpClient.close();
            throw new WCMException(1000, I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label16", "FTP\u670d\u52a1\u5668\u94fe\u63a5\u5931\u8d25:") + this.m_oFtpClient.getReplyString() + ".");
        }
        if (!this.m_oFtpClient.setDataType(73)) {
            this.m_oFtpClient.close();
            throw new WCMException(1000, I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label16", "FTP\u670d\u52a1\u5668\u94fe\u63a5\u5931\u8d25:") + this.m_oFtpClient.getReplyString() + ".");
        }
        this.m_sHomePath = this.pwd();
    }

    private String pwd() throws Exception {
        this.assertOpen();
        this.m_oFtpClient.pwd();
        if (this.m_oFtpClient.getReplyCode1st() == 2) {
            String sReply = this.m_oFtpClient.getReplyLine();
            int index1 = sReply.indexOf(34);
            int index2 = sReply.lastIndexOf(34);
            if (index2 > index1 && index1 > 0) {
                return sReply.substring(index1 + 1, index2);
            }
        }
        throw new WCMException(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label17", "\u83b7\u53d6\u5f53\u524d\u76ee\u5f55\u5931\u8d25:") + this.m_oFtpClient.getReplyString() + ".");
    }

    @Override
    protected void close() {
        if (this.m_oFtpClient == null || !this.m_oFtpClient.isConnected()) {
            return;
        }
        this.m_oFtpClient.close();
        this.m_oFtpClient = null;
        this.m_baUpBuffer = null;
        this.m_sHomePath = null;
    }

    private void assertOpen() throws WCMException {
        if (this.m_oFtpClient != null && this.m_oFtpClient.isConnected()) {
            return;
        }
        throw new WCMException(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label18", "FTP\u8fde\u63a5\u610f\u5916\u5730\u5173\u95ed\uff01"));
    }

    @Override
    public void onIdle() throws Exception {
        this.assertOpen();
        this.m_oFtpClient.noop();
    }

    @Override
    public boolean isReadOnly() throws Exception {
        this.assertOpen();
        this.m_oFtpClient.cwd(this.getFtpConfig().getRootPath());
        if (this.m_oFtpClient.getReplyCode1st() != 2) {
            throw new WCMException(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label4", "\u65e0\u6548\u7684\u7684\u76ee\u6807\u8def\u5f84,\u6ca1\u6709\u6743\u9650\u6216\u8005\u8def\u5f84\u4e0d\u5b58\u5728:") + this.m_oFtpClient.getReplyString() + ".");
        }
        String sTempName = this.getTempFileName(null);
        this.m_oFtpClient.mkd(sTempName);
        if (this.m_oFtpClient.getReplyCode1st() == 2) {
            this.m_oFtpClient.rmd(sTempName);
            return false;
        }
        return true;
    }

    private void insureDirectory(String sPath) throws Exception {
        int iIndex1;
        if (sPath == null || sPath.length() == 0) {
            return;
        }
        int iReplyCode = this.m_oFtpClient.cwd(sPath);
        if (iReplyCode == 250) {
            return;
        }
        if ((iReplyCode == 550 || iReplyCode == 450) && (iIndex1 = sPath.lastIndexOf(47, sPath.length() - 2)) != -1) {
            String sToChange = sPath.substring(0, iIndex1 + 1);
            this.insureDirectory(sToChange);
            String sToCreate = sPath.substring(iIndex1 + 1, sPath.length() - 1);
            this.createDirectory(sToCreate);
            if (this.m_oFtpClient.cwd(sToCreate) == 250) {
                return;
            }
        }
        throw new WCMException(1006, I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label19", "\u8fdb\u5165\u76ee\u5f55[") + sPath + I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label20", "]\u9519\u8bef:") + this.m_oFtpClient.getReplyString());
    }

    private boolean createDirectory(String sPath) throws Exception {
        if (sPath == null || sPath.length() == 0) {
            return false;
        }
        this.m_oFtpClient.mkd(sPath);
        if (this.m_oFtpClient.getReplyCode1st() == 2) {
            return true;
        }
        s_logger.info((Object)("create directory '" + sPath + "' failed:" + this.m_oFtpClient.getReplyString()));
        return false;
    }

    private byte[] getUploadBuffer() {
        if (this.m_baUpBuffer == null) {
            this.m_baUpBuffer = this.m_oFtpClient != null && this.m_oFtpClient.getBufferSize() > 0 ? new byte[this.m_oFtpClient.getBufferSize()] : new byte[8192];
        }
        return this.m_baUpBuffer;
    }

    @Override
    public String toAbsolutePath(String sPath) throws Exception {
        this.assertOpen();
        this.m_oFtpClient.cwd(sPath);
        if (this.m_oFtpClient.getReplyCode1st() == 2) {
            this.m_oFtpClient.pwd();
            if (this.m_oFtpClient.getReplyCode1st() == 2) {
                String sReply = this.m_oFtpClient.getReplyLine();
                int index1 = sReply.indexOf(34);
                int index2 = sReply.lastIndexOf(34);
                if (index2 > index1 && index1 > 0) {
                    return sReply.substring(index1 + 1, index2);
                }
            }
        }
        throw new WCMException(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label21", "\u76f8\u5bf9\u8def\u5f84[") + sPath + I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label22", "]\u8f6c\u6362\u5931\u8d25:") + this.m_oFtpClient.getReplyString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean uploadFile(String sLocal, String sRemote) throws Exception {
        OutputStream os;
        InputStream is;
        Exception ex;
        block24: {
            boolean bl;
            block25: {
                this.assertOpen();
                int iIndex1 = sRemote.lastIndexOf(47);
                String sRemotePath = sRemote.substring(0, iIndex1 + 1);
                String sRemoteFile = sRemote.substring(iIndex1 + 1);
                this.insureDirectory(sRemotePath);
                ex = null;
                is = null;
                os = null;
                is = new FileService(sLocal).getInputStream();
                os = this.m_oFtpClient.storeFile(sRemoteFile, 0);
                if (os == null) break block24;
                int len = 0;
                byte[] buff = this.getUploadBuffer();
                while ((len = is.read(buff)) != -1) {
                    os.write(buff, 0, len);
                }
                is.close();
                is = null;
                os.close();
                os = null;
                this.m_oFtpClient.readReplyPending();
                int INDICATE_CODE = 150;
                if (this.m_oFtpClient.getReplyCode1st() != 2 && 150 != this.m_oFtpClient.getReplyCode()) break block24;
                bl = true;
                if (is == null) break block25;
                try {
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return bl;
        }
        try {
            try {
                StringBuffer sb = new StringBuffer(512);
                sb.append(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label23", "\u4e0a\u4f20\u6587\u4ef6["));
                sb.append(sLocal);
                sb.append(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label24", "]\u5230["));
                sb.append(sRemote);
                sb.append(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label25", "]\u5931\u8d25! "));
                sb.append(this.m_oFtpClient.getReplyString());
                throw new WCMException(1005, sb.toString());
            }
            catch (Exception e) {
                ex = e;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Throwable throwable) {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        if (ex != null) {
            throw ex;
        }
        return false;
    }

    @Override
    public boolean hasTheFile(String sPath) throws Exception {
        return false;
    }

    @Override
    public boolean deleteFile(String sPath) throws Exception {
        this.assertOpen();
        this.m_oFtpClient.rnfr(sPath);
        if (this.m_oFtpClient.getReplyCode1st() != 3) {
            return true;
        }
        this.m_oFtpClient.dele(sPath);
        if (this.m_oFtpClient.getReplyCode1st() == 2) {
            return true;
        }
        throw new WCMException(1013, I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label26", "\u5220\u9664\u6587\u4ef6[") + sPath + I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label20", "]\u9519\u8bef:") + this.m_oFtpClient.getReplyString());
    }

    @Override
    public boolean deleteDirectory(String sPath) throws Exception {
        this.assertOpen();
        if (sPath.endsWith("/")) {
            sPath = sPath.substring(0, sPath.length() - 1);
        }
        this.m_oFtpClient.rmd(sPath);
        if (this.m_oFtpClient.getReplyCode1st() == 2) {
            return true;
        }
        int iIndex1 = sPath.lastIndexOf(47);
        String sRemotePath = sPath.substring(0, iIndex1 + 1);
        String sRemote2Del = sPath.substring(iIndex1 + 1);
        String sRemote2Ren = this.getTempFileName(sRemote2Del);
        StringBuffer sb = new StringBuffer(1024);
        sb.append(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label27", "\u5220\u9664\u76ee\u5f55["));
        sb.append(sPath);
        sb.append(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label28", "]\u5931\u8d25,\u5c1d\u8bd5\u5c06["));
        sb.append(sRemote2Del);
        sb.append(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label29", "]\u91cd\u547d\u540d\u4e3a["));
        sb.append(sRemotePath);
        sb.append(sRemote2Ren);
        sb.append("],");
        int iReplyCode = this.m_oFtpClient.cwd(sRemotePath);
        if (iReplyCode != 250) {
            return false;
        }
        this.m_oFtpClient.rnfr(sRemote2Del);
        if (this.m_oFtpClient.getReplyCode1st() != 3) {
            return false;
        }
        this.m_oFtpClient.rnto(sRemote2Ren);
        if (this.m_oFtpClient.getReplyCode1st() != 2) {
            sb.append(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label31", "\u76ee\u5f55\u91cd\u547d\u540d\u4e3a["));
            sb.append(sRemote2Ren);
            sb.append(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label30", "]\u5931\u8d25:"));
            sb.append(this.m_oFtpClient.getReplyString() + ".");
            throw new WCMException(1013, sb.toString());
        }
        return true;
    }

    @Override
    public boolean renameFile(String sSourcePath, String sTargetFile) throws Exception {
        this.assertOpen();
        int iIndex1 = sSourcePath.lastIndexOf(47);
        String sRemotePath = sSourcePath.substring(0, iIndex1 + 1);
        String sRemote2Src = sSourcePath.substring(iIndex1 + 1);
        StringBuffer sb = new StringBuffer(1024);
        sb.append(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label32", "\u5c1d\u8bd5\u5c06[")).append(sSourcePath).append(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label29", "]\u91cd\u547d\u540d\u4e3a["));
        sb.append(sRemotePath).append(sTargetFile).append("],");
        int iReplyCode = this.m_oFtpClient.cwd(sRemotePath);
        if (iReplyCode != 250) {
            sb.append(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label19", "\u8fdb\u5165\u76ee\u5f55[")).append(sRemotePath).append(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label30", "]\u5931\u8d25:"));
            sb.append(this.m_oFtpClient.getReplyString());
            throw new WCMException(1013, sb.toString());
        }
        this.m_oFtpClient.rnfr(sRemote2Src);
        if (this.m_oFtpClient.getReplyCode1st() != 3) {
            sb.append(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label33", "\u91cd\u547d\u540d(RNFR)[")).append(sRemote2Src).append(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label30", "]\u5931\u8d25:"));
            sb.append(this.m_oFtpClient.getReplyString());
            throw new WCMException(1013, sb.toString());
        }
        this.m_oFtpClient.rnto(sTargetFile);
        if (this.m_oFtpClient.getReplyCode1st() != 2) {
            sb.append(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label34", "\u91cd\u547d\u540d(RNTO)[")).append(sTargetFile).append(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label30", "]\u5931\u8d25:"));
            sb.append(this.m_oFtpClient.getReplyString());
            throw new WCMException(1013, sb.toString());
        }
        return true;
    }

    @Override
    protected void toHomeDirectory() throws Exception {
        this.assertOpen();
        if (this.m_sHomePath == null) {
            return;
        }
        this.m_oFtpClient.cwd(this.m_sHomePath);
        if (this.m_oFtpClient.getReplyCode1st() == 2) {
            return;
        }
        throw new WCMException(I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label35", "\u6062\u590d\u521d\u59cb\u76ee\u5f55[") + this.m_sHomePath + I18NMessage.get(FtpConnectionImpFtp.class, "FtpConnectionImpFtp.label36", "]\u5931\u8d25") + this.m_oFtpClient.getReplyString());
    }

    public static void main(String[] args) {
        FtpConfig config = new FtpConfig();
        config.setProtocol("FTP");
        config.setHost("192.9.200.64");
        config.setPort(21);
        config.setUserName("trs");
        config.setPassWord("trs123");
        config.setRootPath("/export/home/trs/martin");
        config.setPassive(false);
        config.setMaxClient(10);
        FtpConnectionImpFtp ftp = new FtpConnectionImpFtp();
        ftp.setConfig(config);
        System.out.println(ftp.verifyConfig());
    }
}

