/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.support.file;

import com.trs.DreamFactory;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.presentation.plugin.PluginConfig;
import com.trs.wcm.photo.IImageLibConfig;
import com.trs.wcm.photo.impl.ImageMagickCmd;
import com.trs.wcm.photo.impl.MagicImageImpl;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class FileHelper {
    private static Logger logger = Logger.getLogger(FileHelper.class);
    private static final Set IMAGE_SUFFIX_SET = new HashSet(8);
    private static final long MIN_FILE_SIZE = 10L;
    public static final long KB_MAX = 0x100000L;

    public static String makeAbsoluteFilePathOfImage(String _sImageFileName, int _nWidth) throws WCMException {
        String sFileName = CMyFile.extractFileName(_sImageFileName);
        FilesMan filesMan = FilesMan.getFilesMan();
        String sAbsoluteFilePath = filesMan.mapFilePath(sFileName, 0);
        String sFileExt = "";
        int nPos = sFileName.lastIndexOf(46);
        if (nPos > 0) {
            sFileExt = sFileName.substring(nPos + 1);
        }
        if (_nWidth > 0 && FileHelper.isImageFile(sFileExt)) {
            String sNewFileName = sAbsoluteFilePath + sFileName.substring(0, nPos) + "_" + _nWidth + "." + sFileExt;
            if (FileHelper.isValidFile(sNewFileName)) {
                return sNewFileName;
            }
            if (CMyFile.fileExists(sAbsoluteFilePath + sFileName)) {
                int nMaxTryTimes = 16;
                String sOriginalFile = sAbsoluteFilePath + sFileName;
                for (int i = nMaxTryTimes; i >= 0; --i) {
                    block11: {
                        try {
                            sNewFileName = FileHelper.scaleImage(sOriginalFile, sNewFileName, _nWidth);
                            if (CMyFile.fileExists(sNewFileName)) {
                                return sNewFileName;
                            }
                        }
                        catch (Exception e) {
                            if (i != 0) break block11;
                            throw new WCMException("Fail to scale image!", e);
                        }
                    }
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("Wait some millis to retry scale: " + sNewFileName));
                        }
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                logger.warn((Object)("Failed to generate the scale image: " + sNewFileName + ", the original file returned: " + sOriginalFile));
                return sOriginalFile;
            }
            logger.error((Object)("No such file: " + sAbsoluteFilePath + sFileName));
        }
        return sAbsoluteFilePath + sFileName;
    }

    private static boolean isValidFile(String fileName) {
        FileService file = new FileService(fileName);
        return file.exists() && file.isFile() && file.length() > 10L;
    }

    private static boolean isImageFile(String sFileExt) {
        return sFileExt != null && IMAGE_SUFFIX_SET.contains(sFileExt.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String scaleImage(String _sSrcImageFile, String _sDstImageFileName, int _nWidth) throws Exception {
        if (FileHelper.isValidFile(_sDstImageFileName)) {
            return _sDstImageFileName;
        }
        Class<FileHelper> clazz = FileHelper.class;
        synchronized (FileHelper.class) {
            IImageLibConfig m_libConf = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
            if (m_libConf.isCmdUsed()) {
                String sNewFileName = ImageMagickCmd.scale(_sSrcImageFile, _sDstImageFileName, _nWidth, true);
                if (!CMyFile.fileExists(sNewFileName)) {
                    System.err.println("\u8f6c\u6362\u540e\u7684\u56fe\u7247[" + sNewFileName + "]\u7adf\u7136\u4e0d\u5b58\u5728\uff01\uff01\uff01\uff01\uff01\uff01");
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return _sSrcImageFile;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return sNewFileName;
            }
            if (PluginConfig.isStartPhoto()) {
                String fn = CMyFile.extractFileName(_sSrcImageFile);
                MagicImageImpl oMagicImage = new MagicImageImpl();
                oMagicImage.initMagicImage(fn);
                ImageMagickCmd.ImageObj srcimg = new ImageMagickCmd.ImageObj();
                srcimg.setFilename(_sSrcImageFile);
                if (srcimg.width <= _nWidth) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return _sSrcImageFile;
                }
                int nHeigth = srcimg.height * _nWidth / srcimg.width;
                if (nHeigth == 0) {
                    nHeigth = 1;
                }
                oMagicImage.scaleImage(_nWidth, nHeigth);
                oMagicImage.writeImage(_sDstImageFileName);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return _sDstImageFileName;
            }
            FileService compressFile = new FileService(_sSrcImageFile);
            BufferedImage srcFile = ImageIO.read(compressFile.getInputStream());
            int nSrcHeight = srcFile.getHeight();
            int nSrcWidth = srcFile.getWidth();
            if (nSrcWidth <= _nWidth) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return _sSrcImageFile;
            }
            int width = _nWidth;
            int height = nSrcHeight * width / nSrcWidth;
            if (height == 0) {
                height = 1;
            }
            BufferedImage bImage = new BufferedImage(width, height, 1);
            bImage.getGraphics().drawImage(srcFile, 0, 0, width, height, null);
            OutputStream fos = null;
            int nMaxRepeatTimes = 5;
            while (--nMaxRepeatTimes >= 0 && !FileHelper.isValidFile(_sDstImageFileName)) {
                try {
                    fos = new FileService(_sDstImageFileName).getOutputStream();
                    ImageIO.write((RenderedImage)bImage, CMyFile.extractFileExt(_sDstImageFileName), fos);
                }
                catch (Throwable e) {
                    if (nMaxRepeatTimes == 0) {
                        throw new WCMException("Compress image failed ", e);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                finally {
                    if (fos == null) continue;
                    fos.close();
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return _sDstImageFileName;
        }
    }

    public static boolean validImageFile(String sFileAbsPath, int _minWidth, int _minHeight) {
        FileService file = new FileService(sFileAbsPath);
        if (!file.exists()) {
            return false;
        }
        int[] dimensions = FileHelper.getImageDimensions(sFileAbsPath);
        if (dimensions[0] < _minWidth) {
            return false;
        }
        return dimensions[1] >= _minHeight;
    }

    public static String makeNewZoomInFileName(String _sImageFileName, int _nWidth) throws WCMException {
        String sNewAbsoluteFilePath = FileHelper.makeAbsoluteFilePathOfImage(_sImageFileName, _nWidth);
        return CMyFile.extractFileName(sNewAbsoluteFilePath);
    }

    public static boolean isForbidFileExt(String fileName) {
        String strExt = CMyFile.extractFileExt(fileName).toUpperCase();
        if (CMyString.isEmpty(strExt)) {
            return false;
        }
        String strSuffixConfig = ConfigServer.getServer().getInitProperty("FILE_UPLOAD_SUFFIX_CONFIG");
        if (CMyString.isEmpty(strSuffixConfig)) {
            return true;
        }
        if ("FILE_UPLOAD_ALLOW_SUFFIX".equals(strSuffixConfig)) {
            String strAllowExt = ConfigServer.getServer().getInitProperty(strSuffixConfig);
            if (CMyString.isEmpty(strAllowExt)) {
                return true;
            }
            strAllowExt = strAllowExt.toUpperCase().trim();
            return ("," + strAllowExt + ",").indexOf("," + strExt + ",") < 0;
        }
        if ("FILE_UPLOAD_FORBIDEN_SUFFIX".equals(strSuffixConfig)) {
            String strForbidExt = ConfigServer.getServer().getInitProperty(strSuffixConfig);
            if (CMyString.isEmpty(strForbidExt)) {
                return false;
            }
            strForbidExt = strForbidExt.toUpperCase().trim();
            return ("," + strForbidExt + ",").indexOf("," + strExt + ",") > 0;
        }
        return true;
    }

    public static int[] getImageDimensions(String sFileAbsPath) {
        int nFileHeight;
        int nFileWidth;
        block8: {
            int[] aResult = new int[]{0, 0};
            FileService file = new FileService(sFileAbsPath);
            if (!file.exists()) {
                return aResult;
            }
            nFileWidth = 0;
            nFileHeight = 0;
            IImageLibConfig m_libConf = (IImageLibConfig)DreamFactory.createObjectById("IImageLibConfig");
            try {
                BufferedImage srcFile;
                if (m_libConf.isCmdUsed()) {
                    ImageMagickCmd.ImageObj originalImage = new ImageMagickCmd.ImageObj();
                    originalImage.setFilename(sFileAbsPath);
                    nFileWidth = originalImage.width;
                    nFileHeight = originalImage.height;
                    break block8;
                }
                if (PluginConfig.isStartPhoto()) {
                    String fn = CMyFile.extractFileName(sFileAbsPath);
                    MagicImageImpl oMagicImage = new MagicImageImpl();
                    oMagicImage.initMagicImage(fn);
                    ImageMagickCmd.ImageObj srcimg = new ImageMagickCmd.ImageObj();
                    srcimg.setFilename(sFileAbsPath);
                    nFileWidth = srcimg.width;
                    nFileHeight = srcimg.height;
                    break block8;
                }
                FileService imageFile = new FileService(sFileAbsPath);
                try {
                    srcFile = ImageIO.read(imageFile.getInputStream());
                }
                catch (Exception e) {
                    logger.warn((Object)("\u8bfb\u53d6\u6587\u4ef6[" + sFileAbsPath + "]\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)e);
                    return aResult;
                }
                if (srcFile == null) {
                    return aResult;
                }
                nFileWidth = srcFile.getWidth();
                nFileHeight = srcFile.getHeight();
            }
            catch (Exception ex) {
                logger.warn((Object)("\u8bfb\u53d6\u56fe\u7247[" + sFileAbsPath + "]\u7684\u5bbd\u9ad8\u51fa\u73b0\u5f02\u5e38\uff01"), (Throwable)ex);
                return aResult;
            }
        }
        return new int[]{nFileWidth, nFileHeight};
    }

    public static String convertFileSize(long _nFileLength) {
        DecimalFormat df = new DecimalFormat("###.##");
        if (_nFileLength < 0x100000L) {
            float f = (float)_nFileLength / 1024.0f;
            return df.format(new Float(f).doubleValue()) + "KB";
        }
        float f = (float)_nFileLength / 1048576.0f;
        return df.format(new Float(f).doubleValue()) + "MB";
    }

    static {
        IMAGE_SUFFIX_SET.add("png");
        IMAGE_SUFFIX_SET.add("jpg");
        IMAGE_SUFFIX_SET.add("jpeg");
        IMAGE_SUFFIX_SET.add("gif");
        IMAGE_SUFFIX_SET.add("bmp");
    }
}

