/*
 * Decompiled with CFR 0.152.
 */
package com.trs.index.domain;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.IEventAfterPublishContent;
import com.trs.components.common.publish.domain.publisher.PublishPageContext;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.index.domain.IndexMrg;
import com.trs.index.util.IndexUtil;
import com.trs.index.vo.IndexField;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import org.apache.log4j.Logger;

public class PublisherForIndex
implements IEventAfterPublishContent {
    private static Logger logger = Logger.getLogger(PublisherForIndex.class);

    @Override
    public void onSuccess(IPublishContent _content, String _sPageURL, PublishPageContext _oPageContext) throws WCMException {
        String isearcherSericeClass = "";
        try {
            isearcherSericeClass = ConfigServer.getServer().getSysConfigValue("TRS_SEARCHER", "SearchBySqlService");
        }
        catch (WCMException e) {
            logger.error((Object)"\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u9879TRS_SEARCHER\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
        if (!"SearchByLuceneService".equalsIgnoreCase(isearcherSericeClass.trim())) {
            return;
        }
        Document document = null;
        CMSObj content = _content.getSubstance();
        CMSObj folderObj = _content.getFolder().getSubstance();
        if (!(folderObj instanceof Channel)) {
            folderObj = ((Document)content).getChannel();
        }
        if (content instanceof Document) {
            document = (Document)content;
            Channel channel = (Channel)folderObj;
            ChnlDoc chnlDoc = ChnlDoc.findByDocAndChnl(document, channel);
            IndexField indexField = new IndexField();
            IndexUtil.fillIndexField(indexField, document);
            IndexUtil.fillIndexField(indexField, channel);
            IndexUtil.fillIndexField(indexField, chnlDoc);
            IndexMrg mrg = new IndexMrg();
            mrg.updateIndex(indexField, true, IndexUtil.INDEX_UPD);
        }
    }

    @Override
    public void onFail(IPublishContent _content, String _sPageURL, PublishPageContext _oPageContext) throws WCMException {
    }
}

