/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagParserFolderBase;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;

public class WCMTagParserWebSite
extends TagParserFolderBase {
    private static final int ROOT_DOMAIN = 1;
    private static final int DATA_COUNT = 100;

    @Override
    protected String[] parseHostSpecialProperty(int propertyId, PublishTagContext _context) throws WCMException {
        if (this.m_host == null) {
            return null;
        }
        WebSite webSite = (WebSite)this.m_host;
        IPublishElement publishElement = PublishElementFactory.makeElementFrom(webSite);
        WCMFolderPublishConfig config = new WCMFolderPublishConfig((IPublishFolder)publishElement);
        switch (propertyId) {
            case 1: {
                return this.parseProperty(config.getRootDomain(), _context);
            }
            case 100: {
                return this.parseDataCount(_context);
            }
        }
        return null;
    }

    @Override
    protected void registerHostSpecialProperties() {
        this.registerHostSpecialProperty("RootDomain", 1);
        this.registerHostSpecialProperty("_DATACOUNT", 100);
    }

    @Override
    public TagBeanInfo getBeanInfo() {
        return null;
    }

    @Override
    protected CMSObj findHost(PublishTagContext _context) throws WCMException {
        if (this.m_host != null) {
            return this.m_host;
        }
        int nSiteId = _context.getAttribute("Id", 0);
        if (nSiteId > 0) {
            return WebSite.findById(nSiteId);
        }
        IPublishElement upperHost = _context.getUpperHost();
        CMSObj obj = upperHost.getSubstance();
        if (obj instanceof WebSite) {
            return obj;
        }
        obj = _context.getRoot().getSubstance();
        if (obj instanceof WebSite) {
            return obj;
        }
        throw new WCMException(I18NMessage.get(WCMTagParserWebSite.class, "WCMTagParserWebSite.label1", "\u4e0d\u652f\u6301\u7684\u4f7f\u7528\u573a\u666f\uff01[Class=") + obj.getClass() + "]");
    }

    protected String[] parseDataCount(PublishTagContext _context) throws WCMException {
        WCMFilter filter = null;
        filter = new WCMFilter("WCMChnlDoc", "WCMChnlDoc.SiteId=?", "");
        filter.addSearchValues(this.m_host.getId());
        String sExtraWhere = _context.getAttribute("COUNTWHERE");
        if (CMyString.isEmpty(sExtraWhere)) {
            filter.setWhere(filter.getWhere() + " and WCMCHNLDOC.DOCSTATUS=?");
            filter.addSearchValues(10);
        } else {
            filter.setWhere(filter.getWhere() + " and " + sExtraWhere);
        }
        if (_context.getAttribute("Today", false)) {
            String sWhere = filter.getWhere() + " and (WCMChnlDoc.DocRelTime>=? and WCMChnlDoc.DocRelTime<=?)";
            filter.setWhere(sWhere);
            CMyDateTime dtEnd = CMyDateTime.now();
            CMyDateTime dtStart = new CMyDateTime();
            try {
                dtStart.setDateTimeWithString(dtEnd.toString("yyyy-MM-dd 00:00:00"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            filter.addSearchValues(dtStart);
            filter.addSearchValues(dtEnd);
        }
        DBManager dbMgr = DBManager.getDBManager();
        int nResult = dbMgr.sqlExecuteCountQuery(filter);
        return new String[]{String.valueOf(nResult)};
    }
}

