/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.publisher.PublishPathCompass;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.domain.tagparser.ITagParser;
import com.trs.components.common.publish.domain.tagparser.TagBeanAttrInfo;
import com.trs.components.common.publish.domain.tagparser.TagBeanInfo;
import com.trs.components.common.publish.domain.tagparser.TagItem;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.TemplateQuote;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.html.HtmlUtil;

public class WCMTagParserMapArea
implements ITagParser {
    private static TagBeanInfo s_TagBeanInfo = null;

    @Override
    public TagBeanInfo getBeanInfo() {
        if (s_TagBeanInfo == null) {
            TagBeanInfo tbi = new TagBeanInfo();
            tbi.setName("TRS_MAPAREA");
            tbi.setDesc("TRS_MAPAREA");
            TagBeanAttrInfo tbai = null;
            tbai = new TagBeanAttrInfo();
            tbai.setName("ISURLABS");
            tbai.setType(TagBeanAttrInfo.Type.STRING);
            tbai.setDefaultValue("false");
            tbi.addAttrInfo(tbai);
            tbai.setName("PUBLISHDATE");
            tbai.setDesc("PUBLISHDATE");
            tbai.setType(TagBeanAttrInfo.Type.INTEGER);
            tbai.setDefaultValue("0");
            tbai.setRequired(false);
            tbi.addAttrInfo(tbai);
            s_TagBeanInfo = tbi;
        }
        return s_TagBeanInfo;
    }

    @Override
    public void setTagItem(TagItem _item) {
    }

    @Override
    public TemplateQuote[] analyzeQuotes(IPublishFolder _root) {
        return null;
    }

    @Override
    public String[] parse(PublishTagContext _context) throws WCMException {
        IPublishElement host = _context.getUpperHost();
        if (host == null || !(host instanceof IPublishContent)) {
            return null;
        }
        CMSObj hostDoc = host.getSubstance();
        StringBuffer sbWhere = new StringBuffer(64);
        sbWhere.append("PageNum=? AND Not DocId=? ");
        WCMFilter filter = new WCMFilter("WCMDOCUMENT", "", "DocId", "DocId,Map,DocTitle,DocChannel,DocType,CrTime");
        filter.addSearchValues(0, hostDoc.getPropertyAsString("PageNum"));
        filter.addSearchValues(1, hostDoc.getId());
        int nPublishedDate = _context.getAttribute("PUBLISHDATE", 0);
        if (nPublishedDate >= 0) {
            sbWhere.append(" AND PublishDate=? ");
            CMyDateTime today = CMyDateTime.now();
            try {
                today.dateAdd(3, -nPublishedDate);
            }
            catch (Exception exception) {
                // empty catch block
            }
            filter.addSearchValues(2, today.toString("yyyy.MM.dd"));
        }
        filter.setWhere(sbWhere.toString());
        sbWhere = null;
        Documents docs = new Documents(null);
        docs.open(filter);
        if (docs.isEmpty()) {
            return null;
        }
        StringBuffer result = new StringBuffer(128);
        result.append("<script>");
        result.append("var TRSWCM_MAPAREA_COORDS = [];");
        PublishPathCompass compass = _context.getPathCompass();
        boolean zRelativeUrl = !_context.getAttribute("ISURLABS", false);
        String linkUrl = null;
        String pagePath = _context.getPageHttpPath();
        IPublishContent content = null;
        IPublishFolder folder = null;
        for (int i = 0; i < docs.size(); ++i) {
            Document doc = (Document)docs.getAt(i);
            if (doc == null) continue;
            result.append("TRSWCM_MAPAREA_COORDS.push");
            result.append("({");
            result.append("areaCoords:'");
            result.append(doc.getProperty("MAP")).append("'");
            result.append(',');
            content = PublishElementFactory.makeContentFrom(doc, folder);
            if (folder == null) {
                folder = content.getFolder();
            }
            linkUrl = compass.getHttpUrl(content, 0);
            if (zRelativeUrl) {
                linkUrl = HtmlUtil.calRelativePath(linkUrl, pagePath);
            }
            result.append("areaHref:'").append(linkUrl).append("'");
            result.append("});");
        }
        result.append("</script>");
        return new String[]{result.toString()};
    }

    public void clear() {
    }

    public static void main(String[] args) {
    }
}

