/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish.tagparser;

import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.domain.publisher.PublishTagContext;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.tagparser.SimpleDoc;
import com.trs.components.wcm.publish.tagparser.SimpleDocComparator;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class RelNewsHelper {
    private static final int MAX_NUM_DEFAULT = 20;

    RelNewsHelper() {
    }

    public static Documents getDocuments(PublishTagContext _context, String _sDocFields) throws WCMException {
        Document doc = null;
        IPublishElement upperHost = _context.getUpperHost();
        if (!(upperHost instanceof IPublishContent)) {
            throw new WCMException("TRS_RELNEWS\u53ea\u80fd\u5e94\u7528\u5230\u6587\u6863\u4e0a!\u5f53\u524d\u5bf9\u8c61\u662f[" + upperHost.getInfo() + "]");
        }
        try {
            doc = (Document)upperHost.getSubstance();
        }
        catch (ClassCastException ex) {
            throw new WCMException("TRS_RELNEWS\u53ea\u80fd\u5e94\u7528\u5230\u6587\u6863\u4e0a!\u76f8\u5173\u5bf9\u8c61\u662f\uff1a[" + upperHost.getSubstance() + "]", ex);
        }
        String sMode = _context.getAttribute("MODE");
        if (CMyString.isEmpty(sMode)) {
            sMode = "USERDEF";
        }
        int nDocId = doc.getId();
        int nMaxNum = _context.getAttribute("NUM", 20);
        boolean zRelation = false;
        String sWords = doc.getKeywords();
        String[] arWords = null;
        int nMode = ModeHelper.getMode(sMode);
        switch (nMode) {
            case 0: {
                zRelation = true;
                if (CMyString.isEmpty(sWords)) break;
                arWords = sWords.split(";");
                break;
            }
            case 10: 
            case 20: {
                if (CMyString.isEmpty(sWords)) {
                    return null;
                }
                arWords = sWords.split(";");
                break;
            }
            case 30: {
                zRelation = true;
                break;
            }
        }
        Statement pstmt = null;
        Connection conn = null;
        ResultSet rs = null;
        DBManager dbmanager = DBManager.getDBManager();
        PreparedStatement pstmt4Doc = null;
        String relationSql = "select relation.reldocid,entity.modal,entity.chnlid from wcmrelation relation, wcmchnldoc entity where entity.chnlid=relation.channelid and entity.docid=relation.reldocid and entity.docstatus=10 and relation.docid=? order by relation.sern asc";
        int nSiteId = _context.getPageFolder().getRoot().getId();
        if (_context.getAttribute("MULTISITE", false)) {
            nSiteId = 0;
        }
        int nChnlId = 0;
        String sChnlId = _context.getAttribute("CHNLID");
        if (!CMyString.isEmpty(sChnlId)) {
            if ("self".equals(sChnlId.toLowerCase())) {
                nChnlId = _context.getPageFolder().getId();
            } else {
                try {
                    nChnlId = Integer.parseInt(sChnlId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        String keywordSql = "select relkeywords.docid from wcmdockeyword relkeywords,wcmchnldoc entity where ";
        keywordSql = keywordSql + "relkeywords.docid=entity.docid and entity.docstatus=10 and relkeywords.dockeyword=? ";
        if (nChnlId > 0) {
            keywordSql = keywordSql + " and entity.chnlid=?";
        } else if (nSiteId > 0) {
            keywordSql = keywordSql + " and entity.srcsiteid=?";
        }
        keywordSql = keywordSql + " order by relkeywords.doccrtime desc,relkeywords.dockeywordorder asc";
        String docsql = "select ";
        docsql = CMyString.isEmpty(_sDocFields) ? docsql + "docid,doctitle,cruser,crtime,docreltime,titlecolor,doctype,doclink,docfilename,docchannel" : docsql + _sDocFields;
        docsql = docsql + " from wcmdocument where docid=? and docstatus=10";
        HashSet duptitleSet = new HashSet(nMaxNum);
        try {
            conn = dbmanager.getConnection();
            pstmt4Doc = conn.prepareStatement(docsql);
            int ix = 1;
            Documents docs = new Documents(User.getSystem());
            ArrayList<SimpleDoc> result4sort = new ArrayList<SimpleDoc>(nMaxNum);
            boolean zSorted = _context.getAttribute("SORTBYRELTIME", false);
            if (zRelation) {
                pstmt = conn.prepareStatement(relationSql);
                pstmt.setFetchSize(nMaxNum);
                pstmt.setMaxRows(nMaxNum + nMaxNum);
                pstmt.setInt(ix++, nDocId);
                rs = pstmt.executeQuery();
                while (rs.next() && nMaxNum >= 0) {
                    pstmt4Doc.setInt(1, rs.getInt(1));
                    Document document = RelNewsHelper.loadDoc(pstmt4Doc, duptitleSet);
                    if (document == null) continue;
                    Hashtable<String, Object> props = document.getProperties();
                    props.put("MODAL", rs.getObject(2));
                    props.put("FOLDERID", rs.getObject(3));
                    docs.addElement(document);
                    if (zSorted) {
                        CMyDateTime dtreltime = document.getReleaseTime();
                        long relt = 0L;
                        if (dtreltime != null && !dtreltime.isNull()) {
                            relt = 0L;
                        }
                        result4sort.add(new SimpleDoc(document.getKey(), relt));
                    }
                    --nMaxNum;
                }
                pstmt.close();
                rs.close();
            }
            if (nMaxNum > 0 && arWords != null && arWords.length > 0) {
                pstmt = conn.prepareStatement(keywordSql);
                int len = arWords.length;
                for (int i = 0; i < len && nMaxNum > 0; ++i) {
                    ix = 1;
                    pstmt.setFetchSize(nMaxNum + nMaxNum);
                    pstmt.setMaxRows(nMaxNum + nMaxNum);
                    pstmt.setString(ix++, arWords[i]);
                    if (nChnlId > 0) {
                        pstmt.setInt(ix++, nChnlId);
                    } else if (nSiteId > 0) {
                        pstmt.setInt(ix++, nSiteId);
                    }
                    rs = pstmt.executeQuery();
                    int nId = 0;
                    while (rs.next() && nMaxNum >= 0) {
                        nId = rs.getInt(1);
                        if (docs.indexOf(nId) != -1 || nId == nDocId) continue;
                        pstmt4Doc.setInt(1, nId);
                        Document document = RelNewsHelper.loadDoc(pstmt4Doc, duptitleSet);
                        if (document == null) continue;
                        docs.addElement(document);
                        --nMaxNum;
                        if (!zSorted) continue;
                        CMyDateTime dtreltime = document.getReleaseTime();
                        long relt = 0L;
                        if (dtreltime != null && !dtreltime.isNull()) {
                            relt = 0L;
                        }
                        result4sort.add(new SimpleDoc(document.getKey(), relt));
                    }
                    rs.close();
                }
            }
            if (zSorted) {
                Collections.sort(result4sort, new SimpleDocComparator());
                Vector idlist = docs.getIdList();
                idlist.clear();
                int size = result4sort.size();
                for (int i = 0; i < size; ++i) {
                    idlist.add(((SimpleDoc)result4sort.get((int)i))._key);
                }
                result4sort.clear();
            }
            Documents documents = docs;
            return documents;
        }
        catch (WCMException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WCMException(40, "\u83b7\u53d6\u76f8\u5173\u6587\u6863\u5931\u8d25", ex);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (pstmt4Doc != null) {
                try {
                    pstmt4Doc.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                dbmanager.freeConnection(conn);
            }
            duptitleSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Document loadDoc(PreparedStatement pstmt4Doc, Set duptitleSet) throws SQLException, WCMException {
        ResultSet rs = null;
        try {
            String doctitle;
            rs = pstmt4Doc.executeQuery();
            Document doc = null;
            if (rs.next() && !duptitleSet.contains(doctitle = rs.getString("doctitle"))) {
                duptitleSet.add(doctitle);
                doc = new Document();
                doc.readFromRs(rs, null);
            }
            Document document = doc;
            return document;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected static String makeMark(int length) {
        if (length == 1) {
            return "?";
        }
        StringBuffer buff = new StringBuffer(length + length);
        buff.append('?');
        for (int i = 1; i < length; ++i) {
            buff.append(",?");
        }
        return buff.toString();
    }

    private static class ModeHelper {
        private static Map MODES = new HashMap(4);

        private ModeHelper() {
        }

        static int getMode(String name) {
            Integer value = (Integer)MODES.get(name.toUpperCase());
            if (value != null) {
                return value;
            }
            return 30;
        }

        static {
            MODES.put("USERDEF", new Integer(30));
            MODES.put("RELWORDS", new Integer(20));
            MODES.put("KEYWORDS", new Integer(10));
            MODES.put("ALL", new Integer(0));
        }
    }
}

