/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.publish;

import com.trs.DreamFactory;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.components.wcm.publish.domain.PreNextDocumentsImpl;
import com.trs.components.wcm.publish.element.PublishContentDocumentImpl;
import com.trs.infra.common.WCMException;
import org.apache.log4j.Logger;

public class PreNextPageRefresher {
    private static final Logger LOG = Logger.getLogger(PreNextPageRefresher.class);
    private Document m_oDocument;
    private PublishServer m_oPublishServer;

    public PreNextPageRefresher(Document document) {
        this.m_oDocument = document;
    }

    public void refresh() throws WCMException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"enter refreshPreNextPages.");
        }
        this.m_oPublishServer = PublishServer.getInstance();
        this.refreshPreNext(this.m_oDocument.getChannel());
        DocumentMgr docmgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        Channels channels = docmgr.getQutoedChannels(this.m_oDocument, 3, null);
        if (channels == null || channels.isEmpty()) {
            return;
        }
        int size = channels.size();
        for (int i = 0; i < size; ++i) {
            Channel quoteChannel = (Channel)channels.getAt(i);
            if (quoteChannel == null || quoteChannel.isDeleted()) continue;
            this.refreshPreNext(quoteChannel);
        }
    }

    private void refreshPreNext(Channel channel) throws WCMException {
        PreNextDocumentsImpl preNextDocs;
        Documents[] docs;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("refresh prenext of: " + channel));
        }
        if ((docs = (preNextDocs = new PreNextDocumentsImpl()).getPreNextDocuments(channel, this.m_oDocument, 1, null)) != null) {
            this.refreshDocs(channel, docs[0]);
            this.refreshDocs(channel, docs[1]);
            docs[0] = null;
            docs[1] = null;
        }
    }

    private void refreshDocs(Channel channel, Documents docs) throws WCMException {
        if (docs == null || docs.isEmpty()) {
            return;
        }
        Document preDoc = (Document)docs.getAt(0);
        if (preDoc != null && 10 == preDoc.getStatusId()) {
            this.publishDoc(preDoc.getId(), channel);
        }
        docs.clear();
    }

    private void publishDoc(int _nDocId, Channel channel) throws WCMException {
        Document document = Document.findById(_nDocId, "DocId,DocTitle,DocChannel");
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(channel);
        PublishContentDocumentImpl content = new PublishContentDocumentImpl(document);
        content.setFolder(folder);
        this.m_oPublishServer.publishContent((IPublishContent)content, 8);
    }
}

