/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.persistent;

import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import java.util.ArrayList;
import java.util.List;

public class ChannelLoopValidator {
    private List idList = new ArrayList();

    public void validHasExistsChannel(Channel _channel) throws WCMException {
        Channel parent = _channel.getParent();
        if (parent == null) {
            return;
        }
        if (this.idList.indexOf(_channel.getKey()) > 0) {
            throw new WCMException(1104, I18NMessage.get(ChannelLoopValidator.class, "ChannelLoopValidator.label1", "\u9891\u9053\u7684\u7236\u9891\u9053\u662f\u8be5\u9891\u9053\u7684\u5b50\u9891\u9053!"));
        }
        this.idList.add(_channel.getKey());
        this.validHasExistsChannel(parent);
    }

    public void validEditModeChannel(Channel _currChannel) throws WCMException {
        if (!_currChannel.isChangeProperty("PARENTID")) {
            return;
        }
        int nParentIdNew = _currChannel.getNewPropertyAsInt("PARENTID", 0);
        if (nParentIdNew == _currChannel.getId()) {
            throw new WCMException(10, I18NMessage.get(ChannelLoopValidator.class, "ChannelLoopValidator.label2", "\u7236\u5b50\u5173\u7cfb\u5b58\u5728\u56de\u8def!"));
        }
        if (nParentIdNew == 0) {
            return;
        }
        Channel newParent = Channel.findById(nParentIdNew);
        if (newParent == null) {
            throw new WCMException(10, I18NMessage.get(ChannelLoopValidator.class, "ChannelLoopValidator.label3", "\u7236\u9891\u9053\u4e0d\u5b58\u5728"));
        }
        this.idList.add(_currChannel.getKey());
        this.validHasExistsChannel(newParent);
    }
}

