/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.components.wcm.content.persistent.DocReply;
import com.trs.components.wcm.content.persistent.DocReplys;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;

public class DocReplyMgr {
    private static Logger m_oLogger = Logger.getLogger((String)DocReplyMgr.class.getName());

    public void copyDocReplys(Document _fromDocument, Document _newDocument) throws WCMException {
        if (_fromDocument == null) {
            throw new WCMException(20, I18NMessage.get(DocReplyMgr.class, "DocReplyMgr.label1", "\u6587\u6863\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u590d\u5236\u6587\u6863\u56de\u590d\uff01"));
        }
        try {
            DocReplys docReplys = null;
            DocReply docReply = null;
            DocReply docReplyNew = null;
            docReplys = this.getReplys(_fromDocument);
            int nCount = docReplys.size();
            for (int i = 0; i < nCount; ++i) {
                docReply = (DocReply)docReplys.getAt(i);
                if (docReply == null) continue;
                docReplyNew = (DocReply)docReply.cloneToNewObj();
                this.saveDocReply(_newDocument, docReplyNew);
            }
        }
        catch (Exception ex) {
            try {
                _newDocument.delete(ContextHelper.getLoginUser());
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new WCMException(41, I18NMessage.get(DocReplyMgr.class, "DocReplyMgr.label2", "\u590d\u4e4b\u6587\u6863\u56de\u590d\u5931\u8d25\uff01"), ex);
        }
    }

    public void saveDocReply(Document _currDocument, DocReply _docReply) throws WCMException {
        if (_docReply == null) {
            return;
        }
        if (_currDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocReplyMgr.class, "DocReplyMgr.label3", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61,\u65e0\u6cd5\u4fdd\u5b58\u5176\u56de\u590d!"));
        }
        if (_docReply.isAddMode()) {
            _docReply.setDocId(_currDocument.getDocId());
            _docReply.insert(ContextHelper.getLoginUser());
        } else {
            _docReply.update(ContextHelper.getLoginUser());
        }
    }

    public DocReplys getReplys(Document _currDocument) throws WCMException {
        return this.getReplys(_currDocument, -1);
    }

    public DocReplys getReplys(Document _currDocument, int _nReplyType) throws WCMException {
        if (_currDocument == null) {
            throw new WCMException(10, I18NMessage.get(DocReplyMgr.class, "DocReplyMgr.label4", "\u65e0\u6548\u7684\u6587\u6863\u5bf9\u8c61,\u65e0\u6cd5\u83b7\u53d6\u5176\u56de\u590d!"));
        }
        String sWhere = "ReDocId=" + _currDocument.getId() + (_nReplyType == -1 ? "" : " and ReplyType=" + _nReplyType);
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        try {
            return DocReplys.openWCMObjs(ContextHelper.getLoginUser(), aFilter);
        }
        catch (WCMException ex) {
            m_oLogger.debug((Object)ex.getMessage());
            throw new WCMException(1100, I18NMessage.get(DocReplyMgr.class, "DocReplyMgr.label5", "\u83b7\u53d6\u5f53\u524d\u6587\u6863\u7684\u56de\u590d\u5931\u8d25!"), ex);
        }
    }
}

