/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.stat.HostObjHitsCount;
import com.trs.components.stat.IHitsCountHandler;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ChannelHitsCountHandler
implements IHitsCountHandler {
    private Map hostHitsCountMap;
    private String hitsTime;
    private Map specialMap;
    private static Logger logger = Logger.getLogger(ChannelHitsCountHandler.class);

    @Override
    public void handle(BaseObj obj, Map properties) throws WCMException {
        Channel channel;
        if (obj instanceof Document) {
            channel = ((Document)obj).getChannel();
        } else if (obj instanceof Channel) {
            channel = (Channel)obj;
        } else {
            return;
        }
        this.hitsTime = (String)properties.get("hitsTime");
        if (this.hostHitsCountMap == null) {
            this.hostHitsCountMap = new HashMap();
        }
        int nAllCount = 0;
        Integer allCount = (Integer)this.hostHitsCountMap.get(channel);
        if (allCount != null) {
            nAllCount = allCount;
        }
        int nCount = Integer.parseInt((String)properties.get("hitsCount"));
        nAllCount += nCount;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u8ffd\u52a0\u7684\u70b9\u51fb\u91cf\u60c5\u51b5\uff1a\nobj[" + channel + "],all[" + nAllCount + "],current[" + nCount + "]"));
        }
        this.hostHitsCountMap.put(channel, new Integer(nAllCount));
    }

    @Override
    public void notifyComplete() {
        if (this.hostHitsCountMap == null) {
            return;
        }
        for (Map.Entry entry : this.hostHitsCountMap.entrySet()) {
            Channel channel = (Channel)entry.getKey();
            Integer count = (Integer)entry.getValue();
            try {
                HostObjHitsCount hostHitsCount = new HostObjHitsCount();
                hostHitsCount.setHostId(channel.getId());
                hostHitsCount.setHostType(101);
                hostHitsCount.setObjCrTime(channel.getCrTime());
                hostHitsCount.setObjCrUser(channel.getCrUserName());
                hostHitsCount.setPropertyWithString("hitsTime", this.hitsTime);
                hostHitsCount.setSpecial(this.isSpecial(channel));
                hostHitsCount.setHitsCount(count);
                hostHitsCount.save();
            }
            catch (Exception e) {
                logger.error((Object)("\u8bbe\u7f6e\u680f\u76ee\u5bf9\u8c61[" + channel + "]\u7684\u70b9\u51fb\u91cf\u4fe1\u606f\u65f6\u5931\u8d25"), (Throwable)e);
            }
        }
    }

    private boolean isSpecial(BaseChannel host) throws WCMException {
        Boolean bIsSpecial;
        if (this.specialMap == null) {
            this.specialMap = new HashMap();
        }
        if ((bIsSpecial = (Boolean)this.specialMap.get(host)) != null) {
            return bIsSpecial;
        }
        DBManager dbMgr = DBManager.getDBManager();
        String strSQL = "select 1 from XWCMSPECIAL where HOSTTYPE = 101 and HOSTID=?";
        int nResult = dbMgr.sqlExecuteIntQuery(strSQL, new int[]{host.getId()});
        boolean bResult = nResult == 1;
        this.specialMap.put(host, new Boolean(bResult));
        return bResult;
    }
}

