/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.persistent;

import com.trs.cms.auth.persistent.User;
import com.trs.components.infoview.InfoViewConstants;
import com.trs.components.infoview.InfoViewHelper;
import com.trs.components.infoview.helper.InfoViewChnlDocFilterHelper;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViewDocument;
import com.trs.components.wcm.content.ViewDocument;
import com.trs.components.wcm.content.ViewDocuments;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.DebugTimer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class InfoViewDocuments
extends ViewDocuments {
    public static final String DEFAULT_DOCUMENT_SELECTFIELDS = "DocId,DocTitle,CrTime,CrUser,DocChannel";
    private static Logger logger = Logger.getLogger(InfoViewDocuments.class);
    private int m_nInfoViewId = 0;
    private InfoViewChnlDocFilterHelper m_oInfoViewChnlDocFilterHelper = null;
    private String m_sSelectFieldsFromInfoView = null;

    public InfoViewDocuments(User _currUser) {
        super(_currUser);
    }

    public void setInfoViewId(int _nInfoViewId) {
        this.m_nInfoViewId = _nInfoViewId;
    }

    public int getInfoViewId() {
        return this.m_nInfoViewId;
    }

    public InfoViewChnlDocFilterHelper getInfoViewChnlDocFilterHelper() throws WCMException {
        if (this.m_oInfoViewChnlDocFilterHelper == null) {
            this.m_oInfoViewChnlDocFilterHelper = new InfoViewChnlDocFilterHelper(this.getInfoViewId());
        }
        return this.m_oInfoViewChnlDocFilterHelper;
    }

    public InfoViewDocuments(User _currUser, int _initCapacity, int _incCapacity) {
        super(_currUser, _initCapacity, _incCapacity);
    }

    @Override
    protected String getDbTableName() {
        return "WCMCHNLDOC";
    }

    @Override
    public String getIdFieldName() {
        return "RECID";
    }

    @Override
    public Class getElementClass() {
        return InfoViewDocument.class;
    }

    @Override
    public BaseObjs newInstance() throws Exception {
        return new InfoViewDocuments(this.currUser);
    }

    public static InfoViewDocuments createNewInstance(User _currUser) throws WCMException {
        return (InfoViewDocuments)InfoViewDocuments.createInstance(_currUser, InfoViewDocuments.class);
    }

    @Override
    protected WCMFilter getHostFilter(Object _hostObject, WCMFilter _filter) throws WCMException {
        if (_hostObject != null) {
            if (_hostObject instanceof Channels) {
                _filter = this.getInfoViewChnlDocFilterHelper().makeChannelFilter((Channels)_hostObject, _filter, this.isFromRecycle());
            } else if (_hostObject instanceof Channel) {
                _filter = this.getInfoViewChnlDocFilterHelper().makeChannelFilter((Channel)_hostObject, _filter, true, this.isFromRecycle());
            } else if (_hostObject instanceof WebSite) {
                _filter = this.getInfoViewChnlDocFilterHelper().makeFilter((WebSite)_hostObject, _filter, true, this.isFromRecycle());
            } else if (_hostObject instanceof WebSites) {
                _filter = this.getInfoViewChnlDocFilterHelper().makeFilter((WebSites)_hostObject, _filter, true, this.isFromRecycle());
            }
        }
        if (this.getInfoViewId() > 0) {
            if (_filter == null) {
                _filter = new WCMFilter();
            }
            String sWhere = "";
            if (!CMyString.isEmpty(_filter.getWhere())) {
                sWhere = _filter.getWhere() + " and ";
            }
            sWhere = sWhere + "WCMChnlDoc.DocFlag=?";
            _filter.setWhere(sWhere);
            _filter.addSearchValues(this.getInfoViewId());
        }
        return _filter;
    }

    @Override
    protected boolean needDocumentFields() {
        return super.needDocumentFields() || this.needInfoViewFields();
    }

    private boolean needInfoViewFields() {
        return this.getInfoViewId() > 0 && !CMyString.isEmpty(this.getSelectFieldsFromInfoView());
    }

    @Override
    protected BaseObj createElementInstance() throws WCMException {
        return new InfoViewDocument(this.getPublicCache());
    }

    @Override
    protected boolean realLoadPageDocuments(int _pageIndex) throws WCMException {
        this.prepareSelectFields();
        boolean bLoadDocuments = true;
        if (super.needDocumentFields()) {
            bLoadDocuments = super.realLoadPageDocuments(_pageIndex);
        }
        return bLoadDocuments && this.realLoadInfoViewDocuments(_pageIndex);
    }

    private void prepareSelectFields() throws WCMException {
        if (CMyString.isEmpty(this.getSelectFieldsFromDocument()) && CMyString.isEmpty(this.getSelectFieldsFromInfoView())) {
            InfoView oInfoView = InfoView.findById(this.getInfoViewId());
            String sTrueTableName = this.getInfoViewTableName();
            String[] arrSelectFields = InfoViewHelper.splitSelectFields(oInfoView.getOutlineDBFields(), sTrueTableName);
            this.setSelectFieldsFromDocument(CMyString.showNull(arrSelectFields[0]));
            this.setSelectFieldsFromInfoView(CMyString.showNull(arrSelectFields[1]));
        }
    }

    private boolean realLoadInfoViewDocuments(int _pageIndex) throws WCMException {
        if (!this.needInfoViewFields()) {
            return true;
        }
        String strSQL = this.makeLoadPageInfoViewDocumentsSQL(_pageIndex);
        if (strSQL == null) {
            return false;
        }
        DebugTimer aTimer = new DebugTimer();
        Connection oConn = null;
        PreparedStatement oStmt = null;
        ResultSet rsData = null;
        ResultSetMetaData rsmdData = null;
        try {
            int nDocId;
            oConn = this.getDBManager().getConnection();
            oStmt = oConn.prepareStatement(strSQL);
            oStmt.setMaxRows(this.pageSize);
            if (this.pageSize > MAX_FETCH_SIZE) {
                oStmt.setFetchSize(MAX_FETCH_SIZE);
            } else {
                oStmt.setFetchSize(this.pageSize);
            }
            this.setPageInfoViewDocumentsPreStmtParams(_pageIndex, oStmt);
            aTimer.start();
            rsData = oStmt.executeQuery();
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] executeQuery from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + strSQL));
            }
            aTimer.start();
            while (rsData.next()) {
                ViewDocument[] pViewDocuments;
                if (rsmdData == null) {
                    rsmdData = rsData.getMetaData();
                }
                if ((pViewDocuments = this.getViewDocuments(nDocId = rsData.getInt(this.getInfoViewIdFieldName()))) == null) {
                    this.printErrorInfo(nDocId, strSQL, I18NMessage.get(InfoViewDocuments.class, "InfoViewDocuments.label1", "ViewDocument\u7f13\u51b2\u7ef4\u62a4\u6709\u95ee\u9898\uff1f\u6307\u5b9a\u7684DocId\u5bf9\u5e94\u7684ViewDocument\u4e0d\u80fd\u83b7\u5f97\uff01"));
                    continue;
                }
                ViewDocument currObject = pViewDocuments[0];
                currObject.readFromRs(rsData, rsmdData);
                int nCount = pViewDocuments.length;
                for (int i = 1; i < nCount; ++i) {
                    pViewDocuments[i].cloneDocumentProperties(currObject);
                }
            }
            aTimer.stop();
            if (logger.isDebugEnabled() && aTimer.getTime() > DEBUG_USE_TIME) {
                logger.debug((Object)("loadPage[PageSize=" + this.pageSize + "] get data from db use [" + aTimer.getTime() + "]ms"));
                logger.debug((Object)("strSQL:" + strSQL));
            }
            nDocId = 1;
            return nDocId != 0;
        }
        catch (SQLException ex) {
            throw new WCMException(40, I18NMessage.get(InfoViewDocuments.class, "InfoViewDocuments.label2", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + strSQL, ex);
        }
        catch (Exception ex) {
            throw new WCMException(0, I18NMessage.get(InfoViewDocuments.class, "InfoViewDocuments.label2", "\u88c5\u8f7d\u6307\u5b9a\u9875\u5931\u8d25\uff08") + this.getClass().getName() + ".loadPage)\uff1aSQL=" + strSQL, ex);
        }
        finally {
            if (rsData != null) {
                try {
                    rsData.close();
                }
                catch (Exception exception) {}
            }
            if (oStmt != null) {
                try {
                    oStmt.close();
                }
                catch (Exception exception) {}
            }
            if (oConn != null) {
                this.getDBManager().freeConnection(oConn);
            }
        }
    }

    private void setPageInfoViewDocumentsPreStmtParams(int _pageIndex, PreparedStatement stmt) throws SQLException {
        int nEnd;
        int nStart = this.getStartPos(_pageIndex);
        if (nStart >= (nEnd = this.getEndPos(nStart)) || nStart < 0) {
            return;
        }
        int i = nStart;
        int nParamIndex = 1;
        while (i < nEnd) {
            ViewDocument viewDocument = (ViewDocument)this.getAt(i);
            if (viewDocument == null) {
                this.printErrorInfo(this.getIdAt(i), null, I18NMessage.get(InfoViewDocuments.class, "InfoViewDocuments.label3", "setPageDocumentsPreStmtParams\u53d1\u73b0\u7a0b\u5e8f\u9519\u8bef\uff01"));
            } else {
                stmt.setInt(nParamIndex, viewDocument.getDocId());
            }
            ++i;
            ++nParamIndex;
        }
    }

    private String makeLoadPageInfoViewDocumentsSQL(int _pageIndex) {
        this.setSelectFieldsFromInfoView(this.getInfoViewIdFieldName() + "," + "InfoViewId" + "," + this.getSelectFieldsFromInfoView());
        String sFrom = this.getInfoViewTableName();
        String sWhere = this.makeLoadPageWhere(_pageIndex, this.getInfoViewIdFieldName());
        StringBuffer sbSQL = new StringBuffer(this.getSelectFieldsFromInfoView().length() + sFrom.length() + sWhere.length() + 21);
        sbSQL.append("select ");
        sbSQL.append(this.getSelectFieldsFromInfoView());
        sbSQL.append(" from ");
        sbSQL.append(sFrom);
        if (sWhere.length() > 0) {
            sbSQL.append(" where ");
            sbSQL.append(sWhere);
        }
        return sbSQL.toString();
    }

    private String getInfoViewIdFieldName() {
        return "DocumentId";
    }

    private String getInfoViewTableName() {
        return InfoViewConstants.makeTrueTableName(this.getInfoViewId());
    }

    public void setSelectFields(String _sSelectFieldFromChnlDoc, String _sSelectFieldsFromDocument, String _sSelectFieldFromInfoView) {
        this.setSelectFieldsFromChnlDoc(_sSelectFieldFromChnlDoc);
        this.setSelectFieldsFromDocument(_sSelectFieldsFromDocument);
        this.setSelectFieldsFromInfoView(_sSelectFieldFromInfoView);
    }

    public void setSelectFieldsFromInfoView(String _sSelectFieldFromInfoView) {
        this.m_sSelectFieldsFromInfoView = _sSelectFieldFromInfoView;
    }

    public String getSelectFieldsFromInfoView() {
        return this.m_sSelectFieldsFromInfoView;
    }

    public String toString() {
        StringBuffer sbResult = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            InfoViewDocument oDoc = (InfoViewDocument)this.getAt(i);
            sbResult.append("\n");
            sbResult.append(oDoc);
        }
        return sbResult.toString();
    }
}

