/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.impl.transport;

import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.impl.ClusterSenderBase;
import com.trs.infra.cluster.io.TransportTracer;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;

public class SenderByUDP
extends ClusterSenderBase {
    private static final Logger s_logger;
    public static final int DP_BUFFER_SIZE = 65536;
    private long sendBytes;
    private int sendBytesHalf;
    private DatagramSocket sendSocket;
    private DatagramPacket dataPacket;
    private TransportTracer transportTracer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.impl.transport.SenderByUDP");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public SenderByUDP() {
        super("SenderByUDP");
    }

    public Member getRemoteMember() {
        return null;
    }

    protected void sendMessage(ClusterMessage message) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Be to send message:" + message));
        }
        int retry = 0;
        while (retry < this.getMaxRetry()) {
            try {
                byte[] buffer = this.dataPacket.getData();
                int dataLength = message.flush(buffer, 0);
                DatagramPacket packet = this.dataPacket;
                packet.setAddress(message.getTargetAddress());
                packet.setPort(message.getTargetPort());
                packet.setLength(dataLength);
                this.sendSocket.send(packet);
                this.incSendBytes(dataLength);
                TransportTracer tracer = this.transportTracer;
                if (tracer == null) break;
                tracer.trace(buffer, 0, dataLength);
                break;
            }
            catch (Exception e) {
                s_logger.error((Object)("Send  '" + message + "' failed, retry=" + retry), (Throwable)e);
                ++retry;
            }
        }
    }

    protected long getSendBytes() {
        return this.sendBytes + (long)this.sendBytesHalf;
    }

    private final void incSendBytes(int value) {
        int temp = this.sendBytesHalf + value;
        if (temp > 0) {
            this.sendBytesHalf = temp;
            return;
        }
        this.sendBytesHalf = 0;
        this.sendBytes = this.sendBytes + (long)this.sendBytesHalf + (long)value;
    }

    protected void startup() {
        try {
            String path;
            InetAddress bind = this.getConfig().getInetUDPListenAddress();
            this.sendSocket = new DatagramSocket(new InetSocketAddress(bind, 0));
            this.sendSocket.setSendBufferSize(this.getConfig().getUDPBufferSize());
            byte[] buffer = new byte[this.getConfig().getUDPBufferSize()];
            this.dataPacket = new DatagramPacket(buffer, buffer.length);
            if (s_logger.isDebugEnabled() && (path = this.getConfig().getTracerDirectory()) != null) {
                String file = this.getName();
                this.transportTracer = TransportTracer.newTracer(path, file);
                if (this.transportTracer != null) {
                    this.transportTracer = this.transportTracer.initialize(this.sendSocket, true);
                }
            }
        }
        catch (IOException e) {
            String info = "SenderByUDP startup failed";
            s_logger.fatal((Object)info, (Throwable)e);
            throw new RuntimeException(info, e);
        }
    }

    protected void cleanup() {
        try {
            this.sendSocket.close();
        }
        catch (Exception e) {
            s_logger.error((Object)"SenderByUDP cleanup failed", (Throwable)e);
        }
        this.dataPacket = null;
        this.sendSocket = null;
    }
}

