/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.impl;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import com.trs.infra.cluster.ClusterContext;
import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.Extension;
import com.trs.infra.cluster.ExtensionManager;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.ack.ACKMessage;
import com.trs.infra.cluster.impl.ClusterMessageQueue;
import com.trs.infra.cluster.impl.ExtensionMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExtensionManagerDefault
implements ExtensionManager {
    private static final Logger s_logger;
    private ClusterContext context;
    private final Map extensionsMap = new ConcurrentHashMap();
    private final ClusterMessageQueue messagesQueue = new ClusterMessageQueue(4096);
    private int workerCount = 5;
    private final List workersList = new ArrayList(this.workerCount);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.impl.ExtensionManagerDefault");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    public void start() {
        int i = this.workersList.size();
        while (this.workersList.size() < this.workerCount) {
            Worker worker = new Worker(i);
            worker.start();
            this.workersList.add(worker);
            ++i;
        }
    }

    public void close() {
        Iterator itr = this.workersList.iterator();
        while (itr.hasNext()) {
            ((Worker)itr.next()).terminate();
        }
        this.workersList.clear();
    }

    public final int getWorkerCount() {
        return this.workerCount;
    }

    public final void setWorkerCount(int workerCount) {
        this.workerCount = workerCount;
    }

    public final ClusterContext getClusterContext() {
        return this.context;
    }

    public final void setClusterContext(ClusterContext clusterContext) {
        this.context = clusterContext;
    }

    public Extension getExtension(String _guid) {
        if (_guid == null) {
            return null;
        }
        return (Extension)this.extensionsMap.get(_guid);
    }

    public boolean hasExtension(String _guid) {
        if (_guid == null) {
            return false;
        }
        return this.extensionsMap.containsKey(_guid);
    }

    public synchronized Extension addExtension(Extension ext) {
        if (ext == null) {
            return null;
        }
        String _guid = ext.getExtensionId();
        if (_guid == null) {
            s_logger.error((Object)("Invalid extension:" + ext + ",with _guid: null"));
            return null;
        }
        Extension oldExtension = (Extension)this.extensionsMap.get(_guid);
        if (oldExtension != null && oldExtension == ext) {
            s_logger.warn((Object)("To add reduplicate extension:" + ext));
            return null;
        }
        this.extensionsMap.put(_guid, ext);
        s_logger.info((Object)("Add extension:" + ext + ",and replace:" + oldExtension));
        return oldExtension;
    }

    public synchronized boolean removeExtension(Extension ext) {
        if (ext == null) {
            return false;
        }
        String _guid = ext.getExtensionId();
        if (_guid == null) {
            s_logger.error((Object)("Invalid extension:" + ext + ",with _guid: null"));
            return false;
        }
        Extension oldExtension = (Extension)this.extensionsMap.remove(_guid);
        if (oldExtension != null) {
            s_logger.info((Object)("Remove extension:" + ext));
            return true;
        }
        s_logger.error((Object)("Not found extension:" + ext));
        return false;
    }

    public int getAcceptedMessage() {
        return 127;
    }

    private final ExtensionMessage acceptInternal(ClusterMessage msg, Member sender) {
        ExtensionMessage extmsg;
        if (msg instanceof ExtensionMessage && (extmsg = (ExtensionMessage)msg) != null) {
            return extmsg;
        }
        return null;
    }

    public void receive(ClusterMessage msg, Member sender) {
        ExtensionMessage extmsg = this.acceptInternal(msg, sender);
        if (extmsg == null) {
            return;
        }
        String guid = extmsg.getExtensionId();
        if (guid == null) {
            s_logger.error((Object)"Invalid extension message without 'GUID'");
            return;
        }
        Extension extension = this.getExtension(guid);
        if (extension == null) {
            s_logger.error((Object)("Invalid extension id:" + guid));
            return;
        }
        if (extmsg.isDelayReceive()) {
            this.process(extension, extmsg, sender);
        } else {
            extmsg.setExtension(extension);
            extmsg.setSender(sender);
            this.messagesQueue.put(extmsg);
        }
    }

    private void process(Extension extension, ExtensionMessage msg, Member sender) {
        Object result = extension.callByCluster(msg.getArguments(), sender);
        if (msg.isNeedACK()) {
            ACKMessage ackMsg = new ACKMessage();
            ackMsg.setAckFor(msg.getSequence());
            if (result != null && result instanceof Serializable) {
                ackMsg.setValue((Serializable)result);
            }
            this.context.send((ClusterMessage)ackMsg, sender);
        }
    }

    public void sendToCluster(String guid, Serializable args) {
        ExtensionMessage message = new ExtensionMessage();
        message.setExtensionId(guid);
        message.setArguments(args);
        this.context.send(message);
    }

    public void sendToCluster(String guid, Serializable args, Member member) {
        ExtensionMessage message = new ExtensionMessage();
        message.setExtensionId(guid);
        message.setArguments(args);
        this.context.send((ClusterMessage)message, member);
    }

    public void sendToCluster(String guid, Serializable args, Member[] members) {
        ExtensionMessage message = new ExtensionMessage();
        message.setExtensionId(guid);
        message.setArguments(args);
        this.context.send((ClusterMessage)message, members);
    }

    private class Worker
    extends Thread {
        private boolean zRunning = true;

        public Worker(int num) {
            this.setName("ExtensionManager$Worker$_" + num);
            this.setDaemon(true);
        }

        public void run() {
            while (this.zRunning) {
                ExtensionMessage msg = (ExtensionMessage)ExtensionManagerDefault.this.messagesQueue.get();
                if (msg == null) {
                    try {
                        Worker.sleep(10L);
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                ExtensionManagerDefault.this.process(msg.getExtension(), msg, msg.getSender());
            }
        }

        private void terminate() {
            this.zRunning = false;
        }
    }
}

