/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cis4.util;

import com.trs.cis4.util.CloseUtil;
import com.trs.cis4.util.FileUtil;
import com.trs.cis4.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.apache.tools.zip.ZipOutputStream;

public class ZipUtil {
    public static void zip(String srcPath, String zipFile) throws IOException {
        ZipUtil.checkZipAvalible(srcPath, zipFile);
        ZipOutputStream zos = new ZipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(zipFile)));
        ZipUtil.addToZip(srcPath, zos);
        zos.close();
    }

    public static void zip(List srcPaths, String zipFile) throws IOException {
        if (srcPaths == null || srcPaths.size() == 0) {
            throw new RuntimeException("\u6ca1\u6709\u6307\u5b9a\u538b\u7f29\u6e90\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
        }
        int i = 0;
        while (i < srcPaths.size()) {
            String filename = (String)srcPaths.get(i);
            ZipUtil.checkZipAvalible(filename, zipFile);
            ++i;
        }
        ZipOutputStream zos = new ZipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(zipFile)));
        int i2 = 0;
        while (i2 < srcPaths.size()) {
            String filename = (String)srcPaths.get(i2);
            ZipUtil.addToZip(filename, zos);
            ++i2;
        }
        zos.close();
    }

    public static List unzip(File file, String unzipDirPath) throws IOException {
        return ZipUtil.unzip(file, unzipDirPath, false);
    }

    public static List unzip(String filePath, String unzipDirPath) throws IOException {
        return ZipUtil.unzip(new File(filePath), unzipDirPath, false);
    }

    public static List unzip(String filePath, String unzipDirPath, boolean flat) throws IOException {
        return ZipUtil.unzip(new File(filePath), unzipDirPath, flat);
    }

    private static void checkZipAvalible(String srcPath, String zipFile) {
        if (StringUtil.isEmpty(srcPath) || StringUtil.isEmpty(zipFile)) {
            throw new RuntimeException("\u6ca1\u6709\u6307\u5b9a\u538b\u7f29\u6e90\u6587\u4ef6\u6216\u8005\u76ee\u6807\u538b\u7f29\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\uff01");
        }
        if (zipFile.replaceAll("\\\\", "/").contains(srcPath.replaceAll("\\\\", "/"))) {
            throw new RuntimeException("\u538b\u7f29\u53ef\u80fd\u9020\u6210\u6b7b\u5faa\u73af\uff0c\u8bf7\u66f4\u6539\u76ee\u6807\u538b\u7f29\u6587\u4ef6\u4f4d\u7f6e\uff01");
        }
    }

    private static void addToZip(String srcPath, ZipOutputStream zos) throws IOException {
        List filePathList = ZipUtil.getFilePathList(srcPath);
        int i = 0;
        while (i < filePathList.size()) {
            String filePath = (String)filePathList.get(i);
            File file = new File(filePath);
            String entryName = "";
            entryName = !srcPath.equals(filePath) ? filePath.substring(srcPath.length() + 1) : FileUtil.getFileName(filePath);
            if (!entryName.equals("")) {
                ZipEntry entry = new ZipEntry(entryName);
                entry.setTime(file.lastModified());
                zos.putNextEntry(entry);
                if (file.isFile()) {
                    BufferedInputStream is = null;
                    try {
                        is = new BufferedInputStream(new FileInputStream(filePath));
                        ZipUtil.copy(is, (OutputStream)zos);
                    }
                    catch (Throwable throwable) {
                        CloseUtil.closeInputStream(is);
                        throw throwable;
                    }
                    CloseUtil.closeInputStream(is);
                }
                zos.closeEntry();
            }
            ++i;
        }
    }

    private static List getFilePathList(String filePath) {
        ArrayList<String> filePathList = new ArrayList<String>();
        File file = new File(filePath);
        if (file.isDirectory()) {
            filePathList.add(String.valueOf(filePath) + "/");
            String[] subFilePaths = file.list();
            int i = 0;
            while (i < subFilePaths.length) {
                String subFilePath = String.valueOf(filePath) + "/" + subFilePaths[i];
                filePathList.addAll(ZipUtil.getFilePathList(subFilePath));
                ++i;
            }
        } else {
            filePathList.add(filePath);
        }
        return filePathList;
    }

    private static void copy(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[8024];
        while ((n = input.read(buffer)) != -1) {
            output.write(buffer, 0, n);
        }
    }

    private static List unzip(File file, String unzipDirPath, boolean flat) throws IOException {
        File file2;
        if (StringUtil.isEmpty(unzipDirPath) && new File(file.getParent()).isDirectory()) {
            unzipDirPath = String.valueOf(new File(file.getParent()).getPath()) + "/";
        }
        if (!(unzipDirPath = unzipDirPath.replaceAll("\\\\", "/")).endsWith("/")) {
            unzipDirPath = String.valueOf(unzipDirPath) + "/";
        }
        if (!(file2 = new File(unzipDirPath)).exists()) {
            file2.mkdirs();
        }
        ZipFile zipfile = new ZipFile(file);
        Enumeration e = zipfile.getEntries();
        if (!flat) {
            while (e.hasMoreElements()) {
                File dirPath;
                ZipEntry entry = (ZipEntry)e.nextElement();
                String filepath = String.valueOf(unzipDirPath) + entry.getName();
                if (!entry.isDirectory() || (dirPath = new File(filepath)).exists()) continue;
                dirPath.mkdirs();
            }
        }
        ArrayList<String> pathList = new ArrayList<String>();
        e = zipfile.getEntries();
        while (e.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)e.nextElement();
            String entryName = entry.getName();
            String filePath = flat && entryName.lastIndexOf("/") > 0 ? String.valueOf(unzipDirPath) + entryName.substring(entryName.lastIndexOf("/") + 1) : String.valueOf(unzipDirPath) + entryName;
            if (entry.isDirectory()) continue;
            File unzippedFile = new File(filePath);
            unzippedFile.createNewFile();
            BufferedInputStream is = null;
            BufferedOutputStream os = null;
            try {
                is = new BufferedInputStream(zipfile.getInputStream(entry));
                os = new BufferedOutputStream(new FileOutputStream(unzippedFile));
                ZipUtil.copy(is, os);
            }
            catch (Throwable throwable) {
                CloseUtil.closeInputStream(is);
                CloseUtil.closeOutputStream(os);
                throw throwable;
            }
            CloseUtil.closeInputStream(is);
            CloseUtil.closeOutputStream(os);
            pathList.add(filePath);
        }
        zipfile.close();
        return pathList;
    }
}

